/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.cli.CLIStatus;
import org.netbeans.modules.subversion.client.cli.Commandline;
import org.netbeans.modules.subversion.client.cli.SvnCommand;
import org.netbeans.modules.subversion.client.cli.commands.AddCommand;
import org.netbeans.modules.subversion.client.cli.commands.BlameCommand;
import org.netbeans.modules.subversion.client.cli.commands.CatCommand;
import org.netbeans.modules.subversion.client.cli.commands.CheckoutCommand;
import org.netbeans.modules.subversion.client.cli.commands.CommitCommand;
import org.netbeans.modules.subversion.client.cli.commands.CopyCommand;
import org.netbeans.modules.subversion.client.cli.commands.ImportCommand;
import org.netbeans.modules.subversion.client.cli.commands.InfoCommand;
import org.netbeans.modules.subversion.client.cli.commands.ListCommand;
import org.netbeans.modules.subversion.client.cli.commands.ListPropertiesCommand;
import org.netbeans.modules.subversion.client.cli.commands.LogCommand;
import org.netbeans.modules.subversion.client.cli.commands.MergeCommand;
import org.netbeans.modules.subversion.client.cli.commands.MkdirCommand;
import org.netbeans.modules.subversion.client.cli.commands.MoveCommand;
import org.netbeans.modules.subversion.client.cli.commands.PropertyDelCommand;
import org.netbeans.modules.subversion.client.cli.commands.PropertyGetCommand;
import org.netbeans.modules.subversion.client.cli.commands.PropertySetCommand;
import org.netbeans.modules.subversion.client.cli.commands.RelocateCommand;
import org.netbeans.modules.subversion.client.cli.commands.RemoveCommand;
import org.netbeans.modules.subversion.client.cli.commands.ResolvedCommand;
import org.netbeans.modules.subversion.client.cli.commands.RevertCommand;
import org.netbeans.modules.subversion.client.cli.commands.StatusCommand;
import org.netbeans.modules.subversion.client.cli.commands.SwitchToCommand;
import org.netbeans.modules.subversion.client.cli.commands.UpdateCommand;
import org.netbeans.modules.subversion.client.cli.commands.VersionCommand;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.SvnWcParser;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.Annotations;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNKeywords;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandlineClient
extends AbstractClientAdapter
implements ISVNClientAdapter {
    private String user;
    private String psswd;
    private File configDir;
    private NotificationHandler notificationHandler = new NotificationHandler();
    private SvnWcParser wcParser = new SvnWcParser();
    private Commandline cli = new Commandline();
    public static String ERR_CLI_NOT_AVALABLE = "commandline is not available";
    public static String ERR_JAVAHL_NOT_SUPPORTED = "unsupported javahl version";

    public void checkSupportedVersion() throws SVNClientException {
        VersionCommand versionCommand = new VersionCommand();
        try {
            this.config(versionCommand);
            this.cli.exec(versionCommand);
            this.checkErrors(versionCommand);
            if (!versionCommand.isSupported()) {
                Subversion.LOG.log(Level.WARNING, "Unsupported svn version. You need >= 1.3");
                throw new SVNClientException(ERR_CLI_NOT_AVALABLE + "\n" + versionCommand.getOutput());
            }
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.FINE, null, iOException);
            throw new SVNClientException(ERR_CLI_NOT_AVALABLE);
        }
    }

    public void checkSupportedJavaHlVersion() throws SVNClientException {
        VersionCommand versionCommand = new VersionCommand();
        try {
            this.config(versionCommand);
            this.cli.exec(versionCommand);
            this.checkErrors(versionCommand);
            if (!versionCommand.isSupportedJavaHl()) {
                Subversion.LOG.log(Level.WARNING, "JavaHl for svn version >=1.6 not supported yet.");
                throw new SVNClientException(ERR_JAVAHL_NOT_SUPPORTED + "\n" + versionCommand.getOutput());
            }
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.FINE, null, iOException);
            throw new SVNClientException(ERR_CLI_NOT_AVALABLE);
        }
    }

    public void addNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notificationHandler.add(iSVNNotifyListener);
    }

    public void removeNotifyListener(ISVNNotifyListener iSVNNotifyListener) {
        this.notificationHandler.remove(iSVNNotifyListener);
    }

    public void setUsername(String string) {
        this.user = string;
    }

    public void setPassword(String string) {
        this.psswd = string;
    }

    public void setConfigDirectory(File file) throws SVNClientException {
        this.configDir = file;
    }

    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void addFile(File file) throws SVNClientException {
        this.addFile(new File[]{file}, false);
    }

    public void addFile(File[] fileArray, boolean bl) throws SVNClientException {
        AddCommand addCommand = new AddCommand(fileArray, bl, false);
        this.exec(addCommand);
    }

    public void addDirectory(File file, boolean bl) throws SVNClientException {
        this.addDirectory(file, bl, false);
    }

    public void addDirectory(File file, boolean bl, boolean bl2) throws SVNClientException {
        AddCommand addCommand = new AddCommand(new File[]{file}, bl, bl2);
        this.exec(addCommand);
    }

    public void checkout(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        CheckoutCommand checkoutCommand = new CheckoutCommand(sVNUrl, file, sVNRevision, bl);
        this.exec(checkoutCommand);
    }

    public long commit(File[] fileArray, String string, boolean bl) throws SVNClientException {
        return this.commit(fileArray, string, false, bl);
    }

    public long commit(File[] fileArray, String string, boolean bl, boolean bl2) throws SVNClientException {
        int n = 0;
        CommitCommand commitCommand = null;
        while (true) {
            try {
                commitCommand = new CommitCommand(fileArray, bl, bl2, string);
                this.exec(commitCommand);
            }
            catch (SVNClientException sVNClientException) {
                if (sVNClientException.getMessage().startsWith("svn: Attempted to lock an already-locked dir")) {
                    Subversion.LOG.fine("ComandlineClient.comit() : " + sVNClientException.getMessage());
                    try {
                        if (++n > 14) {
                            throw sVNClientException;
                        }
                        Thread.sleep(n * 50);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    continue;
                }
                throw sVNClientException;
            }
            break;
        }
        return commitCommand != null ? commitCommand.getRevision() : -1L;
    }

    public ISVNDirEntry[] getList(SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        ListCommand listCommand = new ListCommand(sVNUrl, sVNRevision, bl);
        this.exec(listCommand);
        return listCommand.getEntries();
    }

    public ISVNInfo getInfo(SVNUrl sVNUrl) throws SVNClientException {
        return super.getInfo(sVNUrl);
    }

    public ISVNInfo getInfo(File file) throws SVNClientException {
        return this.getInfoFromWorkingCopy(file);
    }

    private ISVNInfo[] getInfo(File[] fileArray, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException, SVNClientException {
        if (fileArray == null || fileArray.length == 0) {
            return new ISVNInfo[0];
        }
        InfoCommand infoCommand = new InfoCommand(fileArray, sVNRevision, sVNRevision2);
        this.exec(infoCommand);
        ISVNInfo[] iSVNInfoArray = infoCommand.getInfo();
        return iSVNInfoArray;
    }

    public ISVNInfo getInfo(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        InfoCommand infoCommand = new InfoCommand(sVNUrl, sVNRevision, sVNRevision2);
        this.exec(infoCommand);
        return infoCommand.getInfo()[0];
    }

    public void copy(File file, File file2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(File file, SVNUrl sVNUrl, String string) throws SVNClientException {
        CopyCommand copyCommand = new CopyCommand(file, sVNUrl, string);
        this.exec(copyCommand);
    }

    public void copy(SVNUrl sVNUrl, File file, SVNRevision sVNRevision) throws SVNClientException {
        CopyCommand copyCommand = new CopyCommand(sVNUrl, file, sVNRevision);
        this.exec(copyCommand);
    }

    public void copy(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) throws SVNClientException {
        this.copy(sVNUrl, sVNUrl2, string, sVNRevision, false);
    }

    public void remove(SVNUrl[] sVNUrlArray, String string) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void remove(File[] fileArray, boolean bl) throws SVNClientException {
        RemoveCommand removeCommand = new RemoveCommand(fileArray, this.user, bl);
        this.exec(removeCommand);
    }

    public void doImport(File file, SVNUrl sVNUrl, String string, boolean bl) throws SVNClientException {
        ImportCommand importCommand = new ImportCommand(file, sVNUrl, bl, string);
        this.exec(importCommand);
    }

    public void mkdir(SVNUrl sVNUrl, String string) throws SVNClientException {
        MkdirCommand mkdirCommand = new MkdirCommand(sVNUrl, string);
        this.exec(mkdirCommand);
    }

    public void mkdir(SVNUrl sVNUrl, boolean bl, String string) throws SVNClientException {
        if (bl) {
            List<SVNUrl> list = this.getAllNotExistingParents(sVNUrl);
            for (SVNUrl sVNUrl2 : list) {
                this.mkdir(sVNUrl2, string);
            }
        } else {
            this.mkdir(sVNUrl, string);
        }
    }

    public void mkdir(File file) throws SVNClientException {
        MkdirCommand mkdirCommand = new MkdirCommand(file);
        this.exec(mkdirCommand);
    }

    public void move(File file, File file2, boolean bl) throws SVNClientException {
        MoveCommand moveCommand = new MoveCommand(file, file2, bl);
        this.exec(moveCommand);
    }

    public void move(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision) throws SVNClientException {
        MoveCommand moveCommand = new MoveCommand(sVNUrl, sVNUrl2, string, sVNRevision);
        this.exec(moveCommand);
    }

    public long update(File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        UpdateCommand updateCommand = new UpdateCommand(new File[]{file}, sVNRevision, bl, false);
        this.exec(updateCommand);
        return updateCommand.getRevision();
    }

    public long[] update(File[] fileArray, SVNRevision sVNRevision, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void revert(File file, boolean bl) throws SVNClientException {
        this.revert(new File[]{file}, bl);
    }

    public void revert(File[] fileArray, boolean bl) throws SVNClientException {
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        RevertCommand revertCommand = new RevertCommand(fileArray, bl);
        this.exec(revertCommand);
    }

    public ISVNStatus[] getStatus(File[] fileArray) throws SVNClientException {
        ISVNInfo iSVNInfo;
        HashMap<File, SVNStatusUnversioned> hashMap = new HashMap<File, SVNStatusUnversioned>();
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        for (File file : fileArray) {
            if (!this.isManaged(file)) {
                hashMap.put(file, new SVNStatusUnversioned(file));
                continue;
            }
            arrayList.add(file);
        }
        Object[] objectArray = new StatusCommand.Status[]{};
        if (!arrayList.isEmpty()) {
            StatusCommand statusCommand = new StatusCommand(arrayList.toArray(new File[arrayList.size()]), true, false, false, false);
            this.exec(statusCommand);
            objectArray = statusCommand.getStatusValues();
        }
        for (Object object : objectArray) {
            if (!this.isManaged(((StatusCommand.Status)object).getWcStatus())) continue;
            arrayList2.add(new File(((StatusCommand.Status)object).getPath()));
        }
        HashMap hashMap2 = new HashMap();
        if (!arrayList2.isEmpty()) {
            ISVNInfo[] iSVNInfoArray;
            ISVNInfo[] iSVNInfoArray2 = iSVNInfoArray = this.getInfo(arrayList2.toArray(new File[arrayList2.size()]), null, null);
            int n = iSVNInfoArray2.length;
            for (int i = 0; i < n; ++i) {
                Object object = iSVNInfoArray2[i];
                hashMap2.put(object.getFile(), object);
            }
        }
        HashMap<File, CLIStatus> hashMap3 = new HashMap<File, CLIStatus>();
        for (Object object : objectArray) {
            File file = new File(((StatusCommand.Status)object).getPath());
            if (object == null || !this.isManaged(((StatusCommand.Status)object).getWcStatus())) {
                if (!SVNStatusKind.UNVERSIONED.equals((Object)((StatusCommand.Status)object).getRepoStatus())) {
                    hashMap3.put(file, new CLIStatus((StatusCommand.Status)object, ((StatusCommand.Status)object).getPath()));
                    continue;
                }
                hashMap3.put(file, (CLIStatus)new SVNStatusUnversioned(file, SVNStatusKind.IGNORED.equals((Object)((StatusCommand.Status)object).getWcStatus())));
                continue;
            }
            iSVNInfo = (ISVNInfo)hashMap2.get(file);
            if (iSVNInfo == null) continue;
            hashMap3.put(file, new CLIStatus((StatusCommand.Status)object, iSVNInfo));
        }
        ArrayList arrayList3 = new ArrayList();
        for (File file : fileArray) {
            iSVNInfo = (ISVNStatus)hashMap3.get(file);
            if (iSVNInfo == null) {
                iSVNInfo = (ISVNStatus)hashMap.get(file);
            }
            if (iSVNInfo == null) continue;
            arrayList3.add(iSVNInfo);
        }
        return arrayList3.toArray(new ISVNStatus[arrayList3.size()]);
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        return this.getStatus(file, bl, bl2, bl3, false);
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SVNClientException {
        Object object;
        Object object2;
        StatusCommand.Status[] statusArray = null;
        try {
            if (!this.isManaged(file)) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            object2 = new StatusCommand(new File[]{file}, bl2, bl, bl3, bl4);
            this.exec((SvnCommand)object2);
            statusArray = ((StatusCommand)object2).getStatusValues();
        }
        catch (SVNClientException sVNClientException) {
            if (sVNClientException.getMessage().indexOf("is not a working copy") > -1) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            throw sVNClientException;
        }
        object2 = new ArrayList();
        for (StatusCommand.Status status : statusArray) {
            if (!this.isManaged(status.getWcStatus())) continue;
            object2.add(new File(status.getPath()));
        }
        StatusCommand.Status[] statusArray2 = this.getInfo(object2.toArray(new File[object2.size()]), null, null);
        HashMap<File, StatusCommand.Status> hashMap = new HashMap<File, StatusCommand.Status>();
        for (StatusCommand.Status status : statusArray2) {
            hashMap.put(status.getFile(), status);
        }
        HashMap hashMap2 = new HashMap();
        for (StatusCommand.Status status : statusArray) {
            File object3 = new File(status.getPath());
            if (status == null || !this.isManaged(status.getWcStatus())) {
                if (!SVNStatusKind.UNVERSIONED.equals((Object)status.getRepoStatus())) {
                    hashMap2.put(object3, new CLIStatus(status, status.getPath()));
                    continue;
                }
                hashMap2.put(object3, new SVNStatusUnversioned(object3, SVNStatusKind.IGNORED.equals((Object)status.getWcStatus())));
                continue;
            }
            object = (ISVNInfo)hashMap.get(object3);
            if (object == null) continue;
            hashMap2.put(object3, new CLIStatus(status, (ISVNInfo)object));
        }
        ArrayList arrayList = new ArrayList();
        for (StatusCommand.Status status : statusArray) {
            object = new File(status.getPath());
            ISVNStatus iSVNStatus = (ISVNStatus)hashMap2.get(object);
            if (iSVNStatus == null) {
                iSVNStatus = new SVNStatusUnversioned((File)object);
            }
            arrayList.add(iSVNStatus);
        }
        return arrayList.toArray(new ISVNStatus[arrayList.size()]);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return super.getLogMessages(sVNUrl, sVNRevision, sVNRevision2);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        return this.getLogMessages(sVNUrl, null, sVNRevision, sVNRevision2, false, bl);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, String[] stringArray, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        LogCommand logCommand = new LogCommand(sVNUrl, stringArray, sVNRevision, sVNRevision2, bl, bl2, 0L);
        return this.getLog(logCommand);
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l) throws SVNClientException {
        LogCommand logCommand = new LogCommand(sVNUrl, null, sVNRevision2, sVNRevision3, bl, bl2, l);
        return this.getLog(logCommand);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return super.getLogMessages(file, sVNRevision, sVNRevision2);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        return this.getLogMessages(file, sVNRevision, sVNRevision2, false, bl);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        return this.getLogMessages(file, sVNRevision, sVNRevision2, bl, bl2, 0L);
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2, long l) throws SVNClientException {
        ISVNInfo iSVNInfo = this.getInfoFromWorkingCopy(file);
        LogCommand logCommand = iSVNInfo.getSchedule().equals((Object)SVNScheduleKind.ADD) && iSVNInfo.getCopyUrl() != null ? new LogCommand(iSVNInfo.getCopyUrl(), null, sVNRevision, sVNRevision2, bl, bl2, l) : new LogCommand(file, sVNRevision, sVNRevision2, bl, bl2, l);
        return this.getLog(logCommand);
    }

    private ISVNLogMessage[] getLog(LogCommand logCommand) throws SVNClientException {
        this.exec(logCommand);
        return logCommand.getLogMessages();
    }

    public InputStream getContent(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        CatCommand catCommand = new CatCommand(sVNUrl, sVNRevision);
        this.exec(catCommand);
        return catCommand.getOutput();
    }

    public InputStream getContent(File file, SVNRevision sVNRevision) throws SVNClientException {
        CatCommand catCommand = new CatCommand(file, sVNRevision);
        this.exec(catCommand);
        return catCommand.getOutput();
    }

    public void propertySet(File file, String string, String string2, boolean bl) throws SVNClientException {
        ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
        PropertySetCommand propertySetCommand = new PropertySetCommand(string, string2, file, bl);
        this.exec(propertySetCommand);
        this.notifyChangedStatus(file, bl, iSVNStatusArray);
    }

    public void propertySet(File file, String string, File file2, boolean bl) throws SVNClientException, IOException {
        ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
        PropertySetCommand propertySetCommand = new PropertySetCommand(string, file2, file, bl);
        this.exec(propertySetCommand);
        this.notifyChangedStatus(file, bl, iSVNStatusArray);
    }

    public void propertyDel(File file, String string, boolean bl) throws SVNClientException {
        ISVNStatus[] iSVNStatusArray = this.getStatus(file, bl, false);
        PropertyDelCommand propertyDelCommand = new PropertyDelCommand(file, string, bl);
        this.exec(propertyDelCommand);
        this.notifyChangedStatus(file, bl, iSVNStatusArray);
    }

    public ISVNProperty propertyGet(File file, String string) throws SVNClientException {
        return this.propertyGet(new PropertyGetCommand(file, string), string, null, file);
    }

    public ISVNProperty propertyGet(SVNUrl sVNUrl, String string) throws SVNClientException {
        return super.propertyGet(sVNUrl, string);
    }

    public ISVNProperty propertyGet(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, String string) throws SVNClientException {
        return this.propertyGet(new PropertyGetCommand(sVNUrl, sVNRevision, sVNRevision2, string), string, sVNUrl, null);
    }

    ISVNProperty propertyGet(PropertyGetCommand propertyGetCommand, final String string, final SVNUrl sVNUrl, final File file) throws SVNClientException {
        this.exec(propertyGetCommand);
        final byte[] byArray = propertyGetCommand.getOutput();
        if (byArray == null || byArray.length == 0) {
            return null;
        }
        return new ISVNProperty(){

            public String getName() {
                return string;
            }

            public String getValue() {
                return new String(byArray);
            }

            public File getFile() {
                return file;
            }

            public SVNUrl getUrl() {
                return sVNUrl;
            }

            public byte[] getData() {
                return byArray;
            }
        };
    }

    public List getIgnoredPatterns(File file) throws SVNClientException {
        return super.getIgnoredPatterns(file);
    }

    public void addToIgnoredPatterns(File file, String string) throws SVNClientException {
        super.addToIgnoredPatterns(file, string);
    }

    public void setIgnoredPatterns(File file, List list) throws SVNClientException {
        super.setIgnoredPatterns(file, list);
    }

    public ISVNAnnotations annotate(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        return this.annotate(new BlameCommand(sVNUrl, sVNRevision, sVNRevision2), new CatCommand(sVNUrl, sVNRevision2));
    }

    public ISVNAnnotations annotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        ISVNInfo iSVNInfo = this.getInfoFromWorkingCopy(file);
        BlameCommand blameCommand = iSVNInfo.getSchedule().equals((Object)SVNScheduleKind.ADD) && iSVNInfo.getCopyUrl() != null ? new BlameCommand(iSVNInfo.getCopyUrl(), sVNRevision, sVNRevision2) : new BlameCommand(file, sVNRevision, sVNRevision2);
        return this.annotate(blameCommand, new CatCommand(file, sVNRevision2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISVNAnnotations annotate(BlameCommand blameCommand, CatCommand catCommand) throws SVNClientException {
        this.exec(blameCommand);
        Annotations.Annotation[] annotationArray = blameCommand.getAnnotation();
        this.exec(catCommand);
        InputStream inputStream = catCommand.getOutput();
        Annotations annotations = new Annotations();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            for (Annotations.Annotation annotation : annotationArray) {
                String string = null;
                try {
                    string = bufferedReader.readLine();
                }
                catch (IOException iOException) {
                    Subversion.LOG.log(Level.INFO, iOException.getMessage(), iOException);
                }
                annotation.setLine(string);
                annotations.addAnnotation(annotation);
            }
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return annotations;
    }

    public ISVNProperty[] getProperties(File file) throws SVNClientException {
        ListPropertiesCommand listPropertiesCommand = new ListPropertiesCommand(file, false);
        this.exec(listPropertiesCommand);
        List<String> list = listPropertiesCommand.getPropertyNames();
        ArrayList<ISVNProperty> arrayList = new ArrayList<ISVNProperty>(list.size());
        for (String string : list) {
            arrayList.add(this.propertyGet(file, string));
        }
        return arrayList.toArray(new ISVNProperty[arrayList.size()]);
    }

    public ISVNProperty[] getProperties(SVNUrl sVNUrl) throws SVNClientException {
        ListPropertiesCommand listPropertiesCommand = new ListPropertiesCommand(sVNUrl, false);
        this.exec(listPropertiesCommand);
        List<String> list = listPropertiesCommand.getPropertyNames();
        ArrayList<ISVNProperty> arrayList = new ArrayList<ISVNProperty>(list.size());
        for (String string : list) {
            arrayList.add(this.propertyGet(sVNUrl, string));
        }
        return arrayList.toArray(new ISVNProperty[arrayList.size()]);
    }

    public void resolved(File file) throws SVNClientException {
        ResolvedCommand resolvedCommand = new ResolvedCommand(file, false);
        this.exec(resolvedCommand);
    }

    public void cancelOperation() throws SVNClientException {
        this.cli.interrupt();
    }

    public void switchToUrl(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        SwitchToCommand switchToCommand = new SwitchToCommand(file, sVNUrl, sVNRevision, bl);
        this.exec(switchToCommand);
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2) throws SVNClientException {
        super.merge(sVNUrl, sVNRevision, sVNUrl2, sVNRevision2, file, bl, bl2);
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        super.merge(sVNUrl, sVNRevision, sVNUrl2, sVNRevision2, file, bl, bl2, bl3);
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SVNClientException {
        MergeCommand mergeCommand = new MergeCommand(sVNUrl, sVNUrl2, sVNRevision, sVNRevision2, file, bl2, bl, bl4, bl3);
        this.exec(mergeCommand);
    }

    public void relocate(String string, String string2, String string3, boolean bl) throws SVNClientException {
        RelocateCommand relocateCommand = new RelocateCommand(string, string2, string3, bl);
        this.exec(relocateCommand);
    }

    public ISVNStatus getSingleStatus(File file) throws SVNClientException {
        try {
            return this.wcParser.getSingleStatus(file);
        }
        catch (LocalSubversionException localSubversionException) {
            throw new SVNClientException((Throwable)localSubversionException);
        }
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2) throws SVNClientException {
        try {
            return this.wcParser.getStatus(file, bl, bl2);
        }
        catch (LocalSubversionException localSubversionException) {
            throw new SVNClientException((Throwable)localSubversionException);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws SVNClientException {
        try {
            return this.wcParser.getInfoFromWorkingCopy(file);
        }
        catch (LocalSubversionException localSubversionException) {
            throw new SVNClientException((Throwable)localSubversionException);
        }
    }

    private void exec(SvnCommand svnCommand) throws SVNClientException {
        try {
            this.config(svnCommand);
            this.cli.exec(svnCommand);
        }
        catch (IOException iOException) {
            Subversion.LOG.log(Level.FINE, null, iOException);
            throw new SVNClientException((Throwable)iOException);
        }
        this.checkErrors(svnCommand);
    }

    private void config(SvnCommand svnCommand) {
        svnCommand.setNotificationHandler(this.notificationHandler);
        svnCommand.setConfigDir(this.configDir);
        svnCommand.setUsername(this.user);
        svnCommand.setPassword(this.psswd);
    }

    private void checkErrors(SvnCommand svnCommand) throws SVNClientException {
        List<String> list = svnCommand.getCmdError();
        if (list == null || list.size() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            stringBuffer.append(list.get(i));
            if (i >= list.size() - 1) continue;
            stringBuffer.append('\n');
        }
        throw new SVNClientException(stringBuffer.toString());
    }

    private List<SVNUrl> getAllNotExistingParents(SVNUrl sVNUrl) throws SVNClientException {
        ArrayList<SVNUrl> arrayList = new ArrayList<SVNUrl>();
        if (sVNUrl == null) {
            return arrayList;
        }
        try {
            this.getInfo(sVNUrl);
        }
        catch (SVNClientException sVNClientException) {
            if (sVNClientException.getMessage().indexOf("Not a valid URL") > -1) {
                arrayList.addAll(this.getAllNotExistingParents(sVNUrl.getParent()));
                arrayList.add(sVNUrl);
            }
            throw sVNClientException;
        }
        return arrayList;
    }

    private boolean isManaged(SVNStatusKind sVNStatusKind) {
        return !sVNStatusKind.equals((Object)SVNStatusKind.UNVERSIONED) && !sVNStatusKind.equals((Object)SVNStatusKind.NONE) && !sVNStatusKind.equals((Object)SVNStatusKind.IGNORED) && !sVNStatusKind.equals((Object)SVNStatusKind.EXTERNAL);
    }

    private boolean hasMetadata(File file) {
        return new File(file, SvnUtils.SVN_ENTRIES_DIR).canRead();
    }

    private boolean isManaged(File file) {
        return this.hasMetadata(file.getParentFile()) || this.hasMetadata(file);
    }

    public long[] commitAcrossWC(File[] fileArray, String string, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        return super.commitAcrossWC(fileArray, string, bl, bl2, bl3);
    }

    public ISVNDirEntry getDirEntry(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry getDirEntry(File file, SVNRevision sVNRevision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doExport(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void doExport(File file, File file2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setRevProperty(SVNUrl sVNUrl, SVNRevision.Number number, String string, String string2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File file, SVNRevision sVNRevision, File file2, SVNRevision sVNRevision2, File file3, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File file, File file2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, File file, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, File file2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNKeywords getKeywords(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setKeywords(File file, SVNKeywords sVNKeywords, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNKeywords addKeywords(File file, SVNKeywords sVNKeywords) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNKeywords removeKeywords(File file, SVNKeywords sVNKeywords) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void createRepository(File file, String string) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void lock(SVNUrl[] sVNUrlArray, String string, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unlock(SVNUrl[] sVNUrlArray, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void lock(File[] fileArray, String string, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void unlock(File[] fileArray, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean statusReturnsRemoteInfo() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean canCommitAcrossWC() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getAdminDirectoryName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isAdminDirectory(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPasswordCallback(ISVNPromptUserPassword iSVNPromptUserPassword) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(File file, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void cleanup(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void notifyChangedStatus(File file, boolean bl, ISVNStatus[] iSVNStatusArray) throws SVNClientException {
        HashMap<File, ISVNStatus> hashMap = new HashMap<File, ISVNStatus>();
        ISVNStatus[] iSVNStatusArray2 = iSVNStatusArray;
        int n = iSVNStatusArray2.length;
        for (int i = 0; i < n; ++i) {
            ISVNStatus iSVNStatus = iSVNStatusArray2[i];
            hashMap.put(iSVNStatus.getFile(), iSVNStatus);
        }
        for (ISVNStatus iSVNStatus : iSVNStatusArray2 = this.getStatus(file, bl, false)) {
            ISVNStatus iSVNStatus2 = (ISVNStatus)hashMap.get(iSVNStatus.getFile());
            if ((iSVNStatus2 != null || iSVNStatus == null) && iSVNStatus2.getTextStatus() == iSVNStatus.getTextStatus() && iSVNStatus2.getPropStatus() == iSVNStatus.getPropStatus()) continue;
            this.notificationHandler.notifyListenersOfChange(iSVNStatus.getPath());
        }
    }

    public void getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l, boolean bl3, String[] stringArray, ISVNLogMessageCallback iSVNLogMessageCallback) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l, boolean bl3, String[] stringArray, ISVNLogMessageCallback iSVNLogMessageCallback) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNInfo[] getInfo(File file, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isThreadsafe() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addConflictResolutionCallback(ISVNConflictResolver iSVNConflictResolver) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setProgressListener(ISVNProgressListener iSVNProgressListener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void checkout(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, int n, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNDirEntry[] getList(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(File[] fileArray, SVNUrl sVNUrl, String string, boolean bl, boolean bl2) throws SVNClientException {
        for (File file : fileArray) {
            CopyCommand copyCommand = new CopyCommand(file, sVNUrl, string, bl2);
            this.exec(copyCommand);
        }
    }

    public void copy(SVNUrl sVNUrl, File file, SVNRevision sVNRevision, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copy(SVNUrl sVNUrl, SVNUrl sVNUrl2, String string, SVNRevision sVNRevision, boolean bl) throws SVNClientException {
        CopyCommand copyCommand = new CopyCommand(sVNUrl, sVNUrl2, string, sVNRevision, bl);
        this.exec(copyCommand);
    }

    public void copy(SVNUrl[] sVNUrlArray, SVNUrl sVNUrl, String string, SVNRevision sVNRevision, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long update(File file, SVNRevision sVNRevision, int n, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public long[] update(File[] fileArray, SVNRevision sVNRevision, int n, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getLogMessages(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, boolean bl, boolean bl2, long l, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public InputStream getContent(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, File file, int n, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void diff(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, File file, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNAnnotations annotate(File file, SVNRevision sVNRevision, SVNRevision sVNRevision2, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void resolve(File file, int n) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void switchToUrl(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, int n, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void switchToUrl(File file, SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, int n, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, File file, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void mergeReintegrate(SVNUrl sVNUrl, SVNRevision sVNRevision, File file, boolean bl, boolean bl2) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void merge(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevisionRange[] sVNRevisionRangeArray, File file, boolean bl, int n, boolean bl2, boolean bl3, boolean bl4) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNMergeInfo getMergeInfo(File file, SVNRevision sVNRevision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNMergeInfo getMergeInfo(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getMergeinfoLog(int n, File file, SVNRevision sVNRevision, SVNUrl sVNUrl, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ISVNLogMessage[] getMergeinfoLog(int n, SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNUrl sVNUrl2, SVNRevision sVNRevision2, int n, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl sVNUrl, SVNRevision sVNRevision, SVNRevision sVNRevision2, SVNRevision sVNRevision3, int n, boolean bl) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] suggestMergeSources(File file) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String[] suggestMergeSources(SVNUrl sVNUrl, SVNRevision sVNRevision) throws SVNClientException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    class NotificationHandler
    extends SVNNotificationHandler {
        NotificationHandler() {
        }
    }
}

