/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client.parser;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.subversion.client.parser.EntriesCache;
import org.netbeans.modules.subversion.client.parser.LocalSubversionException;
import org.netbeans.modules.subversion.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.client.parser.ParserSvnStatus;
import org.netbeans.modules.subversion.client.parser.WorkingCopyDetails;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SvnWcParser {
    private WorkingCopyDetails getWCDetails(File file) throws IOException, SAXException {
        Map<String, String> map = EntriesCache.getInstance().getFileAttributes(file);
        return WorkingCopyDetails.createWorkingCopy(file, map);
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2) throws LocalSubversionException {
        List<ISVNStatus> list = this.getStatus(file, bl);
        return list.toArray(new ISVNStatus[list.size()]);
    }

    private List<ISVNStatus> getStatus(File file, boolean bl) throws LocalSubversionException {
        ArrayList<ISVNStatus> arrayList = new ArrayList<ISVNStatus>(20);
        arrayList.add(this.getSingleStatus(file));
        File[] fileArray = file.listFiles();
        if (fileArray != null && fileArray.length > 0) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (SvnUtils.isPartOfSubversionMetadata(fileArray[i]) || SvnUtils.isAdministrative(file)) continue;
                if (bl && fileArray[i].isDirectory()) {
                    arrayList.addAll(this.getStatus(fileArray[i], bl));
                    continue;
                }
                arrayList.add(this.getSingleStatus(fileArray[i]));
            }
        }
        return arrayList;
    }

    public ISVNStatus getSingleStatus(File file) throws LocalSubversionException {
        String string = SVNStatusKind.NORMAL.toString();
        String string2 = SVNStatusKind.NONE.toString();
        try {
            WorkingCopyDetails workingCopyDetails = this.getWCDetails(file);
            if (workingCopyDetails.isHandled()) {
                String string3;
                if (workingCopyDetails.propertiesExist() || workingCopyDetails.getBasePropertiesFile() != null && workingCopyDetails.getBasePropertiesFile().exists()) {
                    string2 = SVNStatusKind.NORMAL.toString();
                    if (workingCopyDetails.propertiesModified()) {
                        string2 = SVNStatusKind.MODIFIED.toString();
                    }
                }
                if (workingCopyDetails.isFile() && workingCopyDetails.textModified()) {
                    string = SVNStatusKind.MODIFIED.toString();
                }
                if ((string3 = workingCopyDetails.getValue("schedule")) != null) {
                    if (string3.equals("add")) {
                        string = SVNStatusKind.ADDED.toString();
                        string2 = SVNStatusKind.NONE.toString();
                    } else if (string3.equals("delete")) {
                        string = SVNStatusKind.DELETED.toString();
                        string2 = SVNStatusKind.NONE.toString();
                    } else if (string3.equals("replace")) {
                        string = SVNStatusKind.REPLACED.toString();
                        string2 = SVNStatusKind.NONE.toString();
                    }
                }
                assert (string.equals(SVNStatusKind.NORMAL.toString()) || string.equals(SVNStatusKind.MODIFIED.toString()) || string.equals(SVNStatusKind.ADDED.toString()) || string.equals(SVNStatusKind.REPLACED.toString()) || string.equals(SVNStatusKind.DELETED.toString()));
                if (!SVNStatusKind.DELETED.toString().equals(string) && !file.exists()) {
                    string = SVNStatusKind.MISSING.toString();
                }
                if ((string3 = workingCopyDetails.getValue("deleted")) != null && string3.equals("true")) {
                    string = SVNStatusKind.UNVERSIONED.toString();
                    string2 = SVNStatusKind.NONE.toString();
                }
                String string4 = workingCopyDetails.getValue("url");
                long l = workingCopyDetails.getLongValue("revision");
                String string5 = workingCopyDetails.getValue("kind", "normal");
                String string6 = workingCopyDetails.getValue("last-author");
                long l2 = workingCopyDetails.getLongValue("committed-rev");
                Date date = workingCopyDetails.getDateValue("committed-date");
                boolean bl = workingCopyDetails.getBooleanValue("copied");
                String string7 = null;
                if (bl) {
                    string7 = workingCopyDetails.getValue("copyfrom-url");
                }
                File file2 = null;
                File file3 = null;
                File file4 = null;
                string3 = workingCopyDetails.getValue("conflict-wrk");
                if (string3 != null && string3.length() > 0) {
                    file4 = new File(file.getParentFile(), string3);
                }
                if ((string3 = workingCopyDetails.getValue("conflict-new")) != null && string3.length() > 0) {
                    file2 = new File(file.getParentFile(), string3);
                }
                if ((string3 = workingCopyDetails.getValue("conflict-old")) != null && string3.length() > 0) {
                    file3 = new File(file.getParentFile(), string3);
                }
                if (file2 != null || file3 != null) {
                    string = SVNStatusKind.CONFLICTED.toString();
                }
                Date date2 = workingCopyDetails.getDateValue("lock-creation-date");
                String string8 = null;
                String string9 = null;
                if (date2 != null) {
                    string8 = workingCopyDetails.getValue("lock-comment");
                    string9 = workingCopyDetails.getValue("lock-owner");
                }
                return new ParserSvnStatus(file, string4, l, string5, string, string2, string6, l2, date, bl, string7, file2, file3, file4, date2, string8, string9);
            }
            return new ParserSvnStatus(file, workingCopyDetails.getValue("url"), 0L, "unknown", SVNStatusKind.UNVERSIONED.toString(), SVNStatusKind.UNVERSIONED.toString(), null, 0L, null, false, null, null, null, null, null, null, null);
        }
        catch (IOException iOException) {
            throw new LocalSubversionException(iOException);
        }
        catch (SAXException sAXException) {
            throw new LocalSubversionException(sAXException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LocalSubversionException(illegalArgumentException);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File file) throws LocalSubversionException {
        ParserSvnInfo parserSvnInfo = null;
        try {
            WorkingCopyDetails workingCopyDetails = this.getWCDetails(file);
            if (workingCopyDetails.isHandled()) {
                String string = workingCopyDetails.getValue("url");
                String string2 = workingCopyDetails.getValue("repos");
                String string3 = workingCopyDetails.getValue("uuid");
                String string4 = workingCopyDetails.getValue("schedule");
                if (string4 == null) {
                    string4 = SVNScheduleKind.NORMAL.toString();
                }
                long l = workingCopyDetails.getLongValue("revision");
                boolean bl = workingCopyDetails.getBooleanValue("copied");
                String string5 = null;
                long l2 = 0L;
                if (bl) {
                    string5 = workingCopyDetails.getValue("copyfrom-url");
                    l2 = workingCopyDetails.getLongValue("copyfrom-rev");
                }
                Date date = workingCopyDetails.getDateValue("committed-date");
                long l3 = workingCopyDetails.getLongValue("committed-rev");
                String string6 = workingCopyDetails.getValue("last-author");
                Date date2 = workingCopyDetails.getDateValue("prop-time");
                Date date3 = workingCopyDetails.getDateValue("text-time");
                Date date4 = workingCopyDetails.getDateValue("lock-creation-date");
                String string7 = null;
                String string8 = null;
                if (date4 != null) {
                    string7 = workingCopyDetails.getValue("lock-comment");
                    string8 = workingCopyDetails.getValue("lock-owner");
                }
                String string9 = workingCopyDetails.getValue("kind", "normal");
                parserSvnInfo = new ParserSvnInfo(file, string, string2, string3, string4, l, bl, string5, l2, date, l3, string6, date2, date3, date4, string8, string7, string9, workingCopyDetails.getPropertiesFile(), workingCopyDetails.getBasePropertiesFile());
            } else {
                String string = workingCopyDetails.getValue("url");
                String string10 = workingCopyDetails.getValue("repos");
                String string11 = workingCopyDetails.getValue("uuid");
                parserSvnInfo = new ParserSvnInfo(file, string, string10, string11, SVNScheduleKind.NORMAL.toString(), 0L, false, null, 0L, null, 0L, null, null, null, null, null, null, SVNNodeKind.UNKNOWN.toString(), null, null);
            }
        }
        catch (IOException iOException) {
            throw new LocalSubversionException(iOException);
        }
        catch (SAXException sAXException) {
            throw new LocalSubversionException(sAXException);
        }
        return parserSvnInfo;
    }
}

