/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.config;

import java.io.File;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.netbeans.modules.proxy.Base64Encoder;
import org.netbeans.modules.subversion.config.KVFile;
import org.netbeans.modules.subversion.config.SVNCredentialFile;
import org.netbeans.modules.subversion.config.SvnConfigFiles;
import org.openide.filesystems.FileUtil;

public class CertificateFile
extends SVNCredentialFile {
    private static final KVFile.Key CERT = new KVFile.Key(0, "ascii_cert");
    private static final KVFile.Key FAILURES = new KVFile.Key(1, "failures");
    private static final KVFile.Key REALMSTRING = new KVFile.Key(2, "svn:realmstring");
    private static final String NEWLINE = System.getProperty("line.separator");

    public CertificateFile(X509Certificate x509Certificate, String string, int n, boolean bl) throws CertificateEncodingException {
        super(CertificateFile.getNBCertFile(string));
        this.setCert(x509Certificate);
        this.setFailures(n);
        this.setRealmString(string);
        if (bl) {
            this.getFile().deleteOnExit();
        }
    }

    private void setCert(X509Certificate x509Certificate) throws CertificateEncodingException {
        String string = Base64Encoder.encode((byte[])x509Certificate.getEncoded());
        this.setValue(this.getCertKey(), string.getBytes());
    }

    protected void setRealmString(String string) {
        this.setValue(this.getRealmstringKey(), string);
    }

    protected String getRealmString() {
        return this.getStringValue(this.getRealmstringKey());
    }

    private void setFailures(int n) {
        this.setValue(this.getFailuresKey(), String.valueOf(n));
    }

    public static File getSystemCertFile(String string) {
        File file = new File(SvnConfigFiles.getUserConfigPath() + "auth/svn.ssl.server/" + CertificateFile.getFileName(string));
        return FileUtil.normalizeFile((File)file);
    }

    public static File getNBCertFile(String string) {
        File file = new File(SvnConfigFiles.getNBConfigPath() + "auth/svn.ssl.server/" + CertificateFile.getFileName(string));
        return FileUtil.normalizeFile((File)file);
    }

    private KVFile.Key getCertKey() {
        return this.getKey(CERT);
    }

    private KVFile.Key getFailuresKey() {
        return this.getKey(FAILURES);
    }

    private KVFile.Key getRealmstringKey() {
        return this.getKey(REALMSTRING);
    }
}

