/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.browser;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.UIManager;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.browser.Browser;
import org.netbeans.modules.subversion.ui.browser.BrowserClient;
import org.netbeans.modules.subversion.ui.browser.CreateFolderAction;
import org.netbeans.modules.subversion.ui.browser.WaitNode;
import org.netbeans.modules.subversion.ui.search.SvnSearch;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryPathNode
extends AbstractNode {
    private static final String ICON_KEY_UIMANAGER = "Tree.closedIcon";
    private static final String OPENED_ICON_KEY_UIMANAGER = "Tree.openIcon";
    private static final String ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.icon";
    private static final String OPENED_ICON_KEY_UIMANAGER_NB = "Nb.Explorer.Folder.openedIcon";
    private RepositoryPathEntry entry;
    private final BrowserClient client;
    private boolean repositoryFolder;
    private boolean isListed = false;
    static final String PROPERTY_NAME_REVISION = "revision";
    static final String PROPERTY_NAME_DATE = "date";
    static final String PROPERTY_NAME_AUTHOR = "author";
    static final String PROPERTY_NAME_HISTORY = "history";
    private static final String HISTORY_DISPLAY_NAME = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Name");
    private static final String HISTORY_SHORT_DESC = NbBundle.getMessage(RepositoryPathNode.class, (String)"LBL_BrowserTree_History_Short_Desc");

    static RepositoryPathNode createRepositoryPathNode(BrowserClient browserClient, RepositoryFile repositoryFile) {
        return RepositoryPathNode.createRepositoryPathNode(browserClient, new RepositoryPathEntry(repositoryFile, SVNNodeKind.DIR, new SVNRevision(0), null, ""));
    }

    static RepositoryPathNode createRepositoryPathNode(BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry) {
        RepositoryPathNode repositoryPathNode = new RepositoryPathNode(browserClient, repositoryPathEntry, true);
        return repositoryPathNode;
    }

    static RepositoryPathNode createPreselectedPathNode(BrowserClient browserClient, RepositoryFile repositoryFile) {
        return RepositoryPathNode.createDelayedExpandNode(browserClient, repositoryFile);
    }

    static RepositoryPathNode createRepositoryRootNode(BrowserClient browserClient, RepositoryFile repositoryFile) {
        return RepositoryPathNode.createDelayedExpandNode(browserClient, repositoryFile);
    }

    private static RepositoryPathNode createDelayedExpandNode(BrowserClient browserClient, RepositoryFile repositoryFile) {
        return new DelayedExpandNode(browserClient, new RepositoryPathEntry(repositoryFile, SVNNodeKind.DIR, new SVNRevision(0), null, ""), true);
    }

    private RepositoryPathNode(BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry, boolean bl) {
        super((Children)(repositoryPathEntry.getSvnNodeKind() == SVNNodeKind.DIR ? new RepositoryPathChildren(browserClient) : Children.LEAF));
        this.entry = repositoryPathEntry;
        this.client = browserClient;
        this.repositoryFolder = bl;
        this.initProperties();
    }

    public Image getIcon(int n) {
        if (this.entry.getSvnNodeKind() == SVNNodeKind.DIR) {
            return this.getTreeFolderIcon(false);
        }
        return super.getIcon(n);
    }

    public Image getOpenedIcon(int n) {
        if (this.entry.getSvnNodeKind() == SVNNodeKind.DIR) {
            return this.getTreeFolderIcon(true);
        }
        return super.getOpenedIcon(n);
    }

    private Image getTreeFolderIcon(boolean bl) {
        Image image = null;
        Icon icon = UIManager.getIcon(bl ? OPENED_ICON_KEY_UIMANAGER : ICON_KEY_UIMANAGER);
        if (icon != null) {
            image = ImageUtilities.icon2Image((Icon)icon);
        } else {
            image = (Image)UIManager.get(bl ? OPENED_ICON_KEY_UIMANAGER_NB : ICON_KEY_UIMANAGER_NB);
            if (image == null) {
                image = ImageUtilities.loadImage((String)"org/openide/loaders/defaultFolder.gif");
            }
        }
        assert (image != null);
        return image;
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new RevisionProperty());
        set.put((Node.Property)new DateProperty());
        set.put((Node.Property)new AuthorProperty());
        set.put((Node.Property)new HistoryProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getName() {
        if (this.entry.getRepositoryFile().isRepositoryRoot()) {
            return this.entry.getRepositoryFile().getRepositoryUrl().toString();
        }
        return this.entry.getRepositoryFile().getName();
    }

    public void setName(String string) {
        String string2 = this.getName();
        if (!string2.equals(string)) {
            this.renameNode(this, string, 0);
            this.fireNameChange(string2, string);
        }
    }

    private void renameNode(RepositoryPathNode repositoryPathNode, String string, int n) {
        repositoryPathNode.entry = new RepositoryPathEntry(repositoryPathNode.entry.getRepositoryFile().replaceLastSegment(string, n), repositoryPathNode.entry.getSvnNodeKind(), repositoryPathNode.entry.getLastChangedRevision(), repositoryPathNode.entry.getLastChangedDate(), repositoryPathNode.entry.getLastChangedAuthor());
        Children children = repositoryPathNode.getChildren();
        Node[] nodeArray = children.getNodes();
        ++n;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!(nodeArray[i] instanceof RepositoryPathNode)) continue;
            this.renameNode((RepositoryPathNode)nodeArray[i], string, n);
        }
    }

    public Action[] getActions(boolean bl) {
        return this.client.getActions();
    }

    public RepositoryPathEntry getEntry() {
        return this.entry;
    }

    public BrowserClient getClient() {
        return this.client;
    }

    public boolean canRename() {
        return !this.repositoryFolder;
    }

    private void setRepositoryFolder(boolean bl) {
        this.repositoryFolder = bl;
    }

    void expand() {
        if (this.isListed) {
            return;
        }
        this.isListed = true;
        Children children = this.getChildren();
        if (children instanceof RepositoryPathChildren) {
            ((RepositoryPathChildren)this.getChildren()).listRepositoryPath(this.entry);
        }
    }

    private static class DelayedExpandNode
    extends RepositoryPathNode {
        private final int IGNORE_EXPANDS = 0;
        private int expanded = 0;

        public DelayedExpandNode(BrowserClient browserClient, RepositoryPathEntry repositoryPathEntry, boolean bl) {
            super(browserClient, repositoryPathEntry, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void expand() {
            try {
                if (this.expanded < 0) {
                    return;
                }
                super.expand();
            }
            finally {
                if (this.expanded <= 0) {
                    ++this.expanded;
                }
            }
        }
    }

    static class RepositoryPathEntry {
        private final SVNNodeKind svnNodeKind;
        private final RepositoryFile file;
        private final SVNRevision revision;
        private Date date;
        private final String author;

        RepositoryPathEntry(RepositoryFile repositoryFile, SVNNodeKind sVNNodeKind, SVNRevision sVNRevision, Date date, String string) {
            this.svnNodeKind = sVNNodeKind;
            this.file = repositoryFile;
            this.revision = sVNRevision;
            this.date = date;
            this.author = string;
        }

        public SVNNodeKind getSvnNodeKind() {
            return this.svnNodeKind;
        }

        RepositoryFile getRepositoryFile() {
            return this.file;
        }

        SVNRevision getLastChangedRevision() {
            return this.revision;
        }

        Date getLastChangedDate() {
            return this.date;
        }

        String getLastChangedAuthor() {
            return this.author != null ? this.author : "";
        }
    }

    private class HistoryPropertyEditor
    extends PropertyEditorSupport {
        public HistoryPropertyEditor() {
            this.setValue("");
        }

        public boolean supportsCustomEditor() {
            return true;
        }

        public Component getCustomEditor() {
            SVNRevision sVNRevision = RepositoryPathNode.this.entry.getLastChangedRevision();
            SVNUrl sVNUrl = RepositoryPathNode.this.entry.getRepositoryFile().getRepositoryUrl();
            SVNUrl sVNUrl2 = RepositoryPathNode.this.entry.getRepositoryFile().getFileUrl();
            SvnSearch svnSearch = new SvnSearch(new RepositoryFile(sVNUrl, sVNUrl2, sVNRevision));
            return svnSearch.getSearchPanel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class NodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected NodeProperty(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                Object object = this.getValue();
                return object != null ? object.toString() : "";
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }

        public boolean canWrite() {
            return false;
        }

        public PropertyEditor getPropertyEditor() {
            return new PropertyEditorSupport();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HistoryProperty
    extends PropertySupport.ReadOnly<String> {
        public HistoryProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_HISTORY, String.class, HISTORY_DISPLAY_NAME, HISTORY_SHORT_DESC);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return "";
        }

        public String toString() {
            try {
                String string = this.getValue();
                return string != null ? string.toString() : "";
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            return new HistoryPropertyEditor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AuthorProperty
    extends NodeProperty<String> {
        public AuthorProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_AUTHOR, String.class, RepositoryPathNode.PROPERTY_NAME_AUTHOR, RepositoryPathNode.PROPERTY_NAME_AUTHOR);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedAuthor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateProperty
    extends NodeProperty<String> {
        public DateProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_DATE, String.class, RepositoryPathNode.PROPERTY_NAME_DATE, RepositoryPathNode.PROPERTY_NAME_DATE);
        }

        public String getValue() throws IllegalAccessException, InvocationTargetException {
            Date date = RepositoryPathNode.this.entry.getLastChangedDate();
            return date != null ? DateFormat.getDateTimeInstance().format(date) : "";
        }
    }

    private class RevisionProperty
    extends NodeProperty {
        public RevisionProperty() {
            super(RepositoryPathNode.PROPERTY_NAME_REVISION, String.class, RepositoryPathNode.PROPERTY_NAME_REVISION, RepositoryPathNode.PROPERTY_NAME_REVISION);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return RepositoryPathNode.this.entry.getLastChangedRevision();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositoryPathChildren
    extends Children.Keys {
        private final BrowserClient client;
        private Node[] previousNodes = null;

        public RepositoryPathChildren(BrowserClient browserClient) {
            this.client = browserClient;
        }

        protected void addNotify() {
            super.addNotify();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_LIST);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof Node) {
                return new Node[]{(Node)object};
            }
            RepositoryPathEntry repositoryPathEntry = (RepositoryPathEntry)object;
            if (this.previousNodes != null) {
                for (Node node : this.previousNodes) {
                    if (!(node instanceof RepositoryPathNode) || !((RepositoryPathNode)node).entry.getRepositoryFile().getName().equals(repositoryPathEntry.getRepositoryFile().getName())) continue;
                    return null;
                }
            }
            RepositoryPathNode repositoryPathNode = RepositoryPathNode.createRepositoryPathNode(this.client, repositoryPathEntry);
            return new Node[]{repositoryPathNode};
        }

        public void listRepositoryPath(final RepositoryPathEntry repositoryPathEntry) {
            this.previousNodes = this.getNodes();
            WaitNode waitNode = new WaitNode(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2001"));
            this.setKeys(Collections.singleton(waitNode));
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(repositoryPathEntry.getRepositoryFile().getRepositoryUrl());
            SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void perform() {
                    try {
                        List<RepositoryPathEntry> list = RepositoryPathChildren.this.client.listRepositoryPath(repositoryPathEntry, this);
                        if (this.isCanceled()) {
                            return;
                        }
                        Collection collection = RepositoryPathChildren.this.getPreviousNodeEntries();
                        ArrayList<RepositoryPathEntry> arrayList = new ArrayList<RepositoryPathEntry>();
                        if (list == null) {
                            RepositoryPathNode repositoryPathNode = (RepositoryPathNode)RepositoryPathChildren.this.getNode();
                            repositoryPathNode.setRepositoryFolder(false);
                        } else {
                            if (!RepositoryPathChildren.this.isCreativeBrowser(RepositoryPathChildren.this.client)) {
                                RepositoryPathChildren.this.removePreselectedFolders(list, false);
                            }
                            ArrayList<RepositoryPathEntry> arrayList2 = new ArrayList<RepositoryPathEntry>();
                            for (RepositoryPathEntry repositoryPathEntry3 : list) {
                                boolean bl = false;
                                for (RepositoryPathEntry repositoryPathEntry2 : collection) {
                                    if (!repositoryPathEntry2.getRepositoryFile().getName().equals(repositoryPathEntry3.getRepositoryFile().getName())) continue;
                                    if (!repositoryPathEntry3.getSvnNodeKind().equals((Object)repositoryPathEntry2.getSvnNodeKind())) {
                                        arrayList2.add(repositoryPathEntry3);
                                        break;
                                    }
                                    bl = true;
                                    break;
                                }
                                if (bl) continue;
                                arrayList.add(repositoryPathEntry3);
                            }
                            RepositoryPathChildren.this.removePreselectedFolders(arrayList2, true);
                        }
                        RepositoryPathChildren.access$702(RepositoryPathChildren.this, null);
                        RepositoryPathChildren.this.setKeys(arrayList);
                    }
                    catch (SVNClientException sVNClientException) {
                        Collection collection = RepositoryPathChildren.this.getPreviousNodeEntries();
                        if (collection.size() == 0) {
                            RepositoryPathChildren.this.setKeys(Collections.singleton(RepositoryPathChildren.errorNode((Exception)((Object)sVNClientException))));
                        }
                        return;
                    }
                    finally {
                        RepositoryPathChildren.access$702(RepositoryPathChildren.this, null);
                    }
                }
            };
            svnProgressSupport.start(requestProcessor, repositoryPathEntry.getRepositoryFile().getRepositoryUrl(), NbBundle.getMessage(Browser.class, (String)"BK2001"));
            Node node = this.getNode().getParentNode();
            if (node != null) {
                ((RepositoryPathNode)node).expand();
            }
        }

        private Collection<RepositoryPathEntry> getPreviousNodeEntries() {
            ArrayList<RepositoryPathEntry> arrayList = new ArrayList<RepositoryPathEntry>();
            if (this.previousNodes != null) {
                for (Node node : this.previousNodes) {
                    if (!(node instanceof RepositoryPathNode)) continue;
                    arrayList.add(((RepositoryPathNode)node).entry);
                }
            }
            return arrayList;
        }

        private String getLastPathSegment(RepositoryPathEntry repositoryPathEntry) {
            String[] stringArray = repositoryPathEntry.getRepositoryFile().getPathSegments();
            return stringArray.length > 0 ? stringArray[stringArray.length - 1] : null;
        }

        private static Node errorNode(Exception exception) {
            AbstractNode abstractNode = new AbstractNode(Children.LEAF);
            abstractNode.setDisplayName(NbBundle.getMessage(RepositoryPathNode.class, (String)"BK2002"));
            abstractNode.setShortDescription(exception.getLocalizedMessage());
            return abstractNode;
        }

        private boolean isCreativeBrowser(BrowserClient browserClient) {
            Action[] actionArray = browserClient.getActions();
            for (int i = 0; i < actionArray.length; ++i) {
                if (!(actionArray[i] instanceof CreateFolderAction)) continue;
                return true;
            }
            return false;
        }

        private void removePreselectedFolders(Collection collection, boolean bl) {
            Node[] nodeArray = this.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                String string;
                if (!(nodeArray[i] instanceof RepositoryPathNode) || (string = this.getLastPathSegment(((RepositoryPathNode)nodeArray[i]).getEntry())) == null) continue;
                boolean bl2 = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2 = this.getLastPathSegment((RepositoryPathEntry)iterator.next());
                    if (string2 == null || !string2.equals(string)) continue;
                    bl2 = true;
                    break;
                }
                if (bl2 != bl) continue;
                this.remove(new Node[]{nodeArray[i]});
            }
        }

        static /* synthetic */ Node[] access$702(RepositoryPathChildren repositoryPathChildren, Node[] nodeArray) {
            repositoryPathChildren.previousNodes = nodeArray;
            return nodeArray;
        }
    }
}

