/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.subversion.FileInformation;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.util.NbBundle;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitTableModel
extends AbstractTableModel {
    public static final String COLUMN_NAME_NAME = "name";
    public static final String COLUMN_NAME_STATUS = "status";
    public static final String COLUMN_NAME_ACTION = "action";
    public static final String COLUMN_NAME_PATH = "path";
    public static final String COLUMN_NAME_BRANCH = "branch";
    private Set<SVNUrl> repositoryRoots;
    private RootFile rootFile;
    private static final Map<String, String[]> columnLabels = new HashMap<String, String[]>(4);
    private CommitOptions[] commitOptions;
    private SvnFileNode[] nodes;
    private String[] columns;

    public CommitTableModel(String[] stringArray) {
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitTableModel.class);
        columnLabels.put(COLUMN_NAME_NAME, new String[]{resourceBundle.getString("CTL_CommitTable_Column_File"), resourceBundle.getString("CTL_CommitTable_Column_File")});
        columnLabels.put(COLUMN_NAME_BRANCH, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Branch"), resourceBundle.getString("CTL_CommitTable_Column_Branch")});
        columnLabels.put(COLUMN_NAME_STATUS, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Status"), resourceBundle.getString("CTL_CommitTable_Column_Status")});
        columnLabels.put(COLUMN_NAME_ACTION, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Action"), resourceBundle.getString("CTL_CommitTable_Column_Action")});
        columnLabels.put(COLUMN_NAME_PATH, new String[]{resourceBundle.getString("CTL_CommitTable_Column_Folder"), resourceBundle.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(stringArray);
        this.setNodes(new SvnFileNode[0]);
    }

    void setNodes(SvnFileNode[] svnFileNodeArray) {
        this.nodes = svnFileNodeArray;
        this.defaultCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] stringArray) {
        if (Arrays.equals(stringArray, this.columns)) {
            return;
        }
        this.columns = stringArray;
        this.fireTableStructureChanged();
    }

    public Map<SvnFileNode, CommitOptions> getCommitFiles() {
        HashMap<SvnFileNode, CommitOptions> hashMap = new HashMap<SvnFileNode, CommitOptions>(this.nodes.length);
        for (int i = 0; i < this.nodes.length; ++i) {
            hashMap.put(this.nodes[i], this.commitOptions[i]);
        }
        return hashMap;
    }

    @Override
    public String getColumnName(int n) {
        return columnLabels.get(this.columns[n])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int n) {
        String string = this.columns[n];
        if (string.equals(COLUMN_NAME_ACTION)) {
            return CommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        String string = this.columns[n2];
        return string.equals(COLUMN_NAME_ACTION);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        String string = this.columns[n2];
        if (string.equals(COLUMN_NAME_NAME)) {
            return this.nodes[n].getName();
        }
        if (string.equals(COLUMN_NAME_BRANCH)) {
            String string2 = SvnUtils.getCopy(this.nodes[n].getFile());
            return string2 == null ? "" : string2;
        }
        if (string.equals(COLUMN_NAME_STATUS)) {
            SvnFileNode svnFileNode = this.nodes[n];
            FileInformation fileInformation = svnFileNode.getInformation();
            fileInformation.getEntry(svnFileNode.getFile());
            return fileInformation.getStatusText();
        }
        if (string.equals(COLUMN_NAME_ACTION)) {
            return this.commitOptions[n];
        }
        if (string.equals(COLUMN_NAME_PATH)) {
            String string3 = null;
            if (this.rootFile != null) {
                String string4 = this.nodes[n].getFile().getAbsolutePath().substring(this.rootFile.rootLocalPath.length());
                string3 = this.rootFile.repositoryPath + string4.replace(File.separatorChar, '/');
            } else {
                try {
                    string3 = SvnUtils.getRelativePath(this.nodes[n].getFile());
                }
                catch (SVNClientException sVNClientException) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), false, false);
                }
                if (string3 == null) {
                    string3 = NbBundle.getMessage(CommitTableModel.class, (String)"CTL_CommitForm_NotInRepository");
                }
            }
            return string3;
        }
        throw new IllegalArgumentException("Column index out of range: " + n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        String string = this.columns[n2];
        if (!string.equals(COLUMN_NAME_ACTION)) {
            throw new IllegalArgumentException("Column index out of range: " + n2);
        }
        this.commitOptions[n] = (CommitOptions)object;
        this.fireTableCellUpdated(n, n2);
    }

    private void defaultCommitOptions() {
        boolean bl = System.getProperty("netbeans.subversion.excludeNewFiles") != null;
        this.commitOptions = SvnUtils.createDefaultCommitOptions(this.nodes, bl);
    }

    public SvnFileNode getNode(int n) {
        return this.nodes[n];
    }

    public CommitOptions getOptions(int n) {
        return this.commitOptions[n];
    }

    private Set<SVNUrl> getRepositoryRoots() {
        if (this.repositoryRoots == null) {
            this.repositoryRoots = new HashSet<SVNUrl>();
        }
        return this.repositoryRoots;
    }

    void setRootFile(String string, String string2) {
        this.rootFile = new RootFile();
        this.rootFile.repositoryPath = string;
        this.rootFile.rootLocalPath = string2;
    }

    private class RootFile {
        String repositoryPath;
        String rootLocalPath;

        private RootFile() {
        }
    }
}

