/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.netbeans.modules.subversion.ui.diff.DiffSetupSource;
import org.netbeans.modules.subversion.ui.history.DiffResultsView;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.SearchCriteriaPanel;
import org.netbeans.modules.subversion.ui.history.SearchExecutor;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.util.Context;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class SearchHistoryTopComponent
extends TopComponent
implements DiffSetupSource {
    private SearchHistoryPanel shp;

    public SearchHistoryTopComponent() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSN_SearchHistoryT_Top_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SearchHistoryTopComponent.class, (String)"ACSD_SearchHistoryT_Top_Component"));
    }

    public SearchHistoryTopComponent(Context context) {
        this(context, null, null, null, null);
    }

    public SearchHistoryTopComponent(Context context, String string, String string2, Date date, Date date2) {
        this();
        this.initComponents(context.getRootFiles(), string, string2, date, date2);
    }

    SearchHistoryTopComponent(File file, DiffResultsViewFactory diffResultsViewFactory) {
        this();
        this.initComponents(new File[]{file}, null, null, null, null);
        this.shp.setDiffResultsViewFactory(diffResultsViewFactory);
        this.shp.disableFileChangesOption(false);
    }

    public SearchHistoryTopComponent(SVNUrl sVNUrl, File file, long l) {
        this();
        this.initComponents(sVNUrl, file, l);
    }

    public void search() {
        this.shp.executeSearch();
        this.shp.setSearchCriteria(false);
    }

    private void initComponents(SVNUrl sVNUrl, File file, long l) {
        this.setLayout(new BorderLayout());
        SearchCriteriaPanel searchCriteriaPanel = new SearchCriteriaPanel(sVNUrl);
        searchCriteriaPanel.setFrom(Long.toString(l));
        searchCriteriaPanel.setTo(Long.toString(l));
        this.shp = new SearchHistoryPanel(sVNUrl, file, searchCriteriaPanel);
        this.add(this.shp);
    }

    private void initComponents(File[] fileArray, String string, String string2, Date date, Date date2) {
        this.setLayout(new BorderLayout());
        SearchCriteriaPanel searchCriteriaPanel = new SearchCriteriaPanel(fileArray);
        searchCriteriaPanel.setCommitMessage(string);
        searchCriteriaPanel.setUsername(string2);
        if (date != null) {
            searchCriteriaPanel.setFrom(SearchExecutor.simpleDateFormat.format(date));
        }
        if (date2 != null) {
            searchCriteriaPanel.setTo(SearchExecutor.simpleDateFormat.format(date2));
        }
        this.shp = new SearchHistoryPanel(fileArray, searchCriteriaPanel);
        this.add(this.shp);
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected String preferredID() {
        return "Svn.SearchHistoryTopComponent";
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(this.getClass());
    }

    public Collection getSetups() {
        return this.shp.getSetups();
    }

    public String getSetupDisplayName() {
        return this.getDisplayName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DiffResultsViewFactory {
        DiffResultsView createDiffResultsView(SearchHistoryPanel searchHistoryPanel, List<RepositoryRevision> list) {
            return new DiffResultsView(searchHistoryPanel, list);
        }
    }
}

