/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.properties.PropertiesPanel;
import org.netbeans.modules.subversion.ui.properties.PropertiesTable;
import org.netbeans.modules.subversion.ui.properties.SvnProperties;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class SvnPropertiesAction
extends ContextAction {
    protected boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray) && nodeArray.length == 1;
    }

    protected int getFileEnabledStatus() {
        return 7676;
    }

    protected int getDirectoryEnabledStatus() {
        return -4;
    }

    public String getName() {
        return NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesAction");
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_Properties";
    }

    protected void performContextAction(Node[] nodeArray) {
        Context context = this.getContext(nodeArray);
        String string = this.getContextDisplayName(nodeArray);
        File[] fileArray = SvnUtils.getActionRoots(context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = fileArray.length == 1 ? fileArray[0] : SvnUtils.getPrimaryFile(fileArray[0]);
        SvnPropertiesAction.openProperties(file, string);
    }

    public static void openProperties(File file, String string) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        PropertiesPanel propertiesPanel = new PropertiesPanel();
        PropertiesTable propertiesTable = new PropertiesTable(propertiesPanel.labelForTable, PropertiesTable.PROPERTIES_COLUMNS, new String[]{"value"});
        propertiesPanel.setPropertiesTable(propertiesTable);
        JComponent jComponent = propertiesTable.getComponent();
        propertiesPanel.propsPanel.setLayout(new BorderLayout());
        propertiesPanel.propsPanel.add((Component)jComponent, "Center");
        SvnProperties svnProperties = new SvnProperties(propertiesPanel, propertiesTable, file);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)SvnPropertiesAction.getString("CTL_Properties_Action_Close"));
        jButton.getAccessibleContext().setAccessibleDescription(SvnPropertiesAction.getString("CTL_Properties_Action_Close"));
        jButton.getAccessibleContext().setAccessibleName(SvnPropertiesAction.getString("CTL_Properties_Action_Close"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertiesPanel, NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesDialog_Title", (Object)string));
        dialogDescriptor.setModal(true);
        dialogDescriptor.setOptions(new Object[]{jButton});
        dialogDescriptor.setHelpCtx(new HelpCtx(SvnPropertiesAction.class));
        propertiesPanel.putClientProperty("contentTitle", string);
        propertiesPanel.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SvnPropertiesAction.class, (String)"CTL_PropertiesAction"));
        dialog.pack();
        dialog.setVisible(true);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SvnPropertiesAction.class, (String)string);
    }
}

