/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.relocate;

import java.awt.Dialog;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnProgressSupport;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.relocate.RelocatePanel;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RelocateAction
extends ContextAction {
    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return false;
        }
        Context context = this.getCachedContext(nodeArray);
        File[] fileArray = context.getRootFiles();
        if (fileArray == null || fileArray.length < 1) {
            return false;
        }
        for (File file : fileArray) {
            if (!file.isDirectory()) continue;
            return true;
        }
        return false;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    public void validate(RelocatePanel relocatePanel, JButton jButton) {
        try {
            new SVNUrl(relocatePanel.getNewURL().getText());
            jButton.setEnabled(true);
        }
        catch (MalformedURLException malformedURLException) {
            jButton.setEnabled(false);
        }
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_Relocate_Title";
    }

    protected void performContextAction(Node[] nodeArray) {
        ResourceBundle resourceBundle = NbBundle.getBundle(RelocateAction.class);
        Context context = this.getContext(nodeArray);
        File[] fileArray = context.getRootFiles();
        if (fileArray == null) {
            return;
        }
        final RelocatePanel relocatePanel = new RelocatePanel();
        fileArray = SvnUtils.getActionRoots(context);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file = fileArray[0];
        SVNUrl sVNUrl = null;
        try {
            sVNUrl = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException sVNClientException) {
            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
            return;
        }
        if (sVNUrl == null) {
            Subversion.LOG.log(Level.WARNING, "Could not retrieve repository root for context file {0}", new Object[]{file});
            return;
        }
        final String string = file.getAbsolutePath();
        relocatePanel.getCurrentURL().setText(sVNUrl.toString());
        relocatePanel.getWorkingCopy().setText(string);
        final JButton jButton = new JButton(resourceBundle.getString("CTL_Relocate_Action_Name"));
        jButton.setEnabled(false);
        jButton.setToolTipText(resourceBundle.getString("TT_Relocate_Action"));
        relocatePanel.getNewURL().getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                RelocateAction.this.validate(relocatePanel, jButton);
            }
        });
        JButton jButton2 = new JButton(resourceBundle.getString("CTL_Relocate_Action_Cancel"));
        jButton2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(RelocateAction.class, (String)"ACSD_Relocate_Action_Cancel"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)relocatePanel, resourceBundle.getString("CTL_Relocate_Dialog_Title"), true, new Object[]{jButton, jButton2}, (Object)jButton, 0, null, null);
        dialogDescriptor.setClosingOptions(null);
        dialogDescriptor.setHelpCtx(new HelpCtx(RelocateAction.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_Relocate"));
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != jButton) {
            return;
        }
        final String string2 = relocatePanel.getNewURL().getText();
        RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
        final SVNUrl sVNUrl2 = sVNUrl;
        SvnProgressSupport svnProgressSupport = new SvnProgressSupport(){
            SvnClient client = null;

            protected void perform() {
                try {
                    this.client = Subversion.getInstance().getClient(sVNUrl2);
                    this.client.relocate(sVNUrl2.toString(), string2, string, true);
                }
                catch (SVNClientException sVNClientException) {
                    this.annotate(sVNClientException);
                }
            }
        };
        svnProgressSupport.start(requestProcessor, sVNUrl, resourceBundle.getString("LBL_Relocate_Progress"));
    }
}

