/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.update;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.actions.ContextAction;
import org.netbeans.modules.subversion.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ResolveConflictsAction
extends ContextAction {
    protected String getBaseName(Node[] nodeArray) {
        return "ResolveConflicts";
    }

    protected boolean enable(Node[] nodeArray) {
        Context context = SvnUtils.getCurrentContext(nodeArray);
        return SvnUtils.getModifiedFiles(context, 64).length > 0;
    }

    protected void performContextAction(Node[] nodeArray) {
        if (!Subversion.getInstance().checkClientAvailable()) {
            return;
        }
        Context context = this.getContext(nodeArray);
        FileStatusCache fileStatusCache = Subversion.getInstance().getStatusCache();
        File[] fileArray = fileStatusCache.listFiles(context, 64);
        ResolveConflictsAction.resolveConflicts(fileArray);
    }

    static void resolveConflicts(final File[] fileArray) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                final List list = ResolveConflictsAction.removeFolders(fileArray);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (list.size() == 0) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        } else {
                            for (File file : list) {
                                ResolveConflictsExecutor resolveConflictsExecutor = new ResolveConflictsExecutor(file);
                                resolveConflictsExecutor.exec();
                            }
                        }
                    }
                });
            }
        });
    }

    private static List removeFolders(File[] fileArray) {
        LinkedList<File> linkedList = new LinkedList<File>();
        for (File file : fileArray) {
            if (!file.isFile()) continue;
            linkedList.add(file);
        }
        return linkedList;
    }

    public boolean asynchronous() {
        return false;
    }
}

