/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.wizards.repositorystep;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.subversion.RepositoryFile;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.WizardStepProgressSupport;
import org.netbeans.modules.subversion.ui.repository.Repository;
import org.netbeans.modules.subversion.ui.repository.RepositoryConnection;
import org.netbeans.modules.subversion.ui.wizards.AbstractStep;
import org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStepPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryStep
extends AbstractStep
implements WizardDescriptor.AsynchronousValidatingPanel,
PropertyChangeListener {
    public static final String IMPORT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.import";
    public static final String CHECKOUT_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.checkout";
    public static final String URL_PATTERN_HELP_ID = "org.netbeans.modules.subversion.ui.wizards.repositorystep.RepositoryStep.urlPattern";
    private Repository repository;
    private RepositoryStepPanel panel;
    private RepositoryFile repositoryFile;
    private int repositoryModeMask;
    private WizardStepProgressSupport support;
    private final String helpID;

    public RepositoryStep(String string) {
        this.repositoryModeMask = 0;
        this.helpID = string;
    }

    public RepositoryStep(int n, String string) {
        this.repositoryModeMask = n;
        this.helpID = string;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(this.helpID);
    }

    protected JComponent createComponent() {
        if (this.repository == null) {
            this.repositoryModeMask = this.repositoryModeMask | 2 | 4 | 0x20 | 0x40;
            String string = NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Location");
            this.repository = new Repository(this.repositoryModeMask, string);
            this.repository.addPropertyChangeListener(this);
            this.panel = new RepositoryStepPanel();
            this.panel.repositoryPanel.setLayout(new BorderLayout());
            this.panel.repositoryPanel.add(this.repository.getPanel());
            this.valid();
        }
        return this.panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validateBeforeNext() {
        try {
            this.support = new RepositoryStepProgressSupport(this.panel.progressPanel);
            SVNUrl sVNUrl = this.getUrl();
            this.support.setRepositoryRoot(sVNUrl);
            RequestProcessor requestProcessor = Subversion.getInstance().getRequestProcessor(sVNUrl);
            RequestProcessor.Task task = this.support.start(requestProcessor, sVNUrl, NbBundle.getMessage(RepositoryStep.class, (String)"BK2012"));
            task.waitFinished();
        }
        finally {
            this.support = null;
        }
    }

    public void prepareValidation() {
    }

    private SVNUrl getUrl() {
        try {
            return this.getSelectedRepositoryConnection().getSvnUrl();
        }
        catch (MalformedURLException malformedURLException) {
            Subversion.LOG.log(Level.INFO, null, malformedURLException);
            return null;
        }
    }

    private void storeHistory() {
        RepositoryConnection repositoryConnection = this.getSelectedRepositoryConnection();
        if (repositoryConnection != null) {
            SvnModuleConfig.getDefault().insertRecentUrl(repositoryConnection);
        }
    }

    public RepositoryFile getRepositoryFile() {
        return this.repositoryFile;
    }

    private RepositoryConnection getSelectedRepositoryConnection() {
        try {
            return this.repository.getSelectedRC();
        }
        catch (Exception exception) {
            this.invalid(new AbstractStep.WizardMessage(exception.getLocalizedMessage(), false));
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("valid")) {
            if (this.repository.isValid()) {
                this.valid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            } else {
                this.invalid(new AbstractStep.WizardMessage(this.repository.getMessage(), false));
            }
        }
    }

    public void stop() {
        if (this.support != null) {
            this.support.cancel();
        }
    }

    private class RepositoryStepProgressSupport
    extends WizardStepProgressSupport {
        public RepositoryStepProgressSupport(JPanel jPanel) {
            super(jPanel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void perform() {
            AbstractStep.WizardMessage wizardMessage;
            block26: {
                block27: {
                    block28: {
                        block29: {
                            block24: {
                                block25: {
                                    RepositoryConnection repositoryConnection = RepositoryStep.this.getSelectedRepositoryConnection();
                                    if (repositoryConnection == null) {
                                        return;
                                    }
                                    RepositoryStep.this.storeHistory();
                                    wizardMessage = null;
                                    try {
                                        SvnClient svnClient;
                                        RepositoryStep.this.invalid(null);
                                        SVNUrl sVNUrl = repositoryConnection.getSvnUrl();
                                        try {
                                            int n = 8;
                                            svnClient = Subversion.getInstance().getClient(sVNUrl, repositoryConnection.getUsername(), repositoryConnection.getPassword(), n);
                                        }
                                        catch (SVNClientException sVNClientException) {
                                            SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                                            wizardMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)repositoryConnection.getUrl()), false);
                                            if (this.isCanceled()) {
                                                RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                                                return;
                                            }
                                            if (wizardMessage == null) {
                                                RepositoryStep.this.valid();
                                                return;
                                            }
                                            RepositoryStep.this.valid(wizardMessage);
                                            return;
                                        }
                                        RepositoryStep.this.repositoryFile = null;
                                        ISVNInfo iSVNInfo = null;
                                        try {
                                            RepositoryStep.this.repository.storeConfigValues();
                                            iSVNInfo = svnClient.getInfo(sVNUrl);
                                        }
                                        catch (SVNClientException sVNClientException) {
                                            this.annotate(sVNClientException);
                                            wizardMessage = new AbstractStep.WizardMessage(SvnClientExceptionHandler.parseExceptionMessage(sVNClientException), false);
                                        }
                                        if (this.isCanceled()) {
                                            if (!this.isCanceled()) break block24;
                                            break block25;
                                        }
                                        if (iSVNInfo != null) {
                                            SVNUrl sVNUrl2 = SvnUtils.decode(iSVNInfo.getRepository());
                                            if (sVNUrl2 == null) {
                                                sVNUrl2 = repositoryConnection.getSvnUrl();
                                            }
                                            SVNRevision sVNRevision = repositoryConnection.getSvnRevision();
                                            String[] stringArray = sVNUrl2.getPathSegments();
                                            String[] stringArray2 = repositoryConnection.getSvnUrl().getPathSegments();
                                            String[] stringArray3 = new String[stringArray2.length - stringArray.length];
                                            System.arraycopy(stringArray2, stringArray.length, stringArray3, 0, stringArray3.length);
                                            RepositoryStep.this.repositoryFile = new RepositoryFile(sVNUrl2, stringArray3, sVNRevision);
                                            if (!this.isCanceled()) break block26;
                                            break block27;
                                        }
                                        wizardMessage = new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Invalid", (Object)repositoryConnection.getUrl()), false);
                                        if (!this.isCanceled()) break block28;
                                        break block29;
                                    }
                                    catch (MalformedURLException malformedURLException) {
                                        Subversion.LOG.log(Level.INFO, null, malformedURLException);
                                        return;
                                    }
                                }
                                RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                                return;
                            }
                            if (wizardMessage == null) {
                                RepositoryStep.this.valid();
                                return;
                            }
                            RepositoryStep.this.valid(wizardMessage);
                            return;
                        }
                        RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                        return;
                    }
                    if (wizardMessage == null) {
                        RepositoryStep.this.valid();
                        return;
                    }
                    RepositoryStep.this.valid(wizardMessage);
                    return;
                }
                RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                return;
            }
            if (wizardMessage == null) {
                RepositoryStep.this.valid();
                return;
            }
            RepositoryStep.this.valid(wizardMessage);
            return;
            finally {
                if (this.isCanceled()) {
                    RepositoryStep.this.valid(new AbstractStep.WizardMessage(NbBundle.getMessage(RepositoryStep.class, (String)"CTL_Repository_Canceled"), false));
                } else if (wizardMessage == null) {
                    RepositoryStep.this.valid();
                } else {
                    RepositoryStep.this.valid(wizardMessage);
                }
            }
        }

        public void setEditable(boolean bl) {
            RepositoryStep.this.repository.setEditable(bl);
        }
    }
}

