/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http;

import com.sun.grizzly.DefaultSelectionKeyHandler;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.util.Copyable;
import com.sun.grizzly.util.ThreadAttachment;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorThreadKeyHandler
extends DefaultSelectionKeyHandler {
    protected ConcurrentLinkedQueue<SelectionKey> bannedKeys = new ConcurrentLinkedQueue();
    private SelectorThread selectorThread;

    public SelectorThreadKeyHandler() {
    }

    public SelectorThreadKeyHandler(SelectorThread selectorThread) {
        this.selectorThread = selectorThread;
    }

    @Override
    public void copyTo(Copyable copy) {
        SelectorThreadKeyHandler copyHandler = (SelectorThreadKeyHandler)copy;
        copyHandler.selectorThread = this.selectorThread;
    }

    @Override
    public void doRegisterKey(SelectionKey key, int ops, long currentTime) {
        if (!key.isValid() || !this.selectorThread.getKeepAliveCounter().trap(key)) {
            this.selectorThread.cancelKey(key);
            return;
        }
        if (this.selectorThread.getEnableAsyncExecution() && !this.bannedKeys.isEmpty() && this.bannedKeys.remove(key)) {
            return;
        }
        key.interestOps(key.interestOps() | ops);
        Object attachment = key.attachment();
        if (attachment == null) {
            key.attach(currentTime);
        } else if (attachment instanceof ThreadAttachment) {
            ((ThreadAttachment)attachment).setTimeout(currentTime);
        }
    }

    @Override
    public void expire(Iterator<SelectionKey> keys) {
        super.expire(keys);
        if (this.selectorThread.isMonitoringEnabled()) {
            this.selectorThread.getRequestGroupInfo().decreaseCountOpenConnections();
        }
    }

    @Override
    public void cancel(SelectionKey key) {
        if (key != null) {
            this.selectorThread.getKeepAliveCounter().untrap(key);
        }
        super.cancel(key);
    }

    public void addBannedSelectionKey(SelectionKey key) {
        this.bannedKeys.offer(key);
    }
}

