/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.http.servlet;

import com.sun.grizzly.http.servlet.ServletContextImpl;
import com.sun.grizzly.tcp.http11.GrizzlySession;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class HttpSessionImpl
implements HttpSession {
    private GrizzlySession session;
    private ServletContextImpl contextImpl;
    private Long creationTime;
    private Long lastAccessed;
    private boolean isNew = true;

    public HttpSessionImpl(ServletContextImpl contextImpl) {
        this.contextImpl = contextImpl;
        this.lastAccessed = this.creationTime = Long.valueOf(System.currentTimeMillis());
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.session.getIdInternal();
    }

    public long getLastAccessedTime() {
        return this.lastAccessed;
    }

    protected void access() {
        this.lastAccessed = System.currentTimeMillis();
        this.session.setTimestamp(this.lastAccessed);
        this.isNew = false;
    }

    public ServletContext getServletContext() {
        return this.contextImpl;
    }

    public void setMaxInactiveInterval(int sessionTimeout) {
        this.session.setTimestamp(sessionTimeout);
    }

    public int getMaxInactiveInterval() {
        return (int)this.session.getSessionTimeout();
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getAttribute(String key) {
        return this.session.getAttribute(key);
    }

    public Object getValue(String value) {
        return this.session.getAttribute(value);
    }

    public Enumeration getAttributeNames() {
        return this.session.atttibutes().keys();
    }

    public String[] getValueNames() {
        return this.session.atttibutes().entrySet().toArray(new String[0]);
    }

    public void setAttribute(String key, Object value) {
        this.session.setAttribute(key, value);
    }

    public void putValue(String key, Object value) {
        this.session.setAttribute(key, value);
    }

    public void removeAttribute(String key) {
        this.session.removeAttribute(key);
    }

    public void removeValue(String key) {
        this.session.removeAttribute(key);
    }

    public void invalidate() {
        this.session.atttibutes().clear();
        this.creationTime = 0L;
        this.isNew = true;
    }

    public boolean isNew() {
        return this.isNew;
    }

    protected void setSession(GrizzlySession session) {
        this.session = session;
    }
}

