/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.suspendable;

import com.sun.grizzly.Controller;
import com.sun.grizzly.suspendable.SuspendableFilter;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SuspendableMonitor {
    private Selector selector;
    private ConcurrentLinkedQueue<SuspendableFilter.KeyHandler> keysToRegister = new ConcurrentLinkedQueue();
    private Logger logger = Controller.logger();

    public SuspendableMonitor() {
        this.start();
    }

    public void start() {
        new Thread("SuspendableMonitor"){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    SuspendableMonitor.this.selector = Selector.open();
                }
                catch (IOException ex) {
                    SuspendableMonitor.this.logger.log(Level.SEVERE, "SuspendableMonitor.open()", ex);
                    return;
                }
                while (true) {
                    SelectionKey foreignKey = null;
                    SuspendableFilter.KeyHandler kh = null;
                    int selectorState = 0;
                    try {
                        selectorState = 0;
                        try {
                            selectorState = SuspendableMonitor.this.selector.select(1000L);
                        }
                        catch (CancelledKeyException ex) {
                            // empty catch block
                        }
                        Iterator keys = SuspendableMonitor.this.keysToRegister.iterator();
                        while (keys.hasNext()) {
                            kh = (SuspendableFilter.KeyHandler)keys.next();
                            SelectableChannel channel = kh.getKey().channel();
                            if (!kh.getKey().isValid() || !channel.isOpen()) continue;
                            foreignKey = channel.register(SuspendableMonitor.this.selector, 1, kh);
                            kh.setForeignKey(foreignKey);
                            keys.remove();
                        }
                        this.expireIdleKeys();
                        if (selectorState > 0) continue;
                        SuspendableMonitor.this.selector.selectedKeys().clear();
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        try {
                            if (kh != null) {
                                try {
                                    this.interrupted(kh.getKey());
                                }
                                catch (Throwable t2) {
                                    SuspendableMonitor.this.logger.log(Level.SEVERE, "SuspendableMonitor", t2);
                                }
                            }
                            if (selectorState > 0) continue;
                            SuspendableMonitor.this.selector.selectedKeys().clear();
                            continue;
                        }
                        catch (Throwable t2) {
                            SuspendableMonitor.this.logger.log(Level.SEVERE, "SuspendableMonitor", t2);
                            continue;
                        }
                    }
                    break;
                }
            }

            protected void expireIdleKeys() {
                Set<SelectionKey> readyKeys = SuspendableMonitor.this.selector.keys();
                if (readyKeys.isEmpty()) {
                    return;
                }
                long current = System.currentTimeMillis();
                for (SelectionKey key : readyKeys) {
                    SuspendableFilter.KeyHandler kh;
                    block6: {
                        kh = (SuspendableFilter.KeyHandler)key.attachment();
                        if (kh == null) {
                            return;
                        }
                        long expire = kh.getRegistrationTime();
                        if (expire == -1L || current - expire < kh.getSuspendableHandler().getExpireTime()) continue;
                        kh.setRegistrationTime(-1L);
                        if (SuspendableMonitor.this.logger.isLoggable(Level.FINE)) {
                            SuspendableMonitor.this.logger.log(Level.FINE, "Expiring: " + key + " attachment: " + key.attachment());
                        }
                        try {
                            kh.getSuspendableHandler().getSuspendableHandler().expired(kh.getSuspendableHandler().getAttachment());
                        }
                        catch (Throwable t) {
                            if (!SuspendableMonitor.this.logger.isLoggable(Level.FINE) || kh == null) break block6;
                            SuspendableMonitor.this.logger.log(Level.FINE, "Interrupting: " + t);
                        }
                    }
                    kh.getSuspendableHandler().getSuspendableFilter().resume(kh.getKey());
                }
            }

            protected void interrupted(SelectionKey key) {
                key.cancel();
                SuspendableFilter.KeyHandler kh = (SuspendableFilter.KeyHandler)key.attachment();
                kh.getSuspendableHandler().getSelectorHandler().getSelectionKeyHandler().cancel(kh.getKey());
                if (SuspendableMonitor.this.logger.isLoggable(Level.FINE) && kh != null) {
                    SuspendableMonitor.this.logger.log(Level.FINE, "Interrupting: " + kh.getKey());
                }
                if (kh != null) {
                    kh.getSuspendableHandler().getSuspendableHandler().interupted(kh.getSuspendableHandler().getAttachment());
                    kh.getSuspendableHandler().getSuspendableFilter().suspendedKeys.remove(kh.getKey());
                }
            }
        }.start();
    }

    protected void suspend(SuspendableFilter.KeyHandler kh) throws ClosedChannelException {
        try {
            kh.setRegistrationTime(System.currentTimeMillis());
            if (kh.getForeignKey() == null) {
                this.keysToRegister.offer(kh);
                this.selector.wakeup();
            }
        }
        catch (Throwable ex) {
            this.logger.log(Level.SEVERE, "suspend exception: " + kh.getKey(), ex);
        }
    }
}

