/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.cpu;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.storage.SQLStackStorage;
import org.netbeans.modules.dlight.cpu.impl.CpuIndicatorConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.MultipleDTDCConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.ProcDataProviderConfiguration;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.visualizers.api.CallersCalleesVisualizerConfiguration;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class DLightCPUToolConfigurationProvider
implements DLightToolConfigurationProvider {
    public static final int INDICATOR_POSITION = 100;
    private static final String TOOL_NAME = DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ToolName", new String[0]);
    private static final String DETAILED_TOOL_NAME = DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.DetailedToolName", new String[0]);
    private static final boolean CPU_TREE_TABLE = Boolean.valueOf(System.getProperty("cpu.tree.table", "false"));

    public DLightToolConfiguration create() {
        Object object;
        CallersCalleesVisualizerConfiguration callersCalleesVisualizerConfiguration;
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(TOOL_NAME, DETAILED_TOOL_NAME);
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/cpu/resources/cpu.png");
        SunStudioDCConfiguration sunStudioDCConfiguration = new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.FUNCTIONS_LIST);
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)sunStudioDCConfiguration);
        DataTableMetadata dataTableMetadata = SunStudioDCConfiguration.getCPUTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_iUser, SunStudioDCConfiguration.c_eUser});
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setDisplayedName(SunStudioDCConfiguration.c_name.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_iUser.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_incl", new String[0]), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnTooltip.time_incl", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_eUser.getColumnName(), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_excl", new String[0]), DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnTooltip.time_excl", new String[0]));
        if (CPU_TREE_TABLE) {
            callersCalleesVisualizerConfiguration = new CallersCalleesVisualizerConfiguration(dataTableMetadata, "name", false);
            callersCalleesVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        } else {
            object = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
            callersCalleesVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata, object, Arrays.asList(SunStudioDCConfiguration.c_eUser, SunStudioDCConfiguration.c_iUser));
            ((FunctionsListViewVisualizerConfiguration)callersCalleesVisualizerConfiguration).setColumnsUIMapping(columnsUIMapping);
            ((FunctionsListViewVisualizerConfiguration)callersCalleesVisualizerConfiguration).setEmptyAnalyzeMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
            ((FunctionsListViewVisualizerConfiguration)callersCalleesVisualizerConfiguration).setEmptyRunningMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        }
        object = Util.copyResource(this.getClass(), (String)(Util.getBasePath(this.getClass()) + "/resources/calls.d"));
        DataTableMetadata dataTableMetadata2 = this.createProfilerTableMetadata();
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration((String)object, Arrays.asList(dataTableMetadata2));
        dTDCConfiguration.setStackSupportEnabled(true);
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)new MultipleDTDCConfiguration(dTDCConfiguration, "cpu:"));
        VisualizerConfiguration visualizerConfiguration = this.createDTraceBasedVisualizerConfiguration(dataTableMetadata2);
        ProcDataProviderConfiguration procDataProviderConfiguration = new ProcDataProviderConfiguration();
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)procDataProviderConfiguration);
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        arrayList.add(ProcDataProviderConfiguration.USR_TIME);
        arrayList.add(ProcDataProviderConfiguration.SYS_TIME);
        IndicatorMetadata indicatorMetadata = new IndicatorMetadata(arrayList);
        CpuIndicatorConfiguration cpuIndicatorConfiguration = new CpuIndicatorConfiguration(indicatorMetadata, new HashSet<String>(Arrays.asList(ProcDataProviderConfiguration.SYS_TIME.getColumnName())), 100);
        cpuIndicatorConfiguration.addVisualizerConfiguration(visualizerConfiguration);
        cpuIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)callersCalleesVisualizerConfiguration);
        dLightToolConfiguration.addIndicatorConfiguration((IndicatorConfiguration)cpuIndicatorConfiguration);
        return dLightToolConfiguration;
    }

    private DataTableMetadata createProfilerTableMetadata() {
        DataTableMetadata.Column column = new DataTableMetadata.Column("cpu_id", Integer.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.cpu_id", new String[0]), null);
        DataTableMetadata.Column column2 = new DataTableMetadata.Column("thread_id", Integer.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.thread_id", new String[0]), null);
        DataTableMetadata.Column column3 = new DataTableMetadata.Column("time_stamp", Long.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.time_stamp", new String[0]), null);
        DataTableMetadata.Column column4 = new DataTableMetadata.Column("leaf_id", Integer.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.leaf_id", new String[0]), null);
        return new DataTableMetadata("CallStack", Arrays.asList(column, column2, column3, column4), null);
    }

    private VisualizerConfiguration createDTraceBasedVisualizerConfiguration(DataTableMetadata dataTableMetadata) {
        String string;
        FunctionMetric functionMetric2;
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        ArrayList<DataTableMetadata.Column> arrayList2 = new ArrayList<DataTableMetadata.Column>();
        DataTableMetadata.Column column = new DataTableMetadata.Column("name", String.class, DLightCPUToolConfigurationProvider.loc("CPUMonitorTool.ColumnName.name", new String[0]), null);
        arrayList.add(column);
        List list = SQLStackStorage.METRICS;
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        for (FunctionMetric functionMetric2 : list) {
            string = functionMetric2.getMetricID();
            String string2 = DLightCPUToolConfigurationProvider.locMetricDisplayedName(string);
            String string3 = DLightCPUToolConfigurationProvider.locMetricTooltip(string);
            if (string2 != null) {
                columnsUIMapping.setDisplayedName(string, string2);
            }
            if (string3 != null) {
                columnsUIMapping.setTooltip(string, string3);
            }
            DataTableMetadata.Column column2 = new DataTableMetadata.Column(string, functionMetric2.getMetricValueClass(), functionMetric2.getMetricDisplayedName(), null);
            arrayList.add(column2);
            arrayList2.add(column2);
        }
        DataTableMetadata dataTableMetadata2 = new DataTableMetadata("DtraceStack", arrayList, null, Arrays.asList(dataTableMetadata));
        if (CPU_TREE_TABLE) {
            functionMetric2 = new CallersCalleesVisualizerConfiguration(dataTableMetadata2, "name", false);
            functionMetric2.setColumnsUIMapping(columnsUIMapping);
            return functionMetric2;
        }
        functionMetric2 = new FunctionDatatableDescription(column.getColumnName(), null, column.getColumnName());
        string = new FunctionsListViewVisualizerConfiguration(dataTableMetadata2, (FunctionDatatableDescription)functionMetric2, arrayList2);
        string.setEmptyAnalyzeMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        string.setEmptyRunningMessage(DLightCPUToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        string.setColumnsUIMapping(columnsUIMapping);
        return string;
    }

    private static String locMetricDisplayedName(String string) {
        try {
            return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)("FunctionMetric." + string));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String locMetricTooltip(String string) {
        try {
            return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)("FunctionMetric.tooltip." + string));
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(DLightCPUToolConfigurationProvider.class, (String)string, (Object[])stringArray);
    }
}

