/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.cpu.impl;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.cpu.impl.CpuIndicatorConfiguration;
import org.netbeans.modules.dlight.cpu.impl.CpuIndicatorPanel;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.RepairPanel;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CpuIndicator
extends Indicator<CpuIndicatorConfiguration> {
    private final CpuIndicatorPanel panel = new CpuIndicatorPanel();
    private final Set<String> acceptedColumnNames = new HashSet<String>();
    private final Set<String> acceptedSysColumnNames;
    private Collection<ActionListener> listeners;
    private int lastSysValue;
    private int lastUsrValue;
    private int seconds;

    CpuIndicator(CpuIndicatorConfiguration cpuIndicatorConfiguration, Set<String> set) {
        super((IndicatorConfiguration)cpuIndicatorConfiguration);
        for (DataTableMetadata.Column column : this.getMetadataColumns()) {
            this.acceptedColumnNames.add(column.getColumnName());
        }
        this.acceptedSysColumnNames = set;
    }

    public JComponent getComponent() {
        return this.panel.getPanel();
    }

    public void reset() {
    }

    public void updated(List<DataRow> list) {
        for (DataRow dataRow : list) {
            if (DLightLogger.instance.isLoggable(Level.FINE)) {
                DLightLogger.instance.fine("UPDATE: " + dataRow.getData().get(0) + " " + dataRow.getData().get(1));
            }
            for (String string : dataRow.getColumnNames()) {
                if (this.acceptedSysColumnNames.contains(string)) {
                    this.lastSysValue = ((Float)dataRow.getData(string)).intValue();
                    continue;
                }
                if (!this.acceptedColumnNames.contains(string)) continue;
                this.lastUsrValue = ((Float)dataRow.getData(string)).intValue();
            }
        }
    }

    protected void tick() {
        this.panel.addData(this.lastSysValue, this.lastUsrValue);
        this.panel.setSysValue(this.lastSysValue);
        this.panel.setUsrValue(this.lastUsrValue);
        this.panel.setTime(++this.seconds);
    }

    void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent((Object)this, 0, null);
        for (ActionListener actionListener : this.getActionListeners()) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<ActionListener> getActionListeners() {
        CpuIndicator cpuIndicator = this;
        synchronized (cpuIndicator) {
            return this.listeners == null ? Collections.emptyList() : new ArrayList<ActionListener>(this.listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addActionListener(ActionListener actionListener) {
        CpuIndicator cpuIndicator = this;
        synchronized (cpuIndicator) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<ActionListener>();
            }
            this.listeners.add(actionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeActionListener(ActionListener actionListener) {
        CpuIndicator cpuIndicator = this;
        synchronized (cpuIndicator) {
            if (this.listeners != null) {
                this.listeners.remove(actionListener);
            }
        }
    }

    protected void repairNeeded(boolean bl) {
        if (bl) {
            final RepairPanel repairPanel = new RepairPanel(this.getRepairActionProvider().getValidationStatus());
            repairPanel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    final Future future = CpuIndicator.this.getRepairActionProvider().asyncRepair();
                    DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(false);
                                }
                            });
                            Boolean bl = (Boolean)future.get();
                            UIThread.invoke((Runnable)new Runnable(){

                                public void run() {
                                    repairPanel.setEnabled(true);
                                }
                            });
                            return bl;
                        }
                    }, (String)"Click On Repair in CPU Indicator task");
                }
            });
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    CpuIndicator.this.panel.getPanel().setOverlay((JComponent)repairPanel);
                }
            });
        } else {
            final JEditorPane jEditorPane = UIUtilities.createJEditorPane((String)this.getRepairActionProvider().getMessage(this.getRepairActionProvider().getValidationStatus()), (boolean)false, (Color)GraphConfig.TEXT_COLOR);
            UIThread.invoke((Runnable)new Runnable(){

                public void run() {
                    CpuIndicator.this.panel.getPanel().setOverlay((JComponent)jEditorPane);
                }
            });
        }
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(CpuIndicator.class, (String)string);
    }
}

