/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.nbbuild.ModuleListParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixTestDependencies
extends Task {
    Set<ModuleListParser.Entry> cachedEntries;
    String cnb;
    File projectXmlFile;
    File propertiesFile;

    public void setProjectXml(File projectXml) {
        this.projectXmlFile = projectXml;
    }

    public void setPropertiesFile(File properties) {
        this.propertiesFile = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        try {
            boolean testFix;
            boolean bl = testFix = this.getProject().getProperty("test.fix.dependencies") != null;
            if (this.projectXmlFile == null || !this.projectXmlFile.isFile()) {
                throw new BuildException("project.xml file doesn't exist.");
            }
            byte[] xmlBytes = new byte[(int)this.projectXmlFile.length()];
            FileInputStream prjFis = new FileInputStream(this.projectXmlFile);
            try {
                prjFis.read(xmlBytes);
            }
            finally {
                prjFis.close();
            }
            String xml = new String(xmlBytes);
            String oldXsd = "<data xmlns=\"http://www.netbeans.org/ns/nb-module-project/2";
            int xsdIndex = xml.indexOf(oldXsd);
            if (xsdIndex == -1) {
                xsdIndex = xml.indexOf("<data xmlns=\"http://www.netbeans.org/ns/nb-module-project/3");
            }
            if (xsdIndex != -1 || testFix) {
                String part1 = xml.substring(0, xsdIndex + oldXsd.length() - 1);
                String part2 = xml.substring(xsdIndex + oldXsd.length(), xml.length());
                xml = part1 + "3" + part2;
                int projectType = 0;
                if (xml.contains("<suite-component/>")) {
                    projectType = 1;
                } else if (xml.contains("<standalone/>")) {
                    projectType = 2;
                }
                int typeStart = xml.indexOf("<code-name-base>");
                int typeEnd = xml.indexOf("</code-name-base>");
                if (typeStart <= 0 || typeEnd <= 0 || typeEnd <= typeStart) {
                    throw new BuildException("Parsing of project.xml failed.");
                }
                this.cnb = xml.substring(typeStart + "<code-name-base>".length(), typeEnd).trim();
                if (this.cnb.length() <= 0) {
                    throw new BuildException("Invalid codename base:" + this.cnb);
                }
                if (xml.contains("<test-dependencies>") && !testFix) {
                    this.log("<test-dependencies> already exists.");
                    this.log("update only schema version");
                    PrintStream ps = new PrintStream(this.projectXmlFile);
                    ps.print(xml);
                    ps.close();
                    return;
                }
                Set<ModuleListParser.Entry> entries = this.getModuleList(projectType);
                Set<String> allCnbs = this.getCNBsFromEntries(entries);
                TreeSet<String> compileCNB = new TreeSet<String>();
                TreeSet<String> compileTestCNB = new TreeSet<String>();
                TreeSet<String> runtimeCNB = new TreeSet<String>();
                TreeSet<String> runtimeTestCNB = new TreeSet<String>();
                Properties projectProperties = this.getTestProperties();
                this.readCodeNameBases(compileCNB, compileTestCNB, projectProperties, "test.unit.cp", allCnbs, entries);
                this.readCodeNameBases(compileCNB, compileTestCNB, projectProperties, "test.unit.cp.extra", allCnbs, entries);
                this.readCodeNameBases(runtimeCNB, runtimeTestCNB, projectProperties, "test.unit.run.cp", allCnbs, entries);
                this.readCodeNameBases(runtimeCNB, runtimeTestCNB, projectProperties, "test.unit.run.cp.extra", allCnbs, entries);
                this.updateProperties(projectProperties, new String[]{"test.unit.cp", "test.unit.cp.extra", "test.unit.run.cp", "test.unit.run.cp.extra"});
                StringWriter writer = new StringWriter();
                PrintWriter buffer = new PrintWriter(writer);
                buffer.println("");
                buffer.println("          <test-dependencies>");
                buffer.println("              <test-type>");
                buffer.println("                  <name>unit</name>");
                this.addDependency(buffer, this.cnb, true, true, false);
                runtimeCNB.removeAll(compileCNB);
                compileCNB.addAll(compileTestCNB);
                runtimeTestCNB.removeAll(compileTestCNB);
                runtimeCNB.addAll(runtimeTestCNB);
                this.addDependencies(buffer, compileCNB, compileTestCNB, true, false);
                this.addDependencies(buffer, runtimeCNB, runtimeTestCNB, false, false);
                buffer.println("              </test-type>");
                compileCNB.clear();
                runtimeCNB.clear();
                compileTestCNB.clear();
                runtimeTestCNB.clear();
                this.readCodeNameBases(compileCNB, compileTestCNB, projectProperties, "test.qa-functional.cp", allCnbs, entries);
                this.readCodeNameBases(compileCNB, compileTestCNB, projectProperties, "test.qa-functional.cp.extra", allCnbs, entries);
                this.readCodeNameBases(runtimeCNB, runtimeTestCNB, projectProperties, "test.qa-functional.runtime.cp", allCnbs, entries);
                this.readCodeNameBases(runtimeCNB, runtimeTestCNB, projectProperties, "test.qa-functional.runtime.extra", allCnbs, entries);
                if (!(compileTestCNB.isEmpty() && compileCNB.isEmpty() && runtimeTestCNB.isEmpty() && runtimeCNB.isEmpty())) {
                    buffer.println("              <test-type>");
                    buffer.println("                  <name>qa-functional</name>");
                    this.addDependencies(buffer, compileCNB, compileTestCNB, true, false);
                    this.addDependencies(buffer, runtimeCNB, runtimeTestCNB, false, false);
                    buffer.println("              </test-type>");
                }
                buffer.println("            </test-dependencies>");
                this.updateProperties(projectProperties, new String[]{"test.qa-functional.cp", "test.qa-functional.cp", "test.qa-functional.runtime.cp", "test.qa-functional.runtime.extra"});
                String MODULE_DEP_END = "</module-dependencies>";
                int moduleDepEnd = xml.indexOf(MODULE_DEP_END);
                if (moduleDepEnd == -1) {
                    MODULE_DEP_END = "<module-dependencies/>";
                    moduleDepEnd = xml.indexOf(MODULE_DEP_END);
                }
                if (moduleDepEnd == -1) {
                    throw new BuildException("No module dependency found.");
                }
                StringBuffer resultXml = new StringBuffer();
                resultXml.append(xml.substring(0, moduleDepEnd += MODULE_DEP_END.length()));
                resultXml.append(writer.toString());
                if (xml.charAt(moduleDepEnd) == '\r') {
                    ++moduleDepEnd;
                }
                resultXml.append(xml.substring(moduleDepEnd + 1, xml.length()));
                if (!testFix) {
                    PrintStream ps = new PrintStream(this.projectXmlFile);
                    ps.print(resultXml);
                    ps.close();
                } else {
                    System.out.println(resultXml);
                }
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private Set<ModuleListParser.Entry> getModuleList(int projectType) throws IOException {
        if (this.cachedEntries == null) {
            ModuleListParser listParser = new ModuleListParser(this.getProject().getProperties(), projectType, this.getProject());
            return listParser.findAll();
        }
        return this.cachedEntries;
    }

    private Set<String> getCNBsFromEntries(Set<ModuleListParser.Entry> entries) {
        HashSet<String> cnbs = new HashSet<String>();
        for (ModuleListParser.Entry e : entries) {
            cnbs.add(e.getCnb());
        }
        return cnbs;
    }

    void readCodeNameBases(Set<String> compileCNB, Set<String> testsCNB, Properties projectPropertis, String property, Set<String> allCnbs, Set<ModuleListParser.Entry> entries) {
        String prop = projectPropertis.getProperty(property);
        StringBuffer newProp = new StringBuffer();
        if (prop != null) {
            StringTokenizer tokenizer = new StringTokenizer(prop, ";:\\");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                boolean found = false;
                if (token.length() <= 1) continue;
                int lastSlash = token.lastIndexOf("/");
                int lastDot = token.lastIndexOf(".");
                if (token.endsWith("lib/boot.jar")) {
                    compileCNB.add("org.netbeans.bootstrap");
                    found = true;
                } else if (token.endsWith("core/core.jar")) {
                    compileCNB.add("org.netbeans.core.startup");
                    found = true;
                } else if (lastSlash != -1 && lastDot != -1 && lastSlash + 1 < lastDot) {
                    String codeBaseName = token.substring(lastSlash + 1, lastDot);
                    if (allCnbs.contains(codeBaseName = codeBaseName.replace('-', '.'))) {
                        compileCNB.add(codeBaseName);
                        found = true;
                    } else {
                        String name = token.substring(lastSlash + 1, token.length());
                        String wrapCNB = null;
                        for (ModuleListParser.Entry entry : entries) {
                            File[] extensions = entry.getClassPathExtensions();
                            if (extensions == null) continue;
                            for (File f : extensions) {
                                if (!f.getPath().endsWith(name)) continue;
                                if (wrapCNB != null) {
                                    found = false;
                                    System.out.println("wrapped? " + entry.getCnb() + " -> " + token + " = " + f);
                                    continue;
                                }
                                wrapCNB = entry.getCnb();
                                found = true;
                            }
                        }
                        if (found && wrapCNB != null && allCnbs.contains(wrapCNB)) {
                            compileCNB.add(wrapCNB);
                        }
                    }
                } else {
                    int firstSlash;
                    int prjEnd = token.indexOf("/build/test/unit/class");
                    if (prjEnd != -1 && (firstSlash = token.indexOf("/")) != -1 && firstSlash + 1 < prjEnd) {
                        String prjFolder = token.substring(firstSlash + 1, prjEnd);
                        String codebaseName = this.getCNBForFolder(prjFolder, entries);
                        if (codebaseName == null) {
                            this.log("No code name base found for file " + token);
                        } else {
                            testsCNB.add(codebaseName);
                            found = true;
                        }
                    }
                }
                if (found) continue;
                if (newProp.length() > 0) {
                    newProp.append(":");
                }
                token = token.replace(File.separatorChar, '/');
                newProp.append(token);
            }
            projectPropertis.setProperty(property, newProp.toString());
        }
    }

    private void addDependencies(PrintWriter buffer, Set<String> moduleCNB, Set<String> testCNB, boolean compile, boolean recursive) {
        for (String cnb : moduleCNB) {
            this.addDependency(buffer, cnb, compile, recursive, testCNB.contains(cnb));
        }
    }

    private void addDependency(PrintWriter buffer, String cnb, boolean compile, boolean recursive, boolean test) {
        buffer.println("                  <test-dependency>");
        buffer.println("                      <code-name-base>" + cnb + "</code-name-base>");
        if (recursive) {
            buffer.println("                      <recursive/>");
        }
        if (compile) {
            buffer.println("                      <compile-dependency/>");
        }
        if (test) {
            buffer.println("                      <test/>");
        }
        buffer.println("                  </test-dependency>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getTestProperties() throws IOException {
        if (this.propertiesFile == null || !this.propertiesFile.isFile()) {
            throw new BuildException("Property file doesn't exist");
        }
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(this.propertiesFile);
        try {
            props.load(fis);
        }
        finally {
            fis.close();
        }
        return props;
    }

    private String getCNBForFolder(String prjFolder, Set<ModuleListParser.Entry> entries) {
        for (ModuleListParser.Entry elem : entries) {
            if (!prjFolder.equals(elem.getNetbeansOrgPath())) continue;
            return elem.getCnb();
        }
        return null;
    }

    private void updateProperties(Properties projectProperties, String[] names) {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.propertiesFile));
            List<String> lines = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            reader.close();
            for (String propName : names) {
                String value = projectProperties.getProperty(propName);
                lines = this.replaceProperty(propName, value, lines);
            }
            PrintStream ps = new PrintStream(this.propertiesFile);
            for (String l : lines) {
                ps.println(l);
            }
            ps.close();
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }

    private List<String> replaceProperty(String name, String value, List<String> lines) {
        ArrayList<String> retLines = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            String pName;
            String line = lines.get(i);
            String trimmedLine = line.trim();
            int eqIdx = trimmedLine.indexOf("=");
            if (eqIdx != -1 && (pName = line.substring(0, eqIdx).trim()).equals(name)) {
                while (i < lines.size() && lines.get(i).trim().endsWith("\\")) {
                    ++i;
                }
                if (value == null || value.trim().equals("")) continue;
                retLines.add(name + "=" + value);
                continue;
            }
            retLines.add(line);
        }
        return retLines;
    }
}

