/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.plugins;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.railsprojects.RailsProject;
import org.netbeans.modules.ruby.railsprojects.plugins.Plugin;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginAction;
import org.netbeans.modules.ruby.railsprojects.plugins.PluginProgressPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    private static final String PLUGIN_CUSTOMIZER = "plugin.rb";
    private RailsProject project;
    private List<Plugin> installed;
    private static List<Plugin> available;
    private static List<Plugin> cachedAvailable;

    public PluginManager(RailsProject railsProject) {
        this.project = railsProject;
    }

    private FileObject getPluginDir() {
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("vendor/plugins");
        return fileObject;
    }

    public String getPluginProblem() {
        FileObject fileObject = this.getPluginDir();
        if (fileObject == null) {
            return NbBundle.getMessage(PluginAction.class, (String)"CannotFindPluginRepository");
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (!file.canWrite()) {
            return NbBundle.getMessage(PluginAction.class, (String)"PluginNotWritable");
        }
        return null;
    }

    public boolean isPluginInstalled(String string) {
        FileObject fileObject = this.getPluginDir();
        return fileObject != null && fileObject.getFileObject(string) != null;
    }

    public List<Plugin> getInstalledPlugins(boolean bl, String string, List<String> list) {
        if (bl || this.installed == null || this.installed.size() == 0) {
            this.installed = new ArrayList<Plugin>(40);
            this.refreshList(this.installed, string, true, list);
        }
        return this.installed;
    }

    public List<Plugin> getAvailablePlugins(boolean bl, String string, List<String> list) {
        if (bl || available == null || available.size() == 0) {
            available = new ArrayList<Plugin>(300);
            this.refreshList(available, string, false, list);
            if (available.size() > 1) {
                this.updateCachedList(list);
            }
        }
        return available;
    }

    public boolean hasUptodateAvailableList() {
        return false;
    }

    public List<Plugin> getCachedAvailablePlugins() {
        return null;
    }

    private void refreshList(List<Plugin> list, String string, boolean bl, List<String> list2) {
        list.clear();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add("-s");
            arrayList.add(string);
        }
        if (bl) {
            arrayList.add("--local");
        } else {
            arrayList.add("--remote");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        boolean bl2 = this.pluginRunner("list", null, null, list2, stringArray);
        if (bl2) {
            this.parsePluginList(list2, list, bl);
            Collections.sort(list);
        }
    }

    private void parsePluginList(List<String> list, List<Plugin> list2, boolean bl) {
        Plugin plugin = null;
        boolean bl2 = false;
        for (String string : list) {
            char c;
            int n;
            if (string.trim().length() == 0 || string.startsWith("/") || string.startsWith("Discovering plugins in ")) continue;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = string.length();
            for (n = 0; n < n2 && !Character.isWhitespace(c = string.charAt(n)); ++n) {
                stringBuilder.append(c);
            }
            String string2 = stringBuilder.toString();
            while (n < n2 && !Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            while (n < n2 && Character.isWhitespace(string.charAt(n))) {
                ++n;
            }
            String string3 = null;
            if (n < n2) {
                char c2;
                stringBuilder = new StringBuilder();
                while (n < n2 && !Character.isWhitespace(c2 = string.charAt(n))) {
                    stringBuilder.append(c2);
                    ++n;
                }
                if (stringBuilder.length() > 0) {
                    string3 = stringBuilder.toString();
                }
            }
            plugin = new Plugin(string2, string3);
            list2.add(plugin);
        }
    }

    private void asynchPluginRunner(final JComponent jComponent, String string, final String string2, final String string3, final List<String> list, final Runnable runnable, final String string4, final String ... stringArray) {
        final Cursor cursor = jComponent.getCursor();
        Cursor cursor2 = Cursor.getPredefinedCursor(3);
        jComponent.setCursor(cursor2);
        final JButton jButton = new JButton(NbBundle.getMessage(PluginManager.class, (String)"CTL_Close"));
        final JButton jButton2 = new JButton(NbBundle.getMessage(PluginManager.class, (String)"CTL_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PluginManager.class, (String)"AD_Close"));
        Object[] objectArray = new Object[]{jButton, jButton2};
        jButton.setEnabled(false);
        final PluginProgressPanel pluginProgressPanel = new PluginProgressPanel(NbBundle.getMessage(PluginManager.class, (String)"PluginPleaseWait"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)pluginProgressPanel, string, true, objectArray, (Object)jButton, 0, new HelpCtx(PluginProgressPanel.class), null);
        dialogDescriptor.setModal(true);
        final Process[] processArray = new Process[1];
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                dialog.setVisible(false);
                dialog.dispose();
                jComponent.setCursor(cursor);
            }
        });
        Runnable runnable2 = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    boolean bl = PluginManager.this.pluginRunner(string4, pluginProgressPanel, processArray, list, stringArray);
                    jButton.setEnabled(true);
                    jButton2.setEnabled(false);
                    pluginProgressPanel.done(bl ? string2 : string3);
                    if (bl && runnable != null) {
                        runnable.run();
                    }
                }
                finally {
                    jComponent.setCursor(cursor);
                }
            }
        };
        RequestProcessor.getDefault().post(runnable2, 50);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.CANCEL_OPTION || dialogDescriptor.getValue() == jButton2) {
            jComponent.setCursor(cursor);
            jButton2.setEnabled(false);
            Process process = processArray[0];
            if (process != null) {
                process.destroy();
                dialog.setVisible(false);
                dialog.dispose();
            }
        }
    }

    private boolean pluginRunner(String string, PluginProgressPanel pluginProgressPanel, Process[] processArray, List<String> list, String ... stringArray) {
        boolean bl;
        InputStream inputStream;
        int n;
        block21: {
            String string22;
            String string3 = "script" + File.separator + "plugin";
            ArrayList<String> arrayList = new ArrayList<String>();
            RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)this.project);
            File file = new File(rubyPlatform.getInterpreter());
            if (!file.getName().startsWith("jruby") || ExecutionUtils.launchJRubyScript()) {
                arrayList.add(file.getPath());
            }
            arrayList.addAll(ExecutionUtils.getRubyArgs((RubyPlatform)rubyPlatform));
            arrayList.add("-r" + PluginManager.getPluginCustomizer().getAbsolutePath());
            arrayList.add(string3);
            arrayList.add(string);
            for (String string22 : stringArray) {
                arrayList.add(string22);
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray2);
            File file2 = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            processBuilder.directory(file2);
            processBuilder.redirectErrorStream(true);
            Util.adjustProxy((ProcessBuilder)processBuilder);
            string22 = new RubyExecutionDescriptor(rubyPlatform, "plugin", processBuilder.directory()).cmd(file);
            ExecutionUtils.setupProcessEnvironment(processBuilder.environment(), (String)string22.getCmd().getParent(), (boolean)string22.getAppendJdkToPath());
            if (list == null) {
                list = new ArrayList<String>(40);
            }
            n = -1;
            try {
                String string4;
                String string5;
                BufferedReader bufferedReader;
                InputStreamReader inputStreamReader;
                Process process;
                block20: {
                    process = processBuilder.start();
                    if (processArray != null) {
                        processArray[0] = process;
                    }
                    inputStream = process.getInputStream();
                    if (pluginProgressPanel != null) {
                        pluginProgressPanel.setProcessInput(process.getOutputStream());
                    }
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    try {
                        while ((string5 = bufferedReader.readLine()) != null) {
                            if (pluginProgressPanel != null) {
                                pluginProgressPanel.appendOutput(string5);
                            }
                            list.add(string5);
                        }
                    }
                    catch (IOException iOException) {
                        string4 = "*** Plugin Process Killed ***\n";
                        list.add(string4);
                        if (pluginProgressPanel == null) break block20;
                        pluginProgressPanel.appendOutput(string4);
                    }
                }
                if ((n = process.waitFor()) == 0) break block21;
                try {
                    inputStream = process.getErrorStream();
                    inputStreamReader = new InputStreamReader(inputStream);
                    bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string5 = bufferedReader.readLine()) != null) {
                        if (pluginProgressPanel != null) {
                            pluginProgressPanel.appendOutput(string5);
                        }
                        list.add(string5);
                    }
                }
                catch (IOException iOException) {
                    string4 = "*** Plugin Process Killed ***\n";
                    list.add(string4);
                    if (pluginProgressPanel != null) {
                        pluginProgressPanel.appendOutput(string4);
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            catch (InterruptedException interruptedException) {
                ErrorManager.getDefault().notify((Throwable)interruptedException);
            }
        }
        boolean bl2 = bl = n == 0;
        if (bl && "remove".equals(string) && stringArray != null && stringArray[0] != null && (inputStream = this.project.getProjectDirectory().getFileObject("vendor/plugins/" + stringArray[0])) != null) {
            try {
                inputStream.delete();
            }
            catch (IOException iOException) {
                bl = false;
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return bl;
    }

    public boolean install(Plugin[] pluginArray, JComponent jComponent, String string, boolean bl, boolean bl2, String string2, boolean bl3, Runnable runnable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add("-s");
            arrayList.add(string);
        }
        for (Plugin object2 : pluginArray) {
            arrayList.add(object2.getName());
        }
        if (bl) {
            arrayList.add("--externals");
        } else if (bl2) {
            arrayList.add("--checkout");
        }
        if (string2 != null && (bl || bl2)) {
            arrayList.add("--revision");
            arrayList.add(string2);
        }
        arrayList.add("--force");
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        String string3 = NbBundle.getMessage(PluginManager.class, (String)"Installation");
        String string4 = NbBundle.getMessage(PluginManager.class, (String)"InstallationOk");
        String string5 = NbBundle.getMessage(PluginManager.class, (String)"InstallationFailed");
        String string6 = "install";
        if (bl3) {
            this.asynchPluginRunner(jComponent, string3, string4, string5, null, runnable, string6, (String[])objectArray);
            return false;
        }
        boolean bl4 = this.pluginRunner(string6, null, null, null, (String[])objectArray);
        return bl4;
    }

    public boolean uninstall(Plugin[] pluginArray, String string, JComponent jComponent, boolean bl, Runnable runnable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            arrayList.add("-s");
            arrayList.add(string);
        }
        int n = arrayList.size();
        arrayList.add("placeholder");
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        String string2 = NbBundle.getMessage(PluginManager.class, (String)"Uninstallation");
        String string3 = NbBundle.getMessage(PluginManager.class, (String)"UninstallationOk");
        String string4 = NbBundle.getMessage(PluginManager.class, (String)"UninstallationFailed");
        String string5 = "remove";
        if (bl) {
            for (Plugin plugin : pluginArray) {
                stringArray[n] = plugin.getName();
                this.asynchPluginRunner(jComponent, string2, string3, string4, null, runnable, string5, stringArray);
            }
            return false;
        }
        boolean bl2 = true;
        for (Plugin plugin : pluginArray) {
            stringArray[n] = plugin.getName();
            if (this.pluginRunner(string5, null, null, null, stringArray)) continue;
            bl2 = false;
        }
        return bl2;
    }

    public boolean update(Plugin[] pluginArray, String string, String string2, JComponent jComponent, boolean bl, Runnable runnable) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string2 != null) {
            arrayList.add("-s");
            arrayList.add(string2);
        }
        assert (string == null || string.length() == 0 || pluginArray.length == 1);
        if (pluginArray != null) {
            for (Plugin object2 : pluginArray) {
                arrayList.add(object2.getName());
            }
        }
        if (string != null) {
            arrayList.add("--revision");
            arrayList.add(string);
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        String string3 = NbBundle.getMessage(PluginManager.class, (String)"Update");
        String string4 = NbBundle.getMessage(PluginManager.class, (String)"UpdateOk");
        String string5 = NbBundle.getMessage(PluginManager.class, (String)"UpdateFailed");
        String string6 = "update";
        if (bl) {
            this.asynchPluginRunner(jComponent, string3, string4, string5, null, runnable, string6, (String[])objectArray);
            return false;
        }
        boolean bl2 = this.pluginRunner(string6, null, null, null, (String[])objectArray);
        return bl2;
    }

    public boolean removeRepositories(String[] stringArray, JComponent jComponent, ProgressHandle progressHandle, boolean bl, Runnable runnable) {
        return this.modifyRepositories("unsource", stringArray, jComponent, progressHandle, bl, runnable);
    }

    public boolean addRepositories(String[] stringArray, JComponent jComponent, ProgressHandle progressHandle, boolean bl, Runnable runnable) {
        return this.modifyRepositories("source", stringArray, jComponent, progressHandle, bl, runnable);
    }

    public boolean modifyRepositories(String string, String[] stringArray, JComponent jComponent, ProgressHandle progressHandle, boolean bl, Runnable runnable) {
        String string22;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string22 : stringArray) {
            arrayList.add(string22);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        String string3 = NbBundle.getMessage(PluginManager.class, (String)"ModifySource");
        String string4 = NbBundle.getMessage(PluginManager.class, (String)"ModifySourceOk");
        string22 = NbBundle.getMessage(PluginManager.class, (String)"ModifySourceFailed");
        if (bl) {
            this.asynchPluginRunner(jComponent, string3, string4, string22, null, runnable, string, stringArray2);
            return false;
        }
        boolean bl2 = this.pluginRunner(string, null, null, null, stringArray2);
        return bl2;
    }

    public List<String> getRepositories(boolean bl) {
        return bl ? this.getLocalRepositories() : this.getRemoteRepositories();
    }

    private List<String> getRemoteRepositories() {
        ArrayList<String> arrayList = new ArrayList<String>(150);
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add("--list");
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        boolean bl = this.pluginRunner("discover", null, null, arrayList, stringArray);
        if (bl) {
            return arrayList;
        }
        return Collections.emptyList();
    }

    private List<String> getLocalRepositories() {
        ArrayList<String> arrayList = new ArrayList<String>(150);
        ArrayList arrayList2 = new ArrayList();
        String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
        boolean bl = this.pluginRunner("sources", null, null, arrayList, stringArray);
        if (bl) {
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Plugin> getCachedList() {
        Class<PluginManager> clazz = PluginManager.class;
        synchronized (PluginManager.class) {
            BufferedReader bufferedReader = null;
            try {
                File file = PluginManager.getCacheFile();
                if (!file.exists()) {
                    List<Plugin> list = null;
                    // ** MonitorExit[clazz] (shouldn't be in output)
                    return list;
                }
                ArrayList<String> arrayList = new ArrayList<String>(5000);
                bufferedReader = new BufferedReader(new FileReader(PluginManager.getCacheFile()));
                while (true) {
                    Object object2;
                    if ((object2 = bufferedReader.readLine()) == null) {
                        object2 = new ArrayList();
                        this.parsePluginList(arrayList, (List<Plugin>)object2, false);
                        Object object = object2;
                        // ** MonitorExit[clazz] (shouldn't be in output)
                        return object;
                    }
                    arrayList.add((String)object2);
                }
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                List<Plugin> list = null;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return list;
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException3) {
                        Exceptions.printStackTrace((Throwable)iOException3);
                    }
                }
            }
        }
    }

    private void updateCachedList(List<String> list) {
    }

    private static File getCacheFile() {
        return new File(PluginManager.getCacheFolder(), "remotePlugins.txt");
    }

    private static File getCacheFolder() {
        String string = System.getProperty("netbeans.user");
        assert (string != null);
        File file = new File(string);
        File file2 = FileUtil.normalizeFile((File)new File(file, "var" + File.separator + "cache" + File.separatorChar));
        if (!file2.exists()) {
            boolean bl = file2.mkdirs();
            assert (bl) : "Cannot create cache folder";
        } else assert (file2.isDirectory() && file2.canRead() && file2.canWrite());
        return file2;
    }

    private static synchronized File getPluginCustomizer() {
        File file = InstalledFileLocator.getDefault().locate(PLUGIN_CUSTOMIZER, "org.netbeans.modules.ruby.railsproject", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate plugin.rb");
        }
        return file;
    }
}

