/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.io.File;
import java.util.HashMap;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.codecoverage.RubyCoverageProvider;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.RubyTestRunnerNodeFactory;
import org.netbeans.modules.ruby.testrunner.TestExecutionManager;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.TestUnitRunner;
import org.netbeans.modules.ruby.testrunner.ui.AutotestHandlerFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.NbBundle;

public class AutotestRunner
implements TestRunner {
    private static final Logger LOGGER = Logger.getLogger(AutotestRunner.class.getName());
    private static final TestRunner INSTANCE = new AutotestRunner();
    static final String AUTOTEST_LOADER = "nb_autotest_loader.rb";

    public TestRunner getInstance() {
        return INSTANCE;
    }

    public boolean supports(TestRunner.TestType testType) {
        return TestRunner.TestType.AUTOTEST == testType;
    }

    public void runTest(FileObject fileObject, boolean bl) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runSingleTest(FileObject fileObject, String string, boolean bl) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void runAllTests(Project project, boolean bl) {
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (!rubyPlatform.hasValidAutoTest(true)) {
            return;
        }
        String string = NbBundle.getMessage(AutotestRunner.class, (String)"AutoTest", (Object)ProjectUtils.getInformation((Project)project).getDisplayName());
        LineConvertors.FileLocator fileLocator = (LineConvertors.FileLocator)project.getLookup().lookup(LineConvertors.FileLocator.class);
        RubyExecutionDescriptor rubyExecutionDescriptor = new RubyExecutionDescriptor(rubyPlatform, string, FileUtil.toFile((FileObject)project.getProjectDirectory()), rubyPlatform.getAutoTest());
        TestRunnerUtilities.addProperties(rubyExecutionDescriptor, project);
        rubyExecutionDescriptor.addInitialArgs("-r \"" + AutotestRunner.getLoaderScript().getAbsolutePath() + "\"");
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        TestUnitRunner.addTestUnitRunnerToEnv(hashMap);
        rubyExecutionDescriptor.addAdditionalEnv(hashMap);
        rubyExecutionDescriptor.debug(bl);
        rubyExecutionDescriptor.allowInput();
        rubyExecutionDescriptor.fileLocator(fileLocator);
        rubyExecutionDescriptor.addStandardRecognizers();
        RubyCoverageProvider rubyCoverageProvider = RubyCoverageProvider.get((Project)project);
        if (rubyCoverageProvider != null && rubyCoverageProvider.isEnabled()) {
            rubyExecutionDescriptor = rubyCoverageProvider.wrapWithCoverage(rubyExecutionDescriptor, false, null);
        }
        TestSession testSession = new TestSession(string, project, bl ? TestSession.SessionType.DEBUG : TestSession.SessionType.TEST, (TestRunnerNodeFactory)new RubyTestRunnerNodeFactory());
        TestExecutionManager.getInstance().start(rubyExecutionDescriptor, new AutotestHandlerFactory(), testSession);
    }

    private static File getLoaderScript() {
        File file = InstalledFileLocator.getDefault().locate(AUTOTEST_LOADER, "org.netbeans.modules.ruby.testrunner", false);
        if (file == null) {
            throw new IllegalStateException("Could not locate nb_autotest_loader.rb");
        }
        return file;
    }
}

