/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner;

import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.platform.execution.RubyExecutionDescriptor;
import org.netbeans.modules.ruby.platform.execution.RubyProcessCreator;
import org.netbeans.modules.ruby.testrunner.RubyOutputLineHandler;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerInputProcessorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRunnerLineConvertor;
import org.openide.LifecycleManager;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public final class TestExecutionManager
implements RerunHandler {
    private static final Logger LOGGER = Logger.getLogger(TestExecutionManager.class.getName());
    private ExecutionService execution;
    private Future<Integer> result;
    private boolean finished;
    private TestRunnerLineConvertor outConvertor;
    private TestRunnerLineConvertor errConvertor;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final RequestProcessor testExecutionProcessor = new RequestProcessor("Ruby Test Execution Processor");
    private static final TestExecutionManager INSTANCE = new TestExecutionManager();

    private TestExecutionManager() {
    }

    public static TestExecutionManager getInstance() {
        return INSTANCE;
    }

    synchronized void finish() {
        this.setFinished(true);
    }

    synchronized void reset() {
        this.finished = false;
    }

    synchronized void init(RubyExecutionDescriptor rubyExecutionDescriptor) {
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor);
        ExecutionDescriptor executionDescriptor = rubyExecutionDescriptor.toExecutionDescriptor();
        this.execution = ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)executionDescriptor, (String)rubyExecutionDescriptor.getDisplayName());
    }

    synchronized void start(RubyExecutionDescriptor rubyExecutionDescriptor, TestHandlerFactory testHandlerFactory, TestSession testSession) {
        this.setFinished(false);
        testSession.setRerunHandler((RerunHandler)this);
        Manager manager = Manager.getInstance();
        this.outConvertor = new TestRunnerLineConvertor(manager, testSession, testHandlerFactory);
        this.errConvertor = new TestRunnerLineConvertor(manager, testSession, testHandlerFactory);
        testSession.setOutputLineHandler((OutputLineHandler)new RubyOutputLineHandler(testSession.getFileLocator()));
        rubyExecutionDescriptor.addOutConvertor((LineConvertor)this.outConvertor);
        rubyExecutionDescriptor.addErrConvertor((LineConvertor)this.errConvertor);
        rubyExecutionDescriptor.setOutProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunnerInputProcessorFactory(manager, testSession, testHandlerFactory.printSummary()));
        rubyExecutionDescriptor.setErrProcessorFactory((ExecutionDescriptor.InputProcessorFactory)new TestRunnerInputProcessorFactory(manager, testSession, false));
        rubyExecutionDescriptor.lineBased(true);
        RubyProcessCreator rubyProcessCreator = new RubyProcessCreator(rubyExecutionDescriptor);
        final Runnable runnable = rubyExecutionDescriptor.getPostBuild();
        ExecutionDescriptor executionDescriptor = rubyExecutionDescriptor.toExecutionDescriptor().postExecution(new Runnable(){

            public void run() {
                TestExecutionManager.this.refresh();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
        this.execution = ExecutionService.newService((Callable)rubyProcessCreator, (ExecutionDescriptor)executionDescriptor, (String)rubyExecutionDescriptor.getDisplayName());
        this.runExecution();
    }

    private void runExecution() {
        this.result = this.execution.run();
        this.testExecutionProcessor.post(new Runnable(){

            public void run() {
                try {
                    TestExecutionManager.this.result.get();
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
                catch (CancellationException cancellationException) {
                    // empty catch block
                }
                TestExecutionManager.this.setFinished(TestExecutionManager.this.result.isDone());
            }
        });
    }

    public synchronized boolean enabled() {
        return this.finished || this.result != null && this.result.isDone();
    }

    private void setFinished(boolean bl) {
        this.finished = bl;
        this.changeSupport.fireChange();
    }

    public synchronized void rerun() {
        assert (this.enabled());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Re-running: " + this.execution);
        }
        this.refresh();
        this.setFinished(false);
        LifecycleManager.getDefault().saveAll();
        this.runExecution();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public synchronized void refresh() {
        if (this.outConvertor != null) {
            this.outConvertor.refreshSession();
        }
        if (this.errConvertor != null) {
            this.errConvertor.refreshSession();
        }
    }
}

