/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.Locator;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.testrunner.ui.BaseTestMethodNodeAction;
import org.netbeans.modules.ruby.testrunner.ui.JumpToCallStackAction;
import org.netbeans.modules.ruby.testrunner.ui.JumpToTestAction;
import org.netbeans.modules.ruby.testrunner.ui.RunTestMethodAction;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class RubyTestMethodNode
extends TestMethodNode {
    public RubyTestMethodNode(Testcase testcase, Project project) {
        super(testcase, project, Lookups.singleton((Object)new Locator(){

            public void jumpToSource(Node node) {
                node.getPreferredAction().actionPerformed(null);
            }
        }));
    }

    public Action getPreferredAction() {
        String string = RubyTestMethodNode.getTestLocation(this.testcase, this.project);
        String string2 = this.getTestCaseLineFromStackTrace(this.testcase);
        String string3 = string2 != null ? string2 : string;
        return string3 == null ? new JumpToTestAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_GoToSource"), false) : new JumpToCallStackAction((Node)this, string3);
    }

    static String getTestLocation(Testcase testcase, Project project) {
        if (testcase.getLocation() == null) {
            return null;
        }
        RubyPlatform rubyPlatform = RubyPlatform.platformFor((Project)project);
        if (rubyPlatform != null && rubyPlatform.isJRuby()) {
            return null;
        }
        return testcase.getLocation();
    }

    private String getTestCaseLineFromStackTrace(Testcase testcase) {
        String string;
        if (testcase.getTrouble() == null) {
            return null;
        }
        String[] stringArray = testcase.getTrouble().getStackTrace();
        if (stringArray == null || stringArray.length <= 1) {
            return null;
        }
        if (stringArray.length > 2 && (string = RubyTestMethodNode.findLocationLine(stringArray, testcase.getName(), this.getFileName(testcase))) != null) {
            return string;
        }
        return stringArray[1];
    }

    static final String findLocationLine(String[] stringArray, String string, String string2) {
        String string3 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].contains(string2)) continue;
            if (stringArray[i].contains(string)) {
                string3 = stringArray[i];
                break;
            }
            if (string3 != null) continue;
            string3 = stringArray[i];
        }
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    private String getFileName(Testcase testcase) {
        String string;
        FileObject fileObject = BaseTestMethodNodeAction.getTestSourceRoot(this.project);
        DeclarationFinder.DeclarationLocation declarationLocation = RubyDeclarationFinder.getTestDeclaration((FileObject)fileObject, (String)(string = BaseTestMethodNodeAction.getTestMethod(testcase)), (boolean)true, (boolean)true);
        FileObject fileObject2 = declarationLocation.getFileObject();
        if (fileObject2 != null) {
            return fileObject2.getNameExt();
        }
        return RubyUtils.camelToUnderlinedName((String)testcase.getClassName());
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return new Action[0];
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.getPreferredAction());
        arrayList.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_RerunTest"), false));
        arrayList.add((Object)new RunTestMethodAction(this.testcase, this.project, NbBundle.getMessage(RubyTestMethodNode.class, (String)"LBL_DebugTest"), true));
        arrayList.add(new DiffViewAction(this.testcase));
        return arrayList.toArray(new Action[arrayList.size()]);
    }
}

