/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestRunnerLineConvertor
implements LineConvertor {
    private static final Logger LOGGER = Logger.getLogger(TestRunnerLineConvertor.class.getName());
    private final Manager manager;
    private TestSession session;
    private final List<TestRecognizerHandler> handlers;

    public TestRunnerLineConvertor(Manager manager, TestSession testSession, TestHandlerFactory testHandlerFactory) {
        this.manager = manager;
        this.session = testSession;
        this.handlers = testHandlerFactory.createHandlers();
    }

    public synchronized void refreshSession() {
        RerunHandler rerunHandler = this.session.getRerunHandler();
        this.session = new TestSession(this.session.getName(), this.session.getProject(), this.session.getSessionType(), this.session.getNodeFactory());
        this.session.setRerunHandler(rerunHandler);
    }

    public synchronized List<ConvertedLine> convert(String string) {
        for (TestRecognizerHandler testRecognizerHandler : this.handlers) {
            if (!testRecognizerHandler.matches(string)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Handler [" + testRecognizerHandler + "] matched line: " + string);
            }
            try {
                testRecognizerHandler.updateUI(this.manager, this.session);
                return this.asConvertedLines(testRecognizerHandler.getRecognizedOutput());
            }
            catch (IllegalStateException illegalStateException) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + string + " with handler: " + testRecognizerHandler, illegalStateException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                LOGGER.log(Level.WARNING, "Failed to process line: " + string + " with handler: " + testRecognizerHandler, indexOutOfBoundsException);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "No handler for line: " + string);
        }
        this.session.addOutput(string);
        this.manager.displayOutput(this.session, string, false);
        return null;
    }

    private List<ConvertedLine> asConvertedLines(List<String> list) {
        ArrayList<ConvertedLine> arrayList = new ArrayList<ConvertedLine>(list.size());
        boolean bl = false;
        for (String string : list) {
            for (LineConvertor lineConvertor : RubyLineConvertorFactory.getStandardConvertors((LineConvertors.FileLocator)this.session.getFileLocator())) {
                List list2 = lineConvertor.convert(string);
                if (list2 == null) continue;
                arrayList.addAll(list2);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(ConvertedLine.forText((String)string, null));
        }
        return arrayList;
    }
}

