/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class TestRestServicesAction
extends NodeAction {
    public String getName() {
        return NbBundle.getMessage(TestRestServicesAction.class, (String)"LBL_TestRestServicesAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean enable(Node[] nodeArray) {
        if (nodeArray.length != 1) {
            return false;
        }
        Project project = (Project)nodeArray[0].getLookup().lookup(Project.class);
        return project != null && project.getLookup().lookup(RestSupport.class) != null;
    }

    protected void performAction(Node[] nodeArray) {
        Project project = (Project)nodeArray[0].getLookup().lookup(Project.class);
        if (project != null) {
            FileObject fileObject = Utils.findBuildXml(project);
            if (fileObject != null) {
                try {
                    Properties properties = this.setupTestRestBeans(project);
                    ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"test-restbeans"}, (Properties)properties);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            } else {
                RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
                if (restSupport != null) {
                    try {
                        URL uRL;
                        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
                        FileObject fileObject2 = restSupport.generateTestClient(file);
                        if (fileObject2 != null && (uRL = fileObject2.getURL()) != null) {
                            HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        }
    }

    public boolean asynchronous() {
        return true;
    }

    private Properties setupTestRestBeans(Project project) throws IOException {
        Properties properties = new Properties();
        properties.setProperty("base.url.token", "___BASE_URL___");
        RestSupport restSupport = (RestSupport)project.getLookup().lookup(RestSupport.class);
        AntProjectHelper antProjectHelper = restSupport.getAntProjectHelper();
        EditableProperties editableProperties = antProjectHelper.getProperties("nbproject/project.properties");
        String string = editableProperties.getProperty("restbeans.test.dir");
        if (string == null) {
            string = "build/generated/rest-test";
        }
        File file = antProjectHelper.resolveFile(string);
        FileObject fileObject = restSupport.generateTestClient(file);
        properties.setProperty("restbeans.test.url", fileObject.getURL().toString());
        properties.setProperty("restbeans.test.file", FileUtil.toFile((FileObject)fileObject).getAbsolutePath());
        return properties;
    }
}

