/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.projects;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.web.spi.webmodule.WebModuleProvider;
import org.netbeans.modules.websvc.rest.projects.AntFilesHelper;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRs;
import org.netbeans.modules.websvc.wsstack.jaxrs.JaxRsStackProvider;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebProjectRestSupport
extends WebRestSupport {
    public static final String J2EE_SERVER_INSTANCE = "j2ee.server.instance";
    public static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    String[] classPathTypes = new String[]{"classpath/compile", "classpath/execute"};

    public WebProjectRestSupport(Project project) {
        super(project);
    }

    public void upgrade() {
        if (!this.isRestSupportOn()) {
            return;
        }
        try {
            FileObject fileObject = this.getDeploymentDescriptor();
            WebApp webApp = this.getWebApp();
            if (webApp == null) {
                return;
            }
            Servlet servlet = this.getRestServletAdaptor(webApp);
            if (servlet != null && "com.sun.ws.rest.impl.container.servlet.ServletAdaptor".equals(servlet.getServletClass())) {
                servlet.setServletClass(this.getServletAdapterClass());
                webApp.write(fileObject);
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public void extendBuildScripts() throws IOException {
        new AntFilesHelper((RestSupport)this).initRestBuildExtension();
    }

    public void ensureRestDevelopmentReady() throws IOException {
        boolean bl = false;
        if (!this.isRestSupportOn()) {
            bl = true;
            this.setProjectProperty("rest.support.on", "true");
        }
        this.extendBuildScripts();
        this.addSwdpLibrary();
        this.addResourceConfigToWebApp();
        ProjectManager.getDefault().saveProject(this.getProject());
        if (bl) {
            this.refreshRestServicesMetadataModel();
        }
    }

    public void removeRestDevelopmentReadiness() throws IOException {
        this.removeResourceConfigFromWebApp();
        this.removeSwdpLibrary(new String[]{"classpath/compile", "classpath/execute"});
        this.setProjectProperty("rest.support.on", "false");
        ProjectManager.getDefault().saveProject(this.getProject());
    }

    public boolean isReady() {
        return this.isRestSupportOn() && this.hasSwdpLibrary() && this.hasRestServletAdaptor();
    }

    private boolean platformHasRestLib(J2eePlatform j2eePlatform) {
        WSStack wSStack;
        if (j2eePlatform != null && (wSStack = JaxRsStackProvider.getJaxRsStack((J2eePlatform)j2eePlatform)) != null) {
            return wSStack.isFeatureSupported((WSStack.Feature)JaxRs.Feature.JAXRS);
        }
        return false;
    }

    public boolean hasSwdpLibrary() {
        J2eePlatform j2eePlatform = this.getPlatform();
        if (j2eePlatform == null) {
            return false;
        }
        if (this.platformHasRestLib(j2eePlatform)) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (File file : j2eePlatform.getClasspathEntries()) {
            if (file.getName().equals("jsr311-api.jar")) {
                bl = true;
            }
            if (file.getName().equals("jersey.jar")) {
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    public J2eePlatform getPlatform() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return null;
        }
        return Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
    }

    private void addSwdpLibrary() throws IOException {
        if (!this.hasSwdpLibrary()) {
            this.addSwdpLibrary(this.classPathTypes);
        } else {
            J2eePlatform j2eePlatform = this.getPlatform();
            WSStack wSStack = JaxRsStackProvider.getJaxRsStack((J2eePlatform)j2eePlatform);
            if (wSStack != null) {
                WSTool wSTool;
                Library library;
                String string = "restlib_gfv3";
                if (wSStack.getVersion().equals((Object)WSStackVersion.valueOf((int)2, (int)1, (int)3, (int)0))) {
                    string = "restlib_gfv2";
                }
                if ((library = LibraryManager.getDefault().getLibrary(string)) == null && (wSTool = wSStack.getWSTool((WSStack.Tool)JaxRs.Tool.JAXRS)) != null) {
                    URL[] uRLArray = wSTool.getLibraries();
                    try {
                        ArrayList<File> arrayList = new ArrayList<File>();
                        for (URL uRL : uRLArray) {
                            if (!new File(uRL.toURI()).exists()) {
                                return;
                            }
                            arrayList.add(new File(uRL.toURI()));
                        }
                        library = this.createSwdpLibrary(arrayList, string);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
                if (library != null) {
                    this.addSwdpLibrary(this.classPathTypes, library);
                }
            }
        }
    }

    private Library createSwdpLibrary(List<File> list, String string) throws IOException {
        URL uRL;
        File file2;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file2 : list) {
            uRL = file2.toURL();
            uRL = FileUtil.getArchiveRoot((URL)uRL);
            arrayList.add(uRL);
        }
        LibraryManager libraryManager = LibraryManager.getDefault();
        file2 = LibrariesSupport.getLibraryTypeProvider((String)"j2se").createLibrary();
        file2.setName(string);
        file2.setDescription(string);
        file2.setLocalizingBundle("org/netbeans/modules/websvc/rest/projects/Bundle");
        file2.setContent("classpath", arrayList);
        uRL = LibraryFactory.createLibrary((LibraryImplementation)file2);
        libraryManager.addLibrary((Library)uRL);
        return uRL;
    }

    private FileObject getDeploymentDescriptor() {
        WebModuleProvider webModuleProvider = (WebModuleProvider)this.project.getLookup().lookup(WebModuleProvider.class);
        if (webModuleProvider != null) {
            return webModuleProvider.findWebModule(this.project.getProjectDirectory()).getDeploymentDescriptor();
        }
        return null;
    }

    public FileObject getPersistenceXml() {
        PersistenceScope persistenceScope = PersistenceScope.getPersistenceScope((FileObject)this.getProject().getProjectDirectory());
        if (persistenceScope != null) {
            return persistenceScope.getPersistenceXml();
        }
        return null;
    }

    public FileObject getApplicationContextXml() {
        FileObject fileObject;
        FileObject fileObject2;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        FileObject[] fileObjectArray = j2eeModuleProvider.getSourceRoots();
        if (fileObjectArray.length > 0 && (fileObject2 = (fileObject = fileObjectArray[0]).getFileObject("WEB-INF")) != null) {
            return fileObject2.getFileObject("applicationContext", "xml");
        }
        return null;
    }

    public Datasource getDatasource(String string) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        try {
            return j2eeModuleProvider.getConfigSupport().findDatasource(string);
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
            return null;
        }
    }

    public void setDirectoryDeploymentProperty(Properties properties) {
        String string = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty(J2EE_SERVER_INSTANCE);
        if (string != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            String string2 = j2eeModuleProvider.getServerInstanceID();
            J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
            if (string2 != null && j2eeModule != null) {
                boolean bl = Deployment.getDefault().canFileDeploy(string, j2eeModule);
                properties.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, String.valueOf(bl));
            }
        }
    }
}

