/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.websvc.rest.codegen.model.ClientStubModel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.modules.websvc.rest.spi.WebRestSupport;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.AbstractPanel;
import org.netbeans.modules.websvc.rest.wizard.BrowseFolders;
import org.netbeans.modules.websvc.rest.wizard.SourceGroupUISupport;
import org.netbeans.modules.websvc.rest.wizard.Util;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ClientStubsSetupPanelVisual
extends JPanel
implements AbstractPanel.Settings {
    private Project project;
    private FileObject stubRootFolder;
    private SourceGroup[] sourceGroups;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private FileObject wadlFile;
    private boolean isProjectSelection = true;
    private JButton addButton;
    private JButton browseButton;
    private JCheckBox createJmakiCheckBox;
    private JLabel folderLabel;
    private JTextField folderTextField;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JComboBox locationCB;
    private JLabel locationLabel;
    private JCheckBox overwriteCheckBox;
    private JLabel projectLabel;
    private JList projectList;
    private JRadioButton projectRadioButton;
    private JTextField projectTextField;
    private JButton removeButton;
    private ButtonGroup sourceButtons;
    private JButton wadlBrowseButton;
    private JRadioButton wadlRadioButton;
    private JTextField wadlTextField;

    public ClientStubsSetupPanelVisual(String string) {
        super.setName(string);
        this.initComponents();
        this.sourceButtons.add(this.projectRadioButton);
        this.sourceButtons.add(this.wadlRadioButton);
        this.projectList.addListSelectionListener(new ProjectListSelectionListener());
        this.projectRadioButton.setSelected(this.isProjectSelection);
        this.projectSelection(this.isProjectSelection);
    }

    public void read(WizardDescriptor wizardDescriptor) {
        if (this.project == null) {
            this.project = Templates.getProject((WizardDescriptor)wizardDescriptor);
            this.projectTextField.setText(ProjectUtils.getInformation((Project)this.project).getDisplayName());
            this.sourceGroups = Util.getSourceGroups(this.project);
            SourceGroupUISupport.connect(this.locationCB, this.sourceGroups);
            String string = "rest";
            if (this.createJmakiCheckBox.isSelected()) {
                string = "resources";
            }
            this.folderTextField.setText(string);
            if (this.isJmakiEnabled(this.project) && !this.createJmakiCheckBox.isEnabled()) {
                this.createJmakiCheckBox.setEnabled(true);
                this.createJmakiCheckBox.setSelected(true);
            }
        }
    }

    public void store(WizardDescriptor wizardDescriptor) {
        String string;
        DefaultListModel defaultListModel = (DefaultListModel)this.projectList.getModel();
        Project[] projectArray = new Project[defaultListModel.size()];
        for (int i = 0; i < projectArray.length; ++i) {
            projectArray[i] = ((ProjectInformation)defaultListModel.get(i)).getProject();
        }
        wizardDescriptor.putProperty("ProjectSelection", (Object)this.isProjectSelection);
        wizardDescriptor.putProperty("ProjectToStub", (Object)projectArray);
        if (this.wadlFile != null) {
            wizardDescriptor.putProperty("WadlToStub", (Object)this.wadlFile);
        }
        wizardDescriptor.putProperty("OverwriteExisting", (Object)this.overwriteCheckBox.isSelected());
        wizardDescriptor.putProperty("CreateJMakiRestComponents", (Object)this.createJmakiCheckBox.isSelected());
        if (this.stubRootFolder == null && this.sourceGroups.length > 0) {
            SourceGroup sourceGroup = (SourceGroup)this.locationCB.getSelectedItem();
            this.stubRootFolder = sourceGroup.getRootFolder();
        }
        if (this.stubRootFolder != null) {
            wizardDescriptor.putProperty("StubRootFolder", (Object)this.stubRootFolder);
        }
        string = (string = this.folderTextField.getText()) != null && string.trim().length() > 0 ? this.folderTextField.getText() : (this.createJmakiCheckBox.isSelected() ? "resources" : "rest");
        wizardDescriptor.putProperty("StubFolderName", (Object)string);
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        RestSupport restSupport = (RestSupport)this.project.getLookup().lookup(RestSupport.class);
        if (restSupport == null || restSupport.getAntProjectHelper() == null) {
            AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_NotSupportedProjectType");
            return false;
        }
        if (this.isProjectSelection) {
            DefaultListModel defaultListModel = (DefaultListModel)this.projectList.getModel();
            if (defaultListModel.getSize() < 1) {
                AbstractPanel.setInfoMessage(wizardDescriptor, "MSG_NoProjects");
                return false;
            }
        } else {
            if (this.wadlTextField.getText() == null || this.wadlTextField.getText().trim().equals("")) {
                AbstractPanel.setInfoMessage(wizardDescriptor, "MSG_NoWadlFile");
                return false;
            }
            String string = this.wadlTextField.getText().trim();
            ClientStubModel.State state = this.validateWadlFile(string);
            if (state != ClientStubModel.State.VALID) {
                AbstractPanel.setErrorMessage(wizardDescriptor, "MSG_" + state.value());
                return false;
            }
        }
        if (this.createJmakiCheckBox.isSelected() && !this.isJmakiEnabled(this.project)) {
            AbstractPanel.setInfoMessage(wizardDescriptor, "MSG_NoJmaki");
            return false;
        }
        AbstractPanel.clearErrorMessage(wizardDescriptor);
        return true;
    }

    private boolean isJmakiEnabled(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        return fileObject.getFileObject("web/glue.js") != null || fileObject.getFileObject("web/resources/jmaki.js") != null;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : this.listeners) {
            changeListener.stateChanged(changeEvent);
        }
    }

    private boolean addProject(File[] fileArray) {
        boolean bl = false;
        ArrayList<Project> arrayList = new ArrayList<Project>();
        DefaultListModel defaultListModel = (DefaultListModel)this.projectList.getModel();
        for (File file : fileArray) {
            try {
                WebRestSupport exception;
                FileObject iOException = FileUtil.toFileObject((File)file);
                Project project = ProjectManager.getDefault().findProject(iOException);
                boolean bl2 = true;
                try {
                    exception = (WebRestSupport)project.getLookup().lookup(RestSupport.class);
                    ServletMapping servletMapping = exception.getRestServletMapping(exception.getWebApp());
                    if (servletMapping != null) {
                        bl2 = false;
                    }
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                if (bl2) {
                    arrayList.add(project);
                    continue;
                }
                exception = ProjectUtils.getInformation((Project)project);
                if (defaultListModel.contains(exception)) continue;
                defaultListModel.addElement(exception);
                bl = true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (arrayList.size() > 0) {
            String string = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MSG_ProjectsWithoutREST");
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        return bl;
    }

    private void initComponents() {
        this.sourceButtons = new ButtonGroup();
        this.projectLabel = new JLabel();
        this.projectTextField = new JTextField();
        this.locationLabel = new JLabel();
        this.locationCB = new JComboBox();
        this.folderLabel = new JLabel();
        this.folderTextField = new JTextField();
        this.browseButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane1 = new JScrollPane();
        this.projectList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.overwriteCheckBox = new JCheckBox();
        this.createJmakiCheckBox = new JCheckBox();
        this.projectRadioButton = new JRadioButton();
        this.wadlRadioButton = new JRadioButton();
        this.wadlBrowseButton = new JButton();
        this.wadlTextField = new JTextField();
        this.jSeparator2 = new JSeparator();
        this.projectLabel.setLabelFor(this.projectTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_Project"));
        this.projectTextField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationCB);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_Location"));
        this.folderLabel.setLabelFor(this.folderTextField);
        Mnemonics.setLocalizedText((JLabel)this.folderLabel, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_Folder"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_BrowseFolder"));
        this.browseButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_BrowseFolder"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientStubsSetupPanelVisual.this.browseButtonActionPerformed(actionEvent);
            }
        });
        this.projectList.setModel(new DefaultListModel());
        this.projectList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                ProjectInformation projectInformation = (ProjectInformation)object;
                super.getListCellRendererComponent((JList<?>)ClientStubsSetupPanelVisual.this.projectList, projectInformation, n, bl, bl2);
                this.setIcon(projectInformation.getIcon());
                this.setText(projectInformation.getDisplayName());
                this.setToolTipText(projectInformation.getDisplayName());
                return this;
            }
        });
        this.projectList.setPreferredSize(new Dimension(0, 200));
        this.jScrollPane1.setViewportView(this.projectList);
        this.projectList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"ProjectList"));
        this.projectList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_ProjectList"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_AddProject"));
        this.addButton.setToolTipText("null");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientStubsSetupPanelVisual.this.addButtonshowProjectDialog(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_RemoveProject"));
        this.removeButton.setToolTipText("null");
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientStubsSetupPanelVisual.this.removeButtonremoveProject(actionEvent);
            }
        });
        this.overwriteCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.overwriteCheckBox, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_OverwriteExisting"));
        Mnemonics.setLocalizedText((AbstractButton)this.createJmakiCheckBox, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_CreateJmakiRestComponents"));
        this.createJmakiCheckBox.setEnabled(false);
        this.createJmakiCheckBox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ClientStubsSetupPanelVisual.this.createJmakiCheckBoxStateChanged(changeEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.projectRadioButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_ProjectsToGenerateStubFor"));
        this.projectRadioButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("DESC_ProjectList"));
        this.projectRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientStubsSetupPanelVisual.this.projectRadioButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wadlRadioButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_WADLToGenerateStubFor"));
        this.wadlRadioButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_WADLToGenerateStubFor"));
        this.wadlRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientStubsSetupPanelVisual.this.wadlRadioButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.wadlBrowseButton, (String)NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_BrowseWadl"));
        this.wadlBrowseButton.setToolTipText(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_BrowseWadl"));
        this.wadlBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClientStubsSetupPanelVisual.this.wadlBrowseButtonActionPerformed(actionEvent);
            }
        });
        this.wadlTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                ClientStubsSetupPanelVisual.this.wadlTextFieldFocusLost(focusEvent);
            }
        });
        this.wadlTextField.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                ClientStubsSetupPanelVisual.this.wadlTextFieldKeyTyped(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ClientStubsSetupPanelVisual.this.wadlTextFieldKeyReleased(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.createJmakiCheckBox).add(18, 18, 18).add((Component)this.overwriteCheckBox).addContainerGap(127, Short.MAX_VALUE)).add((Component)this.jSeparator2, -1, 525, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.projectRadioButton).add(1, (Component)this.wadlRadioButton).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(21, 21, 21).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.wadlTextField, -1, 389, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 389, Short.MAX_VALUE)).add(4, 4, 4)).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1, false).add((Component)this.folderLabel, -1, -1, Short.MAX_VALUE).add((Component)this.projectLabel, -1, -1, Short.MAX_VALUE).add((Component)this.locationLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.projectTextField, -1, 351, Short.MAX_VALUE).add(2, (Component)this.locationCB, 0, 351, Short.MAX_VALUE).add(2, (Component)this.folderTextField, -1, 351, Short.MAX_VALUE)).add(6, 6, 6))).add(0, 0, 0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((Component)this.browseButton).add((Component)this.addButton).add((Component)this.removeButton).add((Component)this.wadlBrowseButton))).add((Component)this.jSeparator1, -1, 525, Short.MAX_VALUE));
        groupLayout.linkSize(new Component[]{this.addButton, this.browseButton, this.removeButton, this.wadlBrowseButton}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.projectTextField, -2, -1, -2).add((Component)this.projectLabel)).add(7, 7, 7).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.locationCB, -2, 25, -2).add((Component)this.locationLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.browseButton).add((Component)this.folderTextField, -2, 23, -2).add((Component)this.folderLabel)).add(8, 8, 8).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.projectRadioButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 105, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.wadlRadioButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.wadlBrowseButton).add((Component)this.wadlTextField, -2, -1, -2))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton))).addPreferredGap(0).add((Component)this.jSeparator2, -2, 9, -2).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.createJmakiCheckBox).add((Component)this.overwriteCheckBox)).addContainerGap()));
        this.projectLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Project"));
        this.projectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Project"));
        this.projectTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Project"));
        this.projectTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Project"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Location"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Location"));
        this.locationCB.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Location"));
        this.locationCB.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Location"));
        this.folderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Folder"));
        this.folderLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Folder"));
        this.folderTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Folder"));
        this.folderTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_Folder"));
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"Browser"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_BrowseFolder"));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"AddProject"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_AddProject"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"RemoveProject"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_RemoveProject"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"OverwriteExistingStubs"));
        this.overwriteCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"DESC_OverwriteExisting"));
        this.wadlTextField.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_WADLToGenerateStubFor"));
        this.wadlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("HINT_WADLToGenerateStubFor"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("Templates/WebServices/RestClientStubs"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(ClientStubsSetupPanelVisual.class).getString("Templates/WebServices/RestClientStubs"));
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        Sources sources = ProjectUtils.getSources((Project)this.project);
        FileObject fileObject = BrowseFolders.showDialog(this.sourceGroups, DataFolder.class, this.folderTextField.getText().replace(File.separatorChar, '/'));
        if (fileObject != null) {
            this.stubRootFolder = fileObject;
            SourceGroup sourceGroup = SourceGroupSupport.findSourceGroupForFile(this.sourceGroups, this.stubRootFolder);
            this.locationCB.getModel().setSelectedItem(sourceGroup);
            String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)this.stubRootFolder);
            this.folderTextField.setText(string);
            this.fireChange();
        }
    }

    private void removeButtonremoveProject(ActionEvent actionEvent) {
        ListSelectionModel listSelectionModel = this.projectList.getSelectionModel();
        DefaultListModel defaultListModel = (DefaultListModel)this.projectList.getModel();
        ArrayList<ProjectInformation> arrayList = new ArrayList<ProjectInformation>();
        if (!listSelectionModel.isSelectionEmpty()) {
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                arrayList.add((ProjectInformation)defaultListModel.elementAt(i));
            }
            for (ProjectInformation projectInformation : arrayList) {
                defaultListModel.removeElement(projectInformation);
            }
        }
        if (arrayList.size() > 0) {
            this.fireChange();
        }
    }

    private void addButtonshowProjectDialog(ActionEvent actionEvent) {
        boolean bl;
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setMultiSelectionEnabled(true);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_ProjectChooserTitle"));
        jFileChooser.setDialogType(2);
        String string = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_SelectOK");
        jFileChooser.setApproveButtonText(string);
        String string2 = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MNE_SelectOK");
        jFileChooser.setApproveButtonMnemonic(string2.charAt(0));
        jFileChooser.setPreferredSize(new Dimension(650, 380));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && (bl = this.addProject(jFileChooser.getSelectedFiles()))) {
            this.fireChange();
        }
    }

    private void createJmakiCheckBoxStateChanged(ChangeEvent changeEvent) {
        if (this.createJmakiCheckBox.isSelected()) {
            this.folderTextField.setText("resources");
            this.enableFromWadl(false);
        } else {
            this.folderTextField.setText("rest");
            this.enableFromWadl(true);
        }
        this.fireChange();
    }

    private void enableFromWadl(boolean bl) {
        this.wadlRadioButton.setEnabled(bl);
        this.wadlTextField.setEnabled(bl);
        this.wadlBrowseButton.setEnabled(bl);
    }

    private void projectRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.isProjectSelection = true;
        this.projectSelection(this.isProjectSelection);
        this.fireChange();
    }

    private void projectSelection(boolean bl) {
        this.addButton.setEnabled(bl);
        this.wadlBrowseButton.setEnabled(!bl);
    }

    private void wadlRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.isProjectSelection = false;
        this.projectSelection(this.isProjectSelection);
        this.fireChange();
    }

    private void wadlBrowseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setDialogTitle(NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_WadlChooserTitle"));
        jFileChooser.setDialogType(2);
        String string = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"LBL_SelectOK");
        jFileChooser.setApproveButtonText(string);
        String string2 = NbBundle.getMessage(ClientStubsSetupPanelVisual.class, (String)"MNE_SelectOK");
        jFileChooser.setApproveButtonMnemonic(string2.charAt(0));
        jFileChooser.setPreferredSize(new Dimension(650, 380));
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.wadlTextField.setText(file.getAbsolutePath());
            this.fireChange();
        }
    }

    private void wadlTextFieldFocusLost(FocusEvent focusEvent) {
        this.fireChange();
    }

    private void wadlTextFieldKeyTyped(KeyEvent keyEvent) {
        this.fireChange();
    }

    private void wadlTextFieldKeyReleased(KeyEvent keyEvent) {
        this.fireChange();
    }

    private ClientStubModel.State validateWadlFile(String string) {
        File file = new File(string);
        ClientStubModel.State state = ClientStubModel.State.INVALID;
        try {
            FileObject fileObject;
            if (file.isFile() && (fileObject = FileUtil.toFileObject((File)file)) != null && (state = new ClientStubModel().createModel(fileObject).validate()) == ClientStubModel.State.VALID) {
                this.wadlFile = fileObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return state;
    }

    private class ProjectListSelectionListener
    implements ListSelectionListener {
        private ProjectListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getSource() == ClientStubsSetupPanelVisual.this.projectList) {
                if (ClientStubsSetupPanelVisual.this.projectList.getSelectionModel().isSelectionEmpty()) {
                    ClientStubsSetupPanelVisual.this.removeButton.setEnabled(false);
                } else {
                    ClientStubsSetupPanelVisual.this.removeButton.setEnabled(true);
                }
            }
        }
    }
}

