/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.PaintServer;
import com.sun.perseus.j2d.PaintTarget;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RasterImage;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.j2d.ViewportProperties;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.MediaElement;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.StringTraitAnim;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.TransformTraitAnim;
import com.sun.perseus.model.Transformable;
import com.sun.perseus.model.ViewportNode;
import com.sun.perseus.platform.MediaSupport;
import com.sun.perseus.platform.VideoPlayer;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;

public class VideoElement
extends MediaElement
implements ViewportNode,
PaintTarget,
Transformable {
    private VideoPlayer videoPlayer;
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float width = 0.0f;
    protected float height = 0.0f;
    protected String transformBehavior = "geometric";
    protected String overlay = "none";
    protected String initialVisibility = "whenStarted";
    protected String focusable = "auto";
    private RasterImage image;
    protected PaintServer viewportFill = INITIAL_VIEWPORT_FILL;
    protected float viewportFillOpacity = 1.0f;
    protected Transform transform;
    protected Transform txf = null;
    protected Transform inverseTxf = null;

    public VideoElement(DocumentNode doc) {
        super(doc, "video");
        this.canRenderState &= 0xFFFFFFFE;
        this.canRenderState |= 0x40;
        this.canRenderState |= 0x80;
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new VideoElement(doc);
    }

    void init() throws Exception {
        String url = this.getHref();
        if (url == null) {
            throw new Exception("media locator not set");
        }
        if (this.videoPlayer == null) {
            this.videoPlayer = MediaSupport.getVideoPlayer(url);
        }
    }

    void play(long startTime) {
        if (this.videoPlayer != null) {
            this.videoPlayer.play(startTime);
        }
    }

    void stop() {
        if (this.videoPlayer != null) {
            this.videoPlayer.stop();
        }
    }

    void close() {
        this.videoPlayer.close();
        this.videoPlayer = null;
    }

    void setVolume(float volume) {
        if (this.videoPlayer != null) {
            this.videoPlayer.setVolume(volume);
        }
    }

    public void setX(float newX) {
        if (newX == this.x) {
            return;
        }
        this.modifyingNode();
        this.x = newX;
        this.modifiedNode();
    }

    public float getX() {
        return this.x;
    }

    public void setY(float newY) {
        if (newY == this.y) {
            return;
        }
        this.modifyingNode();
        this.y = newY;
        this.modifiedNode();
    }

    public float getY() {
        return this.y;
    }

    void setWidth(float newWidth) {
        if (newWidth < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newWidth == this.width) {
            return;
        }
        this.modifyingNode();
        this.width = newWidth;
        this.computeCanRenderWidthBit(this.width);
        this.modifiedNode();
    }

    public float getWidth() {
        return this.width;
    }

    public void setHeight(float newHeight) {
        if (newHeight < 0.0f) {
            throw new IllegalArgumentException();
        }
        if (newHeight == this.height) {
            return;
        }
        this.modifyingNode();
        this.height = newHeight;
        this.computeCanRenderHeightBit(this.height);
        this.modifiedNode();
    }

    public float getHeight() {
        return this.height;
    }

    public void setOverlay(String overlayFormat) {
        if (overlayFormat == null) {
            throw new IllegalArgumentException();
        }
        if (overlayFormat.equals(this.overlay)) {
            return;
        }
        if (!"top".equals(overlayFormat) && !"none".equals(overlayFormat)) {
            throw new IllegalArgumentException("Unknown overlay format: " + overlayFormat);
        }
        this.modifyingNode();
        this.overlay = overlayFormat;
        this.modifiedNode();
    }

    public String getOverlay() {
        return this.overlay;
    }

    public void setTransformBehavior(String behavior) {
        if (behavior == null) {
            throw new IllegalArgumentException();
        }
        if (behavior.equals(this.transformBehavior)) {
            return;
        }
        if (!("geometric".equals(behavior) || "pinned".equals(behavior) || "pinned90".equals(behavior) || "pinned180".equals(behavior) || "pinned270".equals(behavior))) {
            throw new IllegalArgumentException("Unknown transform behavior: " + behavior);
        }
        this.modifyingNode();
        this.transformBehavior = behavior;
        this.modifiedNode();
    }

    public String getTransformBehavior() {
        return this.transformBehavior;
    }

    public void setInitialVisibility(String visibility) {
        if (visibility == null) {
            throw new IllegalArgumentException();
        }
        if (visibility.equals(this.initialVisibility)) {
            return;
        }
        if (!"whenStarted".equals(visibility) && !"always".equals(visibility)) {
            throw new IllegalArgumentException("Unknown initial visibility: " + visibility);
        }
        this.modifyingNode();
        this.initialVisibility = visibility;
        this.modifiedNode();
    }

    public String getInitialVisibility() {
        return this.initialVisibility;
    }

    public void setFocusable(String newFocusable) {
        if (newFocusable == null) {
            throw new IllegalArgumentException();
        }
        if (newFocusable.equals(this.focusable)) {
            return;
        }
        if (!("true".equals(newFocusable) || "false".equals(newFocusable) || "auto".equals(newFocusable))) {
            throw new IllegalArgumentException("Unknown focusable: " + newFocusable);
        }
        this.modifyingNode();
        this.focusable = newFocusable;
        this.modifiedNode();
    }

    public String getFocusable() {
        return this.focusable;
    }

    protected Object getPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill;
            }
        }
        return super.getPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity;
            }
        }
        return super.getFloatPropertyState(propertyIndex);
    }

    protected void setPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                this.viewportFill = (PaintServer)propertyValue;
                break;
            }
            default: {
                super.setPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected void setFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                this.viewportFillOpacity = propertyValue;
                break;
            }
            default: {
                super.setFloatPropertyState(propertyIndex, propertyValue);
            }
        }
    }

    protected boolean isPropertyState(int propertyIndex, Object propertyValue) {
        switch (propertyIndex) {
            case 0x200000: {
                return this.viewportFill == propertyValue;
            }
        }
        return super.isPropertyState(propertyIndex, propertyValue);
    }

    protected boolean isFloatPropertyState(int propertyIndex, float propertyValue) {
        switch (propertyIndex) {
            case 0x400000: {
                return this.viewportFillOpacity == propertyValue;
            }
        }
        return super.isFloatPropertyState(propertyIndex, propertyValue);
    }

    void recomputeInheritedProperties() {
        ModelNode p = this.ownerDocument;
        if (this.parent != null) {
            p = this.parent;
        }
        this.recomputePropertyState(0x200000, p.getPropertyState(0x200000));
        this.recomputeFloatPropertyState(0x400000, p.getFloatPropertyState(0x400000));
        super.recomputeInheritedProperties();
    }

    public void setViewportFill(PaintServer newViewportFill) {
        if (!this.isInherited(0x200000) && VideoElement.equal(newViewportFill, this.viewportFill)) {
            return;
        }
        this.modifyingNode();
        if (this.viewportFill != null) {
            this.viewportFill.dispose();
        }
        this.viewportFill = newViewportFill;
        this.setInheritedQuiet(0x200000, false);
        this.propagatePropertyState(0x200000, this.viewportFill);
        this.modifiedNode();
    }

    public PaintServer getViewportFill() {
        return this.viewportFill;
    }

    public float getViewportFillOpacity() {
        return this.viewportFillOpacity;
    }

    public void setViewportFillOpacity(float newViewportFillOpacity) {
        if (!this.isInherited(0x400000) && newViewportFillOpacity == this.getViewportFillOpacity()) {
            return;
        }
        this.modifyingNode();
        if (newViewportFillOpacity > 1.0f) {
            newViewportFillOpacity = 1.0f;
        } else if (newViewportFillOpacity < 0.0f) {
            newViewportFillOpacity = 0.0f;
        }
        this.setInheritedQuiet(0x400000, false);
        this.viewportFillOpacity = newViewportFillOpacity;
        this.propagateFloatPropertyState(0x400000, this.viewportFillOpacity);
        this.modifiedNode();
    }

    public void setTransform(Transform newTransform) {
        if (VideoElement.equal(newTransform, this.transform)) {
            return;
        }
        this.modifyingNode();
        this.transform = newTransform;
        this.recomputeTransformState();
        this.recomputeProxyTransformState();
        this.modifiedNode();
    }

    public Transform getTransform() {
        return this.transform;
    }

    protected void recomputeTransformState(Transform parentTransform) {
        this.txf = this.appendTransform(parentTransform, this.txf);
        this.computeCanRenderTransformBit(this.txf);
        this.inverseTxf = null;
        this.recomputeTransformState(this.txf, this.getFirstChildNode());
    }

    public Transform getTransformState() {
        return this.txf;
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.transform == null) {
            return tx;
        }
        tx = this.recycleTransform(tx, workTx);
        if (this.transform != null) {
            tx.mMultiply(this.transform);
        }
        return tx;
    }

    Transform getInverseTransformState() {
        if ((this.canRenderState & 0x10) == 0) {
            if (this.inverseTxf == null) {
                if (this.parent != null && this.txf == this.parent.getTransformState()) {
                    this.inverseTxf = this.parent.getInverseTransformState();
                } else {
                    this.inverseTxf = new Transform(null);
                    try {
                        this.inverseTxf = (Transform)this.txf.inverse(this.inverseTxf);
                    }
                    catch (Exception e) {
                        throw new Error();
                    }
                }
            }
        } else {
            this.inverseTxf = null;
        }
        return this.inverseTxf;
    }

    boolean supportsTrait(String traitName) {
        if ("x" == traitName || "y" == traitName || "width" == traitName || "height" == traitName || "transformBehavior" == traitName || "overlay" == traitName || "initialVisibility" == traitName || "focusable" == traitName || "transform" == traitName || "viewport-fill" == traitName || "viewport-fill-opacity" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    String getSpecifiedTraitImpl(String name) throws DOMException {
        if ("viewport-fill" == name && this.isInherited(0x200000) || "viewport-fill-opacity" == name && this.isInherited(0x400000)) {
            return "inherit";
        }
        return super.getSpecifiedTraitImpl(name);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return Float.toString(this.x);
        }
        if ("y" == name) {
            return Float.toString(this.y);
        }
        if ("width" == name) {
            return Float.toString(this.width);
        }
        if ("height" == name) {
            return Float.toString(this.height);
        }
        if ("transformBehavior" == name) {
            return this.transformBehavior;
        }
        if ("overlay" == name) {
            return this.overlay;
        }
        if ("initialVisibility" == name) {
            return this.initialVisibility;
        }
        if ("focusable" == name) {
            return this.focusable;
        }
        if ("transform" == name) {
            return VideoElement.toStringTrait(this.transform);
        }
        if ("viewport-fill" == name) {
            return this.toString(this.getViewportFill());
        }
        if ("viewport-fill-opacity" == name) {
            return Float.toString(this.getViewportFillOpacity());
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("x" == name) {
            return this.getX();
        }
        if ("y" == name) {
            return this.getY();
        }
        if ("width" == name) {
            return this.getWidth();
        }
        if ("height" == name) {
            return this.getHeight();
        }
        if ("viewport-fill-opacity" == name) {
            return this.getViewportFillOpacity();
        }
        return super.getFloatTraitImpl(name);
    }

    SVGMatrix getMatrixTraitImpl(String name) throws DOMException {
        if ("transform" == name) {
            return this.toSVGMatrixTrait(this.transform);
        }
        return super.getMatrixTraitImpl(name);
    }

    void setMatrixTraitImpl(String name, Transform matrix) throws DOMException {
        if ("transform" == name) {
            this.setTransform(matrix);
        } else {
            super.setMatrixTraitImpl(name, matrix);
        }
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("viewport-fill" == name) {
            return this.toSVGRGBColor("viewport-fill", this.getViewportFill());
        }
        return super.getRGBColorTraitImpl(name);
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("x" == traitName || "y" == traitName || "width" == traitName || "height" == traitName || "viewport-fill-opacity" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("viewport-fill" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        if ("focusable" == traitName) {
            return new StringTraitAnim(this, "#!null/ns@!", traitName);
        }
        if ("transform" == traitName) {
            return new TransformTraitAnim(this, traitName);
        }
        return super.createTraitAnimImpl(traitName);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("x" == name) {
            this.setX(value[0][0]);
        } else if ("y" == name) {
            this.setY(value[0][0]);
        } else if ("width" == name) {
            this.setWidth(value[0][0]);
        } else if ("height" == name) {
            this.setHeight(value[0][0]);
        } else if ("viewport-fill" == name) {
            this.setViewportFill(this.toRGB(name, value));
        } else if ("viewport-fill-opacity" == name) {
            this.setViewportFillOpacity(value[0][0]);
        } else if ("transform" == name) {
            if (this.transform == null) {
                this.modifyingNode();
                this.transform = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else if (!this.transform.equals(value)) {
                this.modifyingNode();
                this.transform.setTransform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            } else {
                return;
            }
            this.recomputeTransformState();
            this.recomputeProxyTransformState();
            this.modifiedNode();
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("x" == traitName || "y" == traitName) {
            return new float[][]{{this.parseFloatTrait(traitName, value)}};
        }
        if ("width" == traitName || "height" == traitName) {
            return new float[][]{{this.parsePositiveFloatTrait(traitName, value)}};
        }
        if ("transform" == traitName) {
            Transform txf = this.parseTransformTrait(traitName, value);
            return new float[][]{{txf.getComponent(0)}, {txf.getComponent(1)}, {txf.getComponent(2)}, {txf.getComponent(3)}, {txf.getComponent(4)}, {txf.getComponent(5)}};
        }
        if ("viewport-fill" == traitName) {
            RGB color = ViewportProperties.INITIAL_VIEWPORT_FILL;
            color = "inherit".equals(value) ? (RGB)this.getInheritedPropertyState(0x200000) : this.parseColorTrait("viewport-fill", value);
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("viewport-fill-opacity" == traitName) {
            float v = 1.0f;
            if ("inherit".equals(value)) {
                if (this.parent != null) {
                    v = this.getInheritedFloatPropertyState(0x400000);
                }
            } else {
                v = this.parseFloatTrait(traitName, value);
                if (v < 0.0f) {
                    v = 0.0f;
                } else if (v > 1.0f) {
                    v = 1.0f;
                }
            }
            return new float[][]{{v}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    String validateTraitNS(String namespaceURI, String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if (namespaceURI != null && namespaceURI != "#!null/ns@!") {
            return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
        }
        if ("x" == traitName || "y" == traitName || "width" == traitName || "height" == traitName || "viewport-fill" == traitName || "viewport-fill-opacity" == traitName) {
            throw this.unsupportedTraitType(traitName, "float");
        }
        if ("focusable" == traitName) {
            if ("true".equals(value) || "false".equals(value) || "auto".equals(value)) {
                return value;
            }
            throw this.illegalTraitValue(traitName, value);
        }
        return super.validateTraitNS(namespaceURI, traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        try {
            if ("x" == name) {
                this.setX(this.parseFloatTrait(name, value));
            } else if ("y" == name) {
                this.setY(this.parseFloatTrait(name, value));
            } else if ("width" == name) {
                this.setWidth(this.parsePositiveFloatTrait(name, value));
            } else if ("height" == name) {
                this.setHeight(this.parsePositiveFloatTrait(name, value));
            } else if ("transform" == name) {
                this.setTransform(this.parseTransformTrait(name, value));
            } else if ("transformBehavior" == name) {
                this.setTransformBehavior(value);
            } else if ("overlay" == name) {
                this.setOverlay(value);
            } else if ("initialVisibility" == name) {
                this.setInitialVisibility(value);
            } else if ("focusable" == name) {
                this.setFocusable(value);
            } else if ("viewport-fill" == name) {
                if ("inherit".equals(value)) {
                    this.setInherited(0x200000, true);
                } else if ("none".equals(value)) {
                    this.setViewportFill(null);
                } else {
                    PaintServer viewportFill = this.parsePaintTrait("viewport-fill", this, value);
                    if (viewportFill != null) {
                        this.setViewportFill(viewportFill);
                    }
                }
            } else if ("viewport-fill-opacity" == name) {
                if ("inherit".equals(value)) {
                    this.setFloatInherited(0x400000, true);
                } else {
                    this.setViewportFillOpacity(this.parseFloatTrait(name, value));
                }
            } else {
                super.setTraitImpl(name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        try {
            if ("x" == name) {
                this.setX(value);
            } else if ("y" == name) {
                this.setY(value);
            } else if ("width" == name) {
                this.setWidth(value);
            } else if ("height" == name) {
                this.setHeight(value);
            } else if ("viewport-fill-opacity" == name) {
                this.setViewportFillOpacity(value);
            } else {
                super.setFloatTraitImpl(name, value);
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.illegalTraitValue(name, Float.toString(value));
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("x" == name || "y" == name || "width" == name || "height" == name || "viewport-fill-opacity" == name) {
            return Float.toString(value[0][0]);
        }
        if ("viewport-fill" == name) {
            if (value == null || value.length == 0) {
                return "none";
            }
            return this.toRGBString(name, value);
        }
        if ("transform" == name) {
            Transform txf = new Transform(value[0][0], value[1][0], value[2][0], value[3][0], value[4][0], value[5][0]);
            return VideoElement.toStringTrait(txf);
        }
        return super.toStringTrait(name, value);
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("viewport-fill" == name) {
                this.setViewportFill((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }

    public SVGRect getBBox() {
        return null;
    }

    public void onPaintServerUpdate(String paintType, PaintServer paintServer) {
        if ("viewport-fill" != paintType) {
            throw new Error();
        }
        this.setViewportFill(paintServer);
    }

    public void paint(RenderGraphics rg) {
        if (this.transform != null) {
            rg.setTransform(this.transform);
        }
        if (this.viewportFill != null) {
            rg.setFill(this.viewportFill);
            rg.setFillOpacity(this.viewportFillOpacity);
            rg.fillRect(this.x, this.y, this.width, this.height, 0.0f, 0.0f);
        }
        if (this.image == null) {
            return;
        }
        int iw = this.image.getWidth();
        if (iw == 0) {
            return;
        }
        int ih = this.image.getHeight();
        if (ih == 0) {
            return;
        }
        rg.drawImage(this.image, this.x, this.y, iw, ih);
    }

    protected boolean hasNodeRendering() {
        return true;
    }

    void updateFrame() {
        RasterImage img = this.videoPlayer.getFrame();
        this.modifyingNode();
        this.image = img;
        this.modifiedNode();
    }
}

