/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.classpath;

import java.lang.ref.SoftReference;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.classpath.ProjectClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class J2MEClassPathProvider
implements ClassPathProvider {
    private SoftReference<ClassPath> ctcp;
    private SoftReference<ClassPath> rtcp;
    private SoftReference<ClassPath> sp;
    private SoftReference<ClassPath> bcp;
    private FileObject srcDir;
    protected final AntProjectHelper helper;
    private final RequestProcessor requestProcessor;

    public J2MEClassPathProvider(AntProjectHelper antProjectHelper, RequestProcessor requestProcessor) {
        this.helper = antProjectHelper;
        this.requestProcessor = requestProcessor;
    }

    public ClassPath findClassPath(FileObject fileObject, String string) {
        if (string.equals("classpath/boot")) {
            return this.getBootClassPath();
        }
        if (!this.checkSrcParent(fileObject)) {
            return null;
        }
        if (string.equals("classpath/compile")) {
            return this.getCompileTimeClasspath();
        }
        if (string.equals("classpath/execute")) {
            return this.getRunTimeClasspath();
        }
        if (string.equals("classpath/source")) {
            return this.getSourcepath();
        }
        return null;
    }

    public boolean checkSrcParent(FileObject fileObject) {
        String string;
        if (!(this.srcDir != null && this.srcDir.isValid() || (string = this.helper.getStandardPropertyEvaluator().getProperty("src.dir")) == null)) {
            this.srcDir = this.helper.resolveFileObject(string);
        }
        return this.srcDir != null && fileObject != null && (this.srcDir.equals(fileObject) || FileUtil.isParentOf((FileObject)this.srcDir, (FileObject)fileObject));
    }

    public ClassPath getCompileTimeClasspath() {
        ClassPath classPath = null;
        if (this.ctcp == null || (classPath = this.ctcp.get()) == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, this.requestProcessor){

                protected String evaluatePath() {
                    String string = J2MEProjectUtils.evaluateProperty(J2MEClassPathProvider.this.helper, "libs.classpath");
                    if (string != null) {
                        string = J2MEClassPathProvider.this.helper.resolvePath(string);
                    }
                    return string;
                }
            });
            this.ctcp = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    public ClassPath getRunTimeClasspath() {
        ClassPath classPath = null;
        if (this.rtcp == null || (classPath = this.rtcp.get()) == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, this.requestProcessor){

                protected String evaluatePath() {
                    String string = J2MEClassPathProvider.this.helper.getStandardPropertyEvaluator().getProperty("build.classes.dir");
                    if (string != null) {
                        string = J2MEClassPathProvider.this.helper.resolvePath(string);
                    }
                    return string;
                }
            });
            this.rtcp = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    public ClassPath getSourcepath() {
        ClassPath classPath = null;
        if (this.sp == null || (classPath = this.sp.get()) == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectClassPathImplementation(this.helper, this.requestProcessor){

                protected String evaluatePath() {
                    String string = J2MEClassPathProvider.this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
                    if (string != null) {
                        string = J2MEClassPathProvider.this.helper.resolvePath(string);
                    }
                    return string;
                }
            });
            this.sp = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    public ClassPath getBootClassPath() {
        ClassPath classPath = null;
        if (this.bcp == null || (classPath = this.bcp.get()) == null) {
            classPath = ClassPathFactory.createClassPath((ClassPathImplementation)new ProjectBootClassPathImplementation());
            this.bcp = new SoftReference<ClassPath>(classPath);
        }
        return classPath;
    }

    private class ProjectBootClassPathImplementation
    extends ProjectClassPathImplementation
    implements ChangeListener {
        public ProjectBootClassPathImplementation() {
            super(J2MEClassPathProvider.this.helper, J2MEClassPathProvider.this.requestProcessor);
            PropertyProvider propertyProvider = PropertyUtils.globalPropertyProvider();
            propertyProvider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)propertyProvider));
        }

        protected String evaluatePath() {
            int n;
            String string = J2MEProjectUtils.evaluateProperty(J2MEClassPathProvider.this.helper, "platform.active");
            if (string == null) {
                return null;
            }
            string = J2MEClassPathProvider.this.helper.getStandardPropertyEvaluator().getProperty("platforms." + string + ".home");
            String string2 = J2MEProjectUtils.evaluateProperty(J2MEClassPathProvider.this.helper, "platform.bootclasspath");
            if (string == null || string2 == null) {
                return null;
            }
            while ((n = string2.indexOf("${platform.home}")) >= 0) {
                string2 = string2.substring(0, n) + string + string2.substring(n + 16);
            }
            return string2 == null ? null : J2MEClassPathProvider.this.helper.resolvePath(string2);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.propertiesChanged(null);
        }
    }
}

