/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.classpath;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.netbeans.spi.java.project.classpath.ProjectClassPathExtender;
import org.netbeans.spi.mobility.project.support.DefaultPropertyParsers;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;

public class J2MEProjectClassPathExtender
implements ProjectClassPathExtender {
    private static final Map<String, String> CONDITIONS = new HashMap<String, String>();
    protected Project project;
    protected AntProjectHelper helper;
    protected ReferenceHelper refHelper;
    protected ProjectConfigurationsHelper confHelper;

    public J2MEProjectClassPathExtender(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ProjectConfigurationsHelper projectConfigurationsHelper) {
        this.project = project;
        this.helper = antProjectHelper;
        this.refHelper = referenceHelper;
        this.confHelper = projectConfigurationsHelper;
    }

    public boolean addLibrary(Library library) throws IOException {
        if (library == null) {
            return false;
        }
        boolean bl = false;
        if ("swing-layout".equals(library.getName())) {
            bl = this.addLibrary(LibraryManager.getDefault().getLibrary("cdc-agui-swing-layout")) | this.addLibrary(LibraryManager.getDefault().getLibrary("cdc-pp-awt-layout"));
        }
        return this.addCPItemToAllCfg(VisualClassPathItem.create(library), CONDITIONS.get(library.getName())) | bl;
    }

    public boolean addArchiveFile(FileObject fileObject) throws IOException {
        assert (fileObject != null) : "Parameter cannot be null";
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            throw new IllegalArgumentException("The file must exist on disk");
        }
        return this.addCPItemToAllCfg(VisualClassPathItem.create(file), null);
    }

    public boolean addAntArtifact(AntArtifact antArtifact, URI uRI) throws IOException {
        assert (antArtifact != null) : "Parameter cannot be null";
        return this.addCPItemToAllCfg(VisualClassPathItem.create(antArtifact, uRI), null);
    }

    private boolean addCPItemToAllCfg(final VisualClassPathItem visualClassPathItem, final String string) throws IOException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws Exception {
                    Object object;
                    EditableProperties editableProperties = J2MEProjectClassPathExtender.this.helper.getProperties("nbproject/project.properties");
                    boolean bl = false;
                    boolean bl2 = J2MEProjectClassPathExtender.this.checkCondition(editableProperties, null, string);
                    String string6 = editableProperties.getProperty("libs.classpath");
                    if (bl2 && !(object = (List)DefaultPropertyParsers.PATH_PARSER.decode(string6, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper)).contains(visualClassPathItem)) {
                        object.add(visualClassPathItem);
                        String string2 = DefaultPropertyParsers.PATH_PARSER.encode(object, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper);
                        editableProperties.setProperty("libs.classpath", string2);
                        bl = true;
                    }
                    for (ProjectConfiguration projectConfiguration : J2MEProjectClassPathExtender.this.confHelper.getConfigurations().toArray(new ProjectConfiguration[0])) {
                        List list;
                        if (J2MEProjectClassPathExtender.this.confHelper.getDefaultConfiguration().equals(projectConfiguration)) continue;
                        String string3 = VisualPropertySupport.prefixPropertyName(projectConfiguration.getDisplayName(), "libs.classpath");
                        boolean bl3 = J2MEProjectClassPathExtender.this.checkCondition(editableProperties, projectConfiguration, string);
                        String string4 = editableProperties.getProperty(string3);
                        if (string4 == null && bl3 != bl2) {
                            string4 = string6;
                            editableProperties.put(string3, string4);
                        }
                        if (!bl3 || string4 == null || (list = (List)DefaultPropertyParsers.PATH_PARSER.decode(string4, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper)).contains(visualClassPathItem)) continue;
                        list.add(visualClassPathItem);
                        String string5 = DefaultPropertyParsers.PATH_PARSER.encode(list, J2MEProjectClassPathExtender.this.helper, J2MEProjectClassPathExtender.this.refHelper);
                        editableProperties.setProperty(string3, string5);
                        bl = true;
                    }
                    if (bl) {
                        J2MEProjectClassPathExtender.this.helper.putProperties("nbproject/project.properties", editableProperties);
                        ProjectManager.getDefault().saveProject(J2MEProjectClassPathExtender.this.project);
                    }
                    return bl;
                }
            });
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)iOException, (Throwable)exception);
        }
    }

    protected boolean checkCondition(EditableProperties editableProperties, ProjectConfiguration projectConfiguration, String string) {
        if (string == null) {
            return true;
        }
        String string2 = editableProperties.getProperty(projectConfiguration == null ? "platform.active" : VisualPropertySupport.prefixPropertyName(projectConfiguration.getDisplayName(), "platform.active"));
        if (string2 == null) {
            string2 = editableProperties.getProperty("platform.active");
        }
        if (string2 == null) {
            return false;
        }
        for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
            String string3 = (String)javaPlatform.getProperties().get("platform.ant.name");
            if (string3 == null || !string3.equals(string2)) continue;
            ClassPath classPath = javaPlatform.getBootstrapLibraries();
            boolean bl = true;
            for (String string4 : string.split(",")) {
                if (string4.startsWith("-")) {
                    bl &= javaPlatform.getBootstrapLibraries().findResource(string4.substring(1)) == null;
                    continue;
                }
                bl &= javaPlatform.getBootstrapLibraries().findResource(string4) != null;
            }
            return bl;
        }
        return true;
    }

    static {
        CONDITIONS.put("swing-layout", "javax/swing/AbstractCellEditor.class");
        CONDITIONS.put("cdc-agui-swing-layout", "javax/swing/JComponent.class,-javax/swing/AbstractCellEditor.class");
        CONDITIONS.put("cdc-pp-awt-layout", "java/awt/Component.class,-javax/swing/JComponent.class");
        CONDITIONS.put("NetBeans MIDP Components", "javax/microedition/lcdui/Screen.class");
        CONDITIONS.put("nb_svg_midp_components", "javax/microedition/m2g/SVGImage.class");
        CONDITIONS.put("J2MEUnit", "javax/microedition/midlet/MIDlet.class");
        CONDITIONS.put("JMUnit4CLDC10", "javax/microedition/midlet/MIDlet.class");
        CONDITIONS.put("JMUnit4CLDC11", "javax/microedition/midlet/MIDlet.class,java/lang/Double.class");
    }
}

