/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public class MEKeyTool {
    public static String getMEKeyToolPath(J2MEPlatform j2MEPlatform) {
        if (j2MEPlatform == null) {
            return null;
        }
        FileObject fileObject = j2MEPlatform.findTool("mekeytool");
        if (fileObject == null) {
            return null;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static KeyDetail[] listKeys(J2MEPlatform j2MEPlatform) {
        String string = MEKeyTool.getMEKeyToolPath(j2MEPlatform);
        if (string == null) {
            return null;
        }
        try {
            String string2;
            BufferedReader bufferedReader = MEKeyTool.execute(new String[]{string, "-list"});
            ArrayList<KeyDetail> arrayList = new ArrayList<KeyDetail>();
            KeyDetail keyDetail = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ("".equals(string2)) continue;
                if (string2.startsWith("Key ")) {
                    if (keyDetail != null) {
                        arrayList.add(keyDetail);
                    }
                    try {
                        keyDetail = new KeyDetail(Integer.parseInt(string2.substring("Key ".length())));
                    }
                    catch (NumberFormatException numberFormatException) {
                        keyDetail = null;
                    }
                    continue;
                }
                if (keyDetail == null) continue;
                keyDetail.addLine(string2);
            }
            if (keyDetail != null) {
                arrayList.add(keyDetail);
            }
            return arrayList.toArray(new KeyDetail[arrayList.size()]);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedReader execute(String[] stringArray) throws IOException {
        File file = null;
        if (stringArray != null && stringArray.length > 0) {
            File file2 = new File(stringArray[0]);
            file = file2.exists() ? file2.getParentFile() : null;
        }
        int n = Utilities.getOperatingSystem();
        Thread thread = null;
        int n2 = 0;
        Process process = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            if (n == 4) {
                thread = Thread.currentThread();
                n2 = thread.getPriority();
                thread.setPriority(5);
            }
            process = file != null ? Runtime.getRuntime().exec(stringArray, null, file) : Runtime.getRuntime().exec(stringArray);
            inputStream = process.getInputStream();
            inputStream2 = process.getErrorStream();
        }
        finally {
            if (n == 4) {
                thread.setPriority(n2);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(1024);
        StringBuffer stringBuffer2 = new StringBuffer(1024);
        StreamCatcher streamCatcher = new StreamCatcher(inputStream, stringBuffer);
        StreamCatcher streamCatcher2 = new StreamCatcher(inputStream2, stringBuffer2);
        streamCatcher.start();
        streamCatcher2.start();
        try {
            process.waitFor();
            streamCatcher.join(10000L);
            streamCatcher2.join(10000L);
        }
        catch (InterruptedException interruptedException) {
            throw (IOException)ErrorManager.getDefault().annotate((Throwable)new IOException(), (Throwable)interruptedException);
        }
        finally {
            process.destroy();
        }
        if (process.exitValue() != 0) {
            throw new IOException("exec, exitCode != 0");
        }
        return new BufferedReader(new StringReader(stringBuffer.toString()));
    }

    private static class StreamCatcher
    extends Thread {
        InputStream is;
        StringBuffer sb;

        StreamCatcher(InputStream inputStream, StringBuffer stringBuffer) {
            this.is = inputStream;
            this.sb = stringBuffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                try {
                    int n;
                    char[] cArray = new char[256];
                    while ((n = inputStreamReader.read(cArray)) >= 0) {
                        this.sb.append(cArray, 0, n);
                    }
                }
                finally {
                    inputStreamReader.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public static class KeyDetail {
        private final int order;
        private final ArrayList<String> info;

        public KeyDetail(int n) {
            this.order = n;
            this.info = new ArrayList();
        }

        public void addLine(String string) {
            this.info.add(string);
        }

        public int getOrder() {
            return this.order;
        }

        public String[] getInfo() {
            return this.info.toArray(new String[this.info.size()]);
        }

        public String getOwner() {
            for (String string : this.info) {
                if (string == null || !(string = string.trim()).startsWith("Owner:")) continue;
                return string.substring("Owner:".length()).trim();
            }
            return null;
        }
    }
}

