/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.ui.customizer.J2MECustomizer;
import org.netbeans.modules.mobility.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class J2MECustomizerProvider
implements CustomizerProvider {
    private final Project project;
    private final AntProjectHelper antProjectHelper;
    private final ReferenceHelper refHelper;
    private final ProjectConfigurationsHelper configHelper;
    Dialog dialog = null;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final String COMMAND_OK = "OK";
    private static final String COMMAND_CANCEL = "CANCEL";
    private DialogDescriptor dialogDescriptor;

    public J2MECustomizerProvider(Project project, AntProjectHelper antProjectHelper, ReferenceHelper referenceHelper, ProjectConfigurationsHelper projectConfigurationsHelper) {
        this.project = project;
        this.antProjectHelper = antProjectHelper;
        this.refHelper = referenceHelper;
        this.configHelper = projectConfigurationsHelper;
    }

    public void showCustomizer() {
        this.showCustomizer(false);
    }

    public void showCustomizer(boolean bl) {
        Object[] objectArray = new JButton[]{new JButton(NbBundle.getMessage(J2MECustomizerProvider.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(J2MECustomizerProvider.class, (String)"LBL_Customizer_Cancel_Option"))};
        objectArray[0].setActionCommand(COMMAND_OK);
        objectArray[1].setActionCommand(COMMAND_CANCEL);
        J2MEProjectProperties j2MEProjectProperties = new J2MEProjectProperties(this.project, this.antProjectHelper, this.refHelper, this.configHelper);
        OptionListener optionListener = new OptionListener(this, this.project, j2MEProjectProperties);
        objectArray[0].addActionListener(optionListener);
        objectArray[1].addActionListener(optionListener);
        J2MECustomizer j2MECustomizer = bl ? new J2MECustomizer(j2MEProjectProperties, "AddConfigDialog") : new J2MECustomizer(j2MEProjectProperties);
        this.dialogDescriptor = new DialogDescriptor((Object)j2MECustomizer, ProjectUtils.getInformation((Project)this.project).getDisplayName(), true, objectArray, (Object)objectArray[0], 0, new HelpCtx(J2MECustomizerProvider.class), null);
        this.dialogDescriptor.setClosingOptions(new Object[]{objectArray[1]});
        j2MECustomizer.setDialogDescriptor(this.dialogDescriptor);
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.dialog.setVisible(true);
    }

    Dialog getDialog() {
        return this.dialog;
    }

    private static class OptionListener
    implements ActionListener {
        private final Project project;
        private final J2MEProjectProperties j2meProperties;
        private final J2MECustomizerProvider provider;

        OptionListener(J2MECustomizerProvider j2MECustomizerProvider, Project project, J2MEProjectProperties j2MEProjectProperties) {
            this.project = project;
            this.j2meProperties = j2MEProjectProperties;
            this.provider = j2MECustomizerProvider;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (J2MECustomizerProvider.COMMAND_OK.equals(string)) {
                this.j2meProperties.store();
                if (this.provider.getDialog() != null) {
                    this.provider.getDialog().dispose();
                }
            }
        }
    }
}

