/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.mobility.project.J2MEProjectUtils;
import org.netbeans.modules.mobility.project.ui.customizer.ErrorPanel;
import org.netbeans.modules.mobility.project.ui.customizer.NewConfigurationPanel;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneConfigurationPanel
extends JPanel
implements DocumentListener {
    private DialogDescriptor dialogDescriptor;
    private final Collection<String> allNames;
    private ErrorPanel errorPanel;
    private JLabel jLabel1;
    private JTextField jTextFieldName;

    public CloneConfigurationPanel(Collection<String> collection) {
        this.allNames = collection;
        this.initComponents();
        this.initAccessibility();
    }

    @Override
    public String getName() {
        return this.jTextFieldName == null ? null : this.jTextFieldName.getText();
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        assert (this.dialogDescriptor == null) : "Set the dialog descriptor only once!";
        this.dialogDescriptor = dialogDescriptor;
        dialogDescriptor.setHelpCtx(new HelpCtx(NewConfigurationPanel.class));
        this.jTextFieldName.getDocument().addDocumentListener(this);
        this.changedUpdate(null);
    }

    public boolean isStateValid() {
        String string = this.jTextFieldName.getText();
        if (J2MEProjectUtils.ILEGAL_CONFIGURATION_NAMES.contains(string)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_ReservedWord");
            return false;
        }
        if (!Utilities.isJavaIdentifier((String)string)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_MustBeJavaIdentifier");
            return false;
        }
        if (this.allNames.contains(string)) {
            this.errorPanel.setErrorBundleMessage("ERR_AddCfg_NameExists");
            return false;
        }
        this.errorPanel.setErrorBundleMessage(null);
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(this.isStateValid());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.errorPanel = new ErrorPanel();
        this.setPreferredSize(new Dimension(400, 100));
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.jTextFieldName);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(CloneConfigurationPanel.class, (String)"LBL_NewConfigPanel_ConfigurationName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 5, 0, 12);
        this.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jTextFieldName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CloneConfigurationPanel.class, (String)"ACSD_CloneCfg_CfgName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.errorPanel, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSN_CloneConfigPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewConfigurationPanel.class, (String)"ACSD_CloneConfigPanel"));
    }
}

