/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.modules.mobility.project.ui.customizer.AddAttributePanel;
import org.netbeans.spi.mobility.project.ui.customizer.CustomizerPanel;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.netbeans.spi.mobility.project.ui.customizer.support.VisualPropertySupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerJad
extends JPanel
implements CustomizerPanel,
VisualPropertyGroup,
ListSelectionListener,
ActionListener {
    static final String[] PROPERTY_GROUP = new String[]{"manifest.others", "manifest.jad", "manifest.manifest", "deployment.override.jarurl", "deployment.jarurl"};
    protected final JTable table;
    protected final StorableTableModel tableModel;
    private VisualPropertySupport vps;
    private String configuration;
    private String configurationProfileValue;
    private String defaultProfileValue;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bRemove;
    private JCheckBox cDefault;
    private JCheckBox jCheckBoxOverride;
    private JLabel jLabelExpl;
    private JTextField jTextFieldURL;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public CustomizerJad() {
        this.initComponents();
        this.initAccessibility();
        this.tableModel = new StorableTableModel();
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    CustomizerJad.this.bEditActionPerformed(null);
                }
            }
        });
        this.jCheckBoxOverride.addActionListener(this);
    }

    private void initComponents() {
        this.cDefault = new JCheckBox();
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bEdit = new JButton();
        this.bRemove = new JButton();
        this.jCheckBoxOverride = new JCheckBox();
        this.jTextFieldURL = new JTextField();
        this.jLabelExpl = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.cDefault, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Use_Default"));
        this.cDefault.setMargin(new Insets(0, 0, 0, 2));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.cDefault, gridBagConstraints);
        this.lTable.setLabelFor(this.lTable);
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Table"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 4);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Add"));
        this.bAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerJad.this.bAddActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 12, 11, 0);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Edit"));
        this.bEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerJad.this.bEditActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 12, 11, 0);
        this.add((Component)this.bEdit, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Remove"));
        this.bRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerJad.this.bRemoveActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jCheckBoxOverride, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustDeploy_OverrideURL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jCheckBoxOverride, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        this.add((Component)this.jTextFieldURL, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelExpl, (String)NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustDeploy_URLExpl"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.add((Component)this.jLabelExpl, gridBagConstraints);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CustomizerJad.class, (String)"ACSN_Jad"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerJad.class, (String)"ACSD_Jad"));
    }

    private void bAddActionPerformed(ActionEvent actionEvent) {
        final AddAttributePanel addAttributePanel = new AddAttributePanel();
        addAttributePanel.init(false, this.tableModel, this.tableModel.getKeys(), null, null);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addAttributePanel, NbBundle.getMessage(CustomizerJad.class, (String)"TITLE_AddAttribute"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    int n = CustomizerJad.this.tableModel.addRow(addAttributePanel.getKey(), addAttributePanel.getValue(), addAttributePanel.getPlacement());
                    CustomizerJad.this.table.getSelectionModel().setSelectionInterval(n, n);
                }
            }
        });
        addAttributePanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bEditActionPerformed(ActionEvent actionEvent) {
        final int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        final String string = (String)this.tableModel.getValueAt(n, 1);
        String string2 = (String)this.tableModel.getValueAt(n, 2);
        final AddAttributePanel addAttributePanel = new AddAttributePanel();
        addAttributePanel.init(true, this.tableModel, this.tableModel.getKeys(), string, string2);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addAttributePanel, NbBundle.getMessage(CustomizerJad.class, (String)"TITLE_EditAttribute"), true, 2, NotifyDescriptor.OK_OPTION, 0, new HelpCtx(AddAttributePanel.class), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (NotifyDescriptor.OK_OPTION.equals(actionEvent.getSource())) {
                    if (string == null || !string.equals(addAttributePanel.getKey())) {
                        if (string != null) {
                            CustomizerJad.this.tableModel.removeKey(string);
                        }
                        int n2 = CustomizerJad.this.tableModel.addRow(addAttributePanel.getKey(), addAttributePanel.getValue(), addAttributePanel.getPlacement());
                        CustomizerJad.this.table.getSelectionModel().setSelectionInterval(n2, n2);
                    } else {
                        CustomizerJad.this.tableModel.editRow(addAttributePanel.getKey(), addAttributePanel.getValue(), addAttributePanel.getPlacement());
                        CustomizerJad.this.table.getSelectionModel().setSelectionInterval(n, n);
                    }
                }
            }
        });
        addAttributePanel.setDialogDescriptor(dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    private void bRemoveActionPerformed(ActionEvent actionEvent) {
        int n = this.table.getSelectedRow();
        if (n < 0) {
            return;
        }
        this.tableModel.removeRow(n);
        int n2 = this.tableModel.getRowCount();
        if (n2 <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (n < n2) {
            this.table.getSelectionModel().setSelectionInterval(n, n);
        } else {
            this.table.getSelectionModel().setSelectionInterval(n2 - 1, n2 - 1);
        }
    }

    public void initValues(ProjectProperties projectProperties, String string) {
        this.configuration = string;
        this.configurationProfileValue = (String)projectProperties.get(VisualPropertySupport.translatePropertyName(string, "platform.profile", false));
        this.defaultProfileValue = (String)projectProperties.get("platform.profile");
        this.vps = VisualPropertySupport.getDefault(projectProperties);
        this.vps.register(this.cDefault, string, this);
    }

    public String[] getGroupPropertyNames() {
        return PROPERTY_GROUP;
    }

    public void initGroupValues(boolean bl) {
        String string = null;
        if (this.configuration != null) {
            string = this.configurationProfileValue;
        }
        if (string == null) {
            string = this.defaultProfileValue;
        }
        this.tableModel.setMIDP(string);
        this.vps.register(this.tableModel, new String[]{"manifest.others", "manifest.jad", "manifest.manifest"}, bl);
        this.vps.register(this.jTextFieldURL, "deployment.jarurl", bl);
        this.vps.register(this.jCheckBoxOverride, "deployment.override.jarurl", bl);
        this.bAdd.setEnabled(!bl);
        this.bEdit.setEnabled(!bl);
        this.bRemove.setEnabled(!bl);
        this.table.setEnabled(!bl);
        this.lTable.setEnabled(!bl);
        this.jLabelExpl.setEnabled(!bl);
        this.table.setBackground(UIManager.getDefaults().getColor(bl ? "Panel.background" : "Table.background"));
        this.valueChanged(null);
        this.actionPerformed(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.jTextFieldURL.setEditable(this.jCheckBoxOverride.isEnabled() && this.jCheckBoxOverride.isSelected());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.table.getSelectedRow();
        boolean bl = this.table.isEnabled() && n >= 0;
        this.bEdit.setEnabled(bl);
        this.bRemove.setEnabled(bl && !this.tableModel.containsInMandatory((String)this.tableModel.getValueAt(n, 1)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StorableTableModel
    extends AbstractTableModel
    implements VisualPropertySupport.StorableTableModel {
        private HashMap<String, String> map1 = new HashMap();
        private HashMap<String, String> map2 = new HashMap();
        private HashMap<String, String> map3 = new HashMap();
        private final ArrayList<String> items = new ArrayList();
        private boolean isMIDP20 = false;
        private String[] additionalAttributes = null;
        private static final String NAME = "MIDlet-Name";
        private static final String VENDOR = "MIDlet-Vendor";
        private static final String VERSION = "MIDlet-Version";
        private static final String ICON = "MIDlet-Icon";
        private static final String DESCRIPTION = "MIDlet-Description";
        private static final String INFOURL = "MIDlet-Info-URL";
        private static final String DATASIZE = "MIDlet-Data-Size";
        private static final String MECONFIG = "MicroEdition-Configuration";
        private static final String MEPROFILE = "MicroEdition-Profile";
        private static final String INSTALL = "MIDlet-Install-Notify";
        private static final String DELETE = "MIDlet-Delete-Notify";
        private static final String CONFIRM = "MIDlet-Delete-Confirm";
        private static final String[][] mandatoryProperties = new String[][]{{"MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"}, {"MIDlet-Name", "MIDlet-Vendor", "MIDlet-Version"}};
        private static final String[][] nonmandatoryProperties = new String[][]{{"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"}, {"MIDlet-Icon", "MIDlet-Description", "MIDlet-Info-URL", "MIDlet-Data-Size", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MicroEdition-Configuration", "MicroEdition-Profile"}};
        private static final String[] riskyProperties = new String[]{"MicroEdition-Configuration", "MicroEdition-Profile"};
        private static final long serialVersionUID = -2195421895353167160L;

        public void setMIDP(String string) {
            this.isMIDP20 = string != null && !"MIDP-1.0".equals(string);
        }

        public boolean isMIDP2() {
            return this.isMIDP20;
        }

        public HashSet<String> getKeys() {
            return new HashSet<String>(this.items);
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Column_Type");
                }
                case 1: {
                    return NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Column_Key");
                }
                case 2: {
                    return NbBundle.getMessage(CustomizerJad.class, (String)"LBL_Jad_Column_Value");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return null;
        }

        @Override
        public synchronized Object[] getDataDelegates() {
            this.updateMapsFromItems();
            return new Object[]{this.map1, this.map2, this.map3};
        }

        @Override
        public Object getValueAt(int n, int n2) {
            assert (n < this.items.size());
            switch (n2) {
                case 0: {
                    String string;
                    String string2 = this.items.get(n);
                    if (this.containsInMandatory(string2)) {
                        string = NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomJad_Required");
                    } else if (this.containsInRisky(string2)) {
                        string = NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomJad_Risky");
                    } else if (this.containsInNonMandatory(string2)) {
                        string = NbBundle.getMessage(CustomizerJad.class, (String)"LBL_CustomJad_Optional");
                    } else {
                        Boolean bl = this.getPlacement(string2);
                        string = NbBundle.getMessage(CustomizerJad.class, (String)("LBL_CustomJad_Custom" + (bl == null ? "" : (bl != false ? "_J" : "_M"))));
                    }
                    return string;
                }
                case 1: {
                    return this.items.get(n);
                }
                case 2: {
                    String string = this.map1.get(this.items.get(n));
                    if (string == null) {
                        string = this.map2.get(this.items.get(n));
                    }
                    if (string == null) {
                        string = this.map3.get(this.items.get(n));
                    }
                    if (string == null) {
                        string = "";
                    }
                    return string;
                }
            }
            return null;
        }

        @Override
        public synchronized void setDataDelegates(Object[] objectArray) {
            assert (objectArray != null);
            this.map1 = objectArray[0] == null ? new HashMap() : (HashMap)objectArray[0];
            this.map2 = objectArray[1] == null ? new HashMap() : (HashMap)objectArray[1];
            this.map3 = objectArray[2] == null ? new HashMap() : (HashMap)objectArray[2];
            this.updateItemsFromMaps();
            this.fireTableDataChanged();
        }

        public synchronized void updateItemsFromMaps() {
            this.items.clear();
            ArrayList<String> arrayList = new ArrayList<String>(this.map1.keySet());
            arrayList.addAll(this.map2.keySet());
            arrayList.addAll(this.map3.keySet());
            for (int i = 0; i < this.getMandatory().length; ++i) {
                this.items.add(this.getMandatory()[i]);
                arrayList.remove(this.getMandatory()[i]);
            }
            Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this.items.add((String)objectArray[i]);
            }
        }

        public synchronized void updateMapsFromItems() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            HashMap<String, String> hashMap3 = new HashMap<String, String>();
            for (int i = 0; i < this.items.size(); ++i) {
                String string = this.items.get(i);
                String string2 = this.map3.get(string);
                if (string2 != null) {
                    hashMap3.put(string, string2);
                    continue;
                }
                string2 = this.map2.get(string);
                if (string2 != null) {
                    hashMap2.put(string, string2);
                    continue;
                }
                string2 = this.map1.get(string);
                hashMap.put(string, string2 == null ? "" : string2);
            }
            this.map1 = hashMap;
            this.map2 = hashMap2;
            this.map3 = hashMap3;
        }

        private static boolean contains(String[] stringArray, String string) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(string)) continue;
                return true;
            }
            return false;
        }

        public String[] getMandatory() {
            return mandatoryProperties[this.isMIDP20 ? 1 : 0];
        }

        public String[] getNonMandatory() {
            if (this.additionalAttributes == null) {
                this.additionalAttributes = this.loadAdditionalAttributes();
            }
            return this.mergeAttributes(nonmandatoryProperties[this.isMIDP20 ? 1 : 0], this.additionalAttributes);
        }

        public String[] getAllAttrs() {
            return this.mergeAttributes(this.getMandatory(), this.getNonMandatory());
        }

        public boolean containsInMandatory(String string) {
            return StorableTableModel.contains(this.getMandatory(), string);
        }

        public boolean containsInRisky(String string) {
            return StorableTableModel.contains(riskyProperties, string);
        }

        public boolean containsInNonMandatory(String string) {
            return StorableTableModel.contains(this.getNonMandatory(), string);
        }

        public boolean containsInAllAttrs(String string) {
            return StorableTableModel.contains(this.getAllAttrs(), string);
        }

        public boolean isAcceptable(String string) {
            if (string == null) {
                return false;
            }
            if (!string.startsWith("MIDlet-")) {
                return true;
            }
            return this.containsInAllAttrs(string);
        }

        public int addRow(String string, String string2, Boolean bl) {
            if (string == null || this.items.contains(string)) {
                return -1;
            }
            int n = this.items.size();
            this.map1.remove(string);
            this.map2.remove(string);
            this.map3.remove(string);
            if (bl == null) {
                this.map1.put(string, string2);
            } else if (bl.booleanValue()) {
                this.map2.put(string, string2);
            } else {
                this.map3.put(string, string2);
            }
            this.items.add(string);
            this.fireTableRowsInserted(n, n);
            return n;
        }

        public void editRow(String string, String string2, Boolean bl) {
            int n = this.items.indexOf(string);
            if (n < 0) {
                return;
            }
            this.map1.remove(string);
            this.map2.remove(string);
            this.map3.remove(string);
            if (bl == null) {
                this.map1.put(string, string2);
            } else if (bl.booleanValue()) {
                this.map2.put(string, string2);
            } else {
                this.map3.put(string, string2);
            }
            this.fireTableRowsUpdated(n, n);
        }

        public Boolean getPlacement(String string) {
            if (this.map2.containsKey(string)) {
                return Boolean.TRUE;
            }
            if (this.map3.containsKey(string)) {
                return Boolean.FALSE;
            }
            return null;
        }

        public void removeRow(int n) {
            assert (n < this.items.size());
            if (this.containsInMandatory(this.items.get(n))) {
                return;
            }
            this.items.remove(n);
            this.fireTableRowsDeleted(n, this.items.size() + 1);
        }

        public void removeKey(String string) {
            int n = this.items.indexOf(string);
            if (n < 0) {
                return;
            }
            this.removeRow(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String[] loadAdditionalAttributes() {
            ArrayList<String> arrayList = new ArrayList<String>();
            FileObject fileObject = FileUtil.getConfigFile((String)"Buildsystem/ApplicationDescriptor/Attributes");
            if (fileObject == null) {
                return new String[0];
            }
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (FileObject fileObject2 : Arrays.asList(fileObjectArray)) {
                InputStream inputStream = null;
                try {
                    inputStream = fileObject2.getInputStream();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            if (arrayList.contains(string = string.trim()) || string.length() == 0) continue;
                            arrayList.add(string);
                        }
                    }
                    finally {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }

        private String[] mergeAttributes(String[] stringArray, String[] stringArray2) {
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }
    }
}

