/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class SmallSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    MouseListener mainSwatchListener;

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public int getMnemonic() {
        return 0;
    }

    public int getDisplayedMnemonicIndex() {
        return 0;
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    protected void buildChooser() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        jPanel2.setBorder(compoundBorder);
        jPanel2.add((Component)this.swatchPanel, "Center");
        jPanel.add((Component)jPanel2, "Center");
        this.add(jPanel);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.swatchPanel = null;
        this.mainSwatchListener = null;
        this.removeAll();
    }

    public void updateChooser() {
    }

    class MainSwatchPanel
    extends SwatchPanel {
        static final int width = 5;
        static final int height = 3;

        MainSwatchPanel() {
        }

        protected void initValues() {
            this.swatchSize = UIManager.getDimension("ColorChooser.swatchesSwatchSize");
            this.numSwatches = new Dimension(5, 3);
            this.gap = new Dimension(1, 1);
        }

        protected void initColors() {
            int[] nArray = this.initRawValues();
            int n = nArray.length / 3;
            this.colors = new Color[n];
            for (int i = 0; i < n; ++i) {
                this.colors[i] = new Color(nArray[i * 3], nArray[i * 3 + 1], nArray[i * 3 + 2]);
            }
        }

        private int[] initRawValues() {
            int[] nArray = new int[]{255, 255, 255, 204, 255, 255, 204, 204, 255, 255, 204, 204, 204, 255, 204, 204, 204, 204, 153, 153, 255, 255, 153, 153, 255, 153, 153, 153, 255, 153, 102, 102, 255, 255, 102, 204, 255, 255, 102, 102, 255, 102, 102, 255, 204};
            return nArray;
        }
    }

    class SwatchPanel
    extends JPanel {
        protected Color[] colors;
        protected Dimension swatchSize;
        protected Dimension numSwatches;
        protected Dimension gap;

        public SwatchPanel() {
            this.initValues();
            this.initColors();
            this.setToolTipText("");
            this.setOpaque(true);
            this.setBackground(Color.white);
            this.setRequestFocusEnabled(false);
        }

        public boolean isFocusable() {
            return false;
        }

        protected void initValues() {
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            for (int i = 0; i < this.numSwatches.height; ++i) {
                for (int j = 0; j < this.numSwatches.width; ++j) {
                    graphics.setColor(this.getColorForCell(j, i));
                    int n = j * (this.swatchSize.width + this.gap.width);
                    int n2 = i * (this.swatchSize.height + this.gap.height);
                    graphics.fillRect(n, n2, this.swatchSize.width, this.swatchSize.height);
                    graphics.setColor(Color.black);
                    graphics.drawLine(n + this.swatchSize.width - 1, n2, n + this.swatchSize.width - 1, n2 + this.swatchSize.height - 1);
                    graphics.drawLine(n, n2 + this.swatchSize.height - 1, n + this.swatchSize.width - 1, n2 + this.swatchSize.height - 1);
                }
            }
        }

        public Dimension getPreferredSize() {
            int n = this.numSwatches.width * (this.swatchSize.width + this.gap.width) - 1;
            int n2 = this.numSwatches.height * (this.swatchSize.height + this.gap.height) - 1;
            return new Dimension(n, n2);
        }

        protected void initColors() {
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            Color color = this.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            return color.getRed() + ", " + color.getGreen() + ", " + color.getBlue();
        }

        public Color getColorForLocation(int n, int n2) {
            int n3 = n / (this.swatchSize.width + this.gap.width);
            int n4 = n2 / (this.swatchSize.height + this.gap.height);
            return this.getColorForCell(n3, n4);
        }

        private Color getColorForCell(int n, int n2) {
            return this.colors[n2 * this.numSwatches.width + n];
        }
    }

    class MainSwatchListener
    extends MouseAdapter {
        MainSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = SmallSwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            SmallSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

