/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.mobility.project.ui.customizer.support;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.spi.mobility.project.ui.customizer.VisualPropertyGroup;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VisualPropertySupport {
    private static final String WRONG_TYPE = "WrongType";
    private static final String CONFIG_PREFFIX = "configs.";
    private static Reference<VisualPropertySupport> cache = new WeakReference<Object>(null);
    private final Map<String, Object> backup;
    private final ComponentListener componentListener;
    private final CheckBoxListener listener;
    final Map<String, Object> properties;
    final HashMap<Object, Object> component2property;
    final HashMap<JCheckBox, VisualPropertyGroup> checkbox2group;
    private String configuration;

    public static VisualPropertySupport getDefault(Map<String, Object> map) {
        VisualPropertySupport visualPropertySupport = cache.get();
        if (visualPropertySupport == null || visualPropertySupport.properties != map) {
            visualPropertySupport = new VisualPropertySupport(map);
            cache = new WeakReference<VisualPropertySupport>(visualPropertySupport);
        }
        return visualPropertySupport;
    }

    public static String translatePropertyName(String string, String string2, boolean bl) {
        return bl || string == null ? string2 : VisualPropertySupport.prefixPropertyName(string, string2);
    }

    public static String prefixPropertyName(String string, String string2) {
        return CONFIG_PREFFIX + string + '.' + string2;
    }

    private VisualPropertySupport(Map<String, Object> map) {
        this.properties = map;
        this.backup = new HashMap<String, Object>();
        this.component2property = new HashMap(10);
        this.componentListener = new ComponentListener();
        this.checkbox2group = new HashMap();
        this.listener = new CheckBoxListener();
    }

    public void register(JCheckBox jCheckBox, String string, VisualPropertyGroup visualPropertyGroup) {
        jCheckBox.removeActionListener(this.listener);
        this.configuration = string;
        this.checkbox2group.put(jCheckBox, visualPropertyGroup);
        jCheckBox.setEnabled(string != null);
        boolean bl = !this.testForNonDefaultValue(visualPropertyGroup.getGroupPropertyNames());
        jCheckBox.setSelected(bl);
        this.refreshGroup(visualPropertyGroup, bl);
        jCheckBox.addActionListener(this.listener);
    }

    public void register(JCheckBox jCheckBox, String string, boolean bl) {
        this.register(jCheckBox, VisualPropertySupport.translatePropertyName(this.configuration, string, bl));
        jCheckBox.setEnabled(!bl);
    }

    public void register(JCheckBox jCheckBox, String string) {
        jCheckBox.removeActionListener(this.componentListener);
        Object object = this.properties.get(string);
        this.component2property.put(jCheckBox, string);
        jCheckBox.setSelected(object instanceof Boolean && (Boolean)object != false || object instanceof String && Boolean.parseBoolean((String)object));
        jCheckBox.addActionListener(this.componentListener);
    }

    public void register(JTextComponent jTextComponent, String string, boolean bl) {
        this.register(jTextComponent, VisualPropertySupport.translatePropertyName(this.configuration, string, bl));
        jTextComponent.setEnabled(!bl);
        jTextComponent.setEditable(!bl);
    }

    public void register(JTextComponent jTextComponent, String string) {
        jTextComponent.getDocument().removeDocumentListener(this.componentListener);
        this.component2property.put(jTextComponent.getDocument(), string);
        jTextComponent.setText(String.valueOf(this.properties.get(string)));
        jTextComponent.getDocument().addDocumentListener(this.componentListener);
    }

    public void register(JComboBox jComboBox, Object[] objectArray, String string, boolean bl) {
        this.register(jComboBox, objectArray, VisualPropertySupport.translatePropertyName(this.configuration, string, bl));
        jComboBox.setEnabled(!bl);
    }

    private Document getDocumentFor(JComboBox jComboBox) {
        Component component;
        ComboBoxEditor comboBoxEditor;
        if (jComboBox.isEditable() && (comboBoxEditor = jComboBox.getEditor()) != null && (component = comboBoxEditor.getEditorComponent()) instanceof JTextComponent) {
            return ((JTextComponent)component).getDocument();
        }
        return null;
    }

    public void register(JComboBox jComboBox, Object[] objectArray, String string) {
        int n;
        jComboBox.removeActionListener(this.componentListener);
        Document document = this.getDocumentFor(jComboBox);
        if (document != null) {
            document.removeDocumentListener(this.componentListener);
        }
        Object object = this.properties.get(string);
        this.component2property.put(jComboBox, string);
        if (document != null) {
            this.component2property.put(document, string);
        }
        if (objectArray == null) {
            ComboBoxModel comboBoxModel = jComboBox.getModel();
            objectArray = new Object[comboBoxModel.getSize()];
            for (n = 0; n < objectArray.length; ++n) {
                objectArray[n] = comboBoxModel.getElementAt(n);
            }
        }
        jComboBox.removeAllItems();
        boolean bl = false;
        for (n = 0; n < objectArray.length; ++n) {
            jComboBox.addItem(objectArray[n]);
            if (!objectArray[n].equals(object)) continue;
            bl = true;
            jComboBox.setSelectedIndex(n);
        }
        if (!bl) {
            if (jComboBox.isEditable()) {
                jComboBox.setSelectedItem(object);
            } else if (objectArray.length > 0) {
                jComboBox.setSelectedIndex(0);
                this.properties.put(string, objectArray[0]);
            }
        }
        jComboBox.addActionListener(this.componentListener);
        if (document != null) {
            document.addDocumentListener(this.componentListener);
        }
    }

    public void register(JSlider jSlider, String string, boolean bl) {
        this.register(jSlider, VisualPropertySupport.translatePropertyName(this.configuration, string, bl));
        jSlider.setEnabled(!bl);
        Enumeration enumeration = jSlider.getLabelTable().elements();
        while (enumeration.hasMoreElements()) {
            ((JComponent)enumeration.nextElement()).setEnabled(!bl);
        }
    }

    public void register(JSlider jSlider, String string) {
        jSlider.removeChangeListener(this.componentListener);
        Object object = this.properties.get(string);
        this.component2property.put(jSlider, string);
        jSlider.setValue(object instanceof Number ? ((Number)object).intValue() : (object instanceof String ? Integer.parseInt((String)object) : jSlider.getMinimum()));
        jSlider.addChangeListener(this.componentListener);
    }

    public void register(JSpinner jSpinner, String string, boolean bl) {
        this.register(jSpinner, VisualPropertySupport.translatePropertyName(this.configuration, string, bl));
        jSpinner.setEnabled(!bl);
    }

    public void register(JSpinner jSpinner, String string) {
        jSpinner.removeChangeListener(this.componentListener);
        Object object = this.properties.get(string);
        this.component2property.put(jSpinner, string);
        jSpinner.setValue(object instanceof Number ? ((Number)object).intValue() : (object instanceof String ? Integer.parseInt((String)object) : 0));
        jSpinner.addChangeListener(this.componentListener);
    }

    public void register(JRadioButton jRadioButton, String string, boolean bl) {
        this.register(jRadioButton, VisualPropertySupport.translatePropertyName(this.configuration, string, bl));
        jRadioButton.setEnabled(!bl);
    }

    public void register(JRadioButton jRadioButton, String string) {
        jRadioButton.removeActionListener(this.componentListener);
        Object object = this.properties.get(string);
        this.component2property.put(jRadioButton, string);
        jRadioButton.setSelected(object != null && object.toString().equals(VisualPropertySupport.readValue(jRadioButton)));
        jRadioButton.addActionListener(this.componentListener);
    }

    public static String[] translatePropertyNames(String string, String[] stringArray, boolean bl) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = VisualPropertySupport.translatePropertyName(string, stringArray[i], bl);
        }
        return stringArray2;
    }

    public void register(StorableTableModel storableTableModel, String[] stringArray, boolean bl) {
        this.register(storableTableModel, VisualPropertySupport.translatePropertyNames(this.configuration, stringArray, bl));
    }

    public void register(StorableTableModel storableTableModel, String[] stringArray) {
        storableTableModel.removeTableModelListener(this.componentListener);
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.properties.get(stringArray[i]);
        }
        this.component2property.put(storableTableModel, stringArray);
        storableTableModel.setDataDelegates(objectArray);
        storableTableModel.addTableModelListener(this.componentListener);
    }

    protected static Boolean readValue(JCheckBox jCheckBox) {
        return jCheckBox.isSelected() ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static String readValue(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            assert (false) : "Invalid document ";
            return "";
        }
    }

    protected static String readValue(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    protected static Integer readValue(JSlider jSlider) {
        return new Integer(jSlider.getValue());
    }

    protected static Object readValue(JSpinner jSpinner) {
        return jSpinner.getValue();
    }

    protected static String readValue(JRadioButton jRadioButton) {
        return jRadioButton.getActionCommand();
    }

    private boolean testForNonDefaultValue(String[] stringArray) {
        if (this.configuration == null) {
            return true;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.properties.get(VisualPropertySupport.prefixPropertyName(this.configuration, stringArray[i])) == null) continue;
            return true;
        }
        return false;
    }

    private void removeConfigProperties(String[] stringArray) {
        if (this.configuration == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = VisualPropertySupport.prefixPropertyName(this.configuration, stringArray[i]);
            this.backup.put(string, this.properties.remove(string));
        }
    }

    private void copyFromDefaults(String[] stringArray) {
        if (this.configuration == null) {
            return;
        }
        Class[] classArray = new Class[]{};
        Object[] objectArray = new Object[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = VisualPropertySupport.prefixPropertyName(this.configuration, stringArray[i]);
            if (this.properties.get(string) != null) continue;
            Object object = this.backup.get(string);
            if (object == null && (object = this.properties.get(stringArray[i])) instanceof Cloneable) {
                try {
                    Method method = object.getClass().getMethod("clone", classArray);
                    if (method != null) {
                        object = method.invoke(object, objectArray);
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
            this.properties.put(string, object);
        }
    }

    protected void refreshGroup(VisualPropertyGroup visualPropertyGroup, boolean bl) {
        if (bl) {
            this.removeConfigProperties(visualPropertyGroup.getGroupPropertyNames());
            visualPropertyGroup.initGroupValues(true);
        } else {
            this.copyFromDefaults(visualPropertyGroup.getGroupPropertyNames());
            visualPropertyGroup.initGroupValues(false);
        }
    }

    public static interface StorableTableModel
    extends TableModel {
        public Object[] getDataDelegates();

        public void setDataDelegates(Object[] var1);
    }

    private class CheckBoxListener
    implements ActionListener {
        private CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            VisualPropertyGroup visualPropertyGroup = VisualPropertySupport.this.checkbox2group.get(jCheckBox);
            if (visualPropertyGroup != null) {
                VisualPropertySupport.this.refreshGroup(visualPropertyGroup, jCheckBox.isSelected());
            }
        }
    }

    private class ComponentListener
    implements ActionListener,
    DocumentListener,
    ChangeListener,
    TableModelListener {
        private ComponentListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = (String)VisualPropertySupport.this.component2property.get(object);
            if (string != null) {
                if (object instanceof JCheckBox) {
                    VisualPropertySupport.this.properties.put(string, VisualPropertySupport.readValue((JCheckBox)object));
                } else if (object instanceof JComboBox) {
                    VisualPropertySupport.this.properties.put(string, VisualPropertySupport.readValue((JComboBox)object));
                } else if (object instanceof JRadioButton) {
                    VisualPropertySupport.this.properties.put(string, VisualPropertySupport.readValue((JRadioButton)object));
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            String string = (String)VisualPropertySupport.this.component2property.get(document);
            if (string != null) {
                VisualPropertySupport.this.properties.put(string, VisualPropertySupport.readValue(document));
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JSpinner jSpinner;
            Object object = changeEvent.getSource();
            String string = null;
            if (object instanceof JSlider) {
                JSlider jSlider = (JSlider)object;
                string = (String)VisualPropertySupport.this.component2property.get(jSlider);
                if (string != null) {
                    VisualPropertySupport.this.properties.put(string, VisualPropertySupport.readValue(jSlider));
                }
            } else if (object instanceof JSpinner && (string = (String)VisualPropertySupport.this.component2property.get(jSpinner = (JSpinner)object)) != null) {
                VisualPropertySupport.this.properties.put(string, VisualPropertySupport.readValue(jSpinner));
            }
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            StorableTableModel storableTableModel = (StorableTableModel)tableModelEvent.getSource();
            String[] stringArray = (String[])VisualPropertySupport.this.component2property.get(storableTableModel);
            if (stringArray != null) {
                Object[] objectArray = storableTableModel.getDataDelegates();
                for (int i = 0; i < stringArray.length; ++i) {
                    VisualPropertySupport.this.properties.put(stringArray[i], objectArray[i]);
                }
            }
        }
    }
}

