/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.derby.SearchUtil;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ExecSupport {
    private String lookFor;
    private OutputCopier[] copyMakers;

    public void setStringToLookFor(String string) {
        this.lookFor = string;
    }

    public boolean isStringFound() {
        if (this.copyMakers == null) {
            return false;
        }
        return this.copyMakers[0].stringFound() || this.copyMakers[1].stringFound() || this.copyMakers[2].stringFound();
    }

    public void displayProcessOutputs(final Process process, String string) throws IOException, InterruptedException {
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        try {
            inputOutput.getOut().reset();
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        inputOutput.select();
        this.copyMakers = new OutputCopier[3];
        this.copyMakers[0] = new OutputCopier(new InputStreamReader(process.getInputStream()), (Writer)inputOutput.getOut(), true, this.lookFor);
        this.copyMakers[0].start();
        this.copyMakers[1] = new OutputCopier(new InputStreamReader(process.getErrorStream()), (Writer)inputOutput.getErr(), true, this.lookFor);
        this.copyMakers[1].start();
        this.copyMakers[2] = new OutputCopier(inputOutput.getIn(), new OutputStreamWriter(process.getOutputStream()), true);
        this.copyMakers[2].start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    int n = process.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    try {
                        ExecSupport.this.copyMakers[0].interrupt();
                        ExecSupport.this.copyMakers[1].interrupt();
                        ExecSupport.this.copyMakers[2].interrupt();
                    }
                    catch (Exception exception) {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                    }
                }
            }
        }.start();
    }

    public boolean waitForMessage(int n) {
        int n2 = 10;
        Connect connect = new Connect(n2);
        Thread thread = new Thread(connect);
        thread.start();
        try {
            thread.join(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (thread.isAlive()) {
            connect.finishLoop();
            thread.interrupt();
        }
        return connect.getStatus();
    }

    private class Connect
    implements Runnable {
        int retryTime;
        boolean status = false;
        boolean loop = true;

        public Connect(int n) {
            this.retryTime = n;
        }

        public void finishLoop() {
            this.loop = false;
        }

        public void run() {
            while (this.loop) {
                if (ExecSupport.this.isStringFound()) {
                    this.status = true;
                    break;
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        boolean getStatus() {
            return this.status;
        }
    }

    public static class OutputCopier
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        private boolean done = false;
        private String stringToLookFor;
        private boolean stringFound = false;
        private static final int FOUND = -1;

        public OutputCopier(Reader reader, Writer writer, boolean bl, String string) {
            this.os = writer;
            this.is = reader;
            this.autoflush = bl;
            this.stringToLookFor = string;
        }

        public OutputCopier(Reader reader, Writer writer, boolean bl) {
            this(reader, writer, bl, null);
        }

        public boolean stringFound() {
            return this.stringFound;
        }

        public void run() {
            int n = 0;
            char[] cArray = new char[256];
            try {
                int n2;
                while ((n2 = this.read(this.is, cArray, 0, 256)) > 0) {
                    if (this.stringToLookFor != null && (n = SearchUtil.checkForString(this.stringToLookFor, n, cArray, n2)) == -1) {
                        this.stringToLookFor = null;
                        this.stringFound = true;
                    }
                    if (this.os == null) continue;
                    this.os.write(cArray, 0, n2);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader reader, char[] cArray, int n, int n2) throws InterruptedException, IOException {
            while (!reader.ready() && !this.done) {
                OutputCopier.sleep(100L);
            }
            return reader.read(cArray, n, n2);
        }
    }
}

