/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.spring.container.servlet;

import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.service.ComponentProvider;
import com.sun.jersey.spi.spring.container.servlet.SpringComponentProvider;
import com.sun.jersey.spi.spring.container.servlet.SpringResourceProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringServlet
extends ServletContainer {
    private static final long serialVersionUID = 5686655395749077671L;
    private static final Logger LOGGER = Logger.getLogger(SpringServlet.class.getName());

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        try {
            WebApplicationContext springContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)this.getServletContext());
            if (rc.getProperty("com.sun.jersey.config.property.DefaultResourceProviderClass") == null && this.springComponentAnnotationAvailable()) {
                rc.getProperties().put("com.sun.jersey.config.property.DefaultResourceProviderClass", SpringResourceProvider.class);
            }
            wa.initiate(rc, (ComponentProvider)new SpringComponentProvider((ConfigurableApplicationContext)springContext));
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.SEVERE, "Exception occurred when intialization", e);
            throw e;
        }
    }

    private boolean springComponentAnnotationAvailable() {
        try {
            Class.forName("org.springframework.stereotype.Component");
            LOGGER.info("The spring Component annotation is present: using spring >= 2.5");
            return true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("The spring Component annotation is not present: using spring < 2.5");
            return false;
        }
    }
}

