/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.util.Stack;
import java.util.prefs.Preferences;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndAbstractTokenProcessor;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenProcessor;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenProcessor;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BracketCompletion {
    static void charInserted(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (!BracketCompletion.completionSettingEnabled((Document)baseDocument)) {
            return;
        }
        TokenItem tokenItem = CndTokenUtilities.getToken((Document)baseDocument, (int)n, (boolean)true);
        if (tokenItem == null) {
            return;
        }
        if (c == ')' || c == ']' || c == '(' || c == '[') {
            switch ((CppTokenId)tokenItem.id()) {
                case RBRACKET: 
                case RPAREN: {
                    BracketCompletion.skipClosingBracket(baseDocument, caret, c);
                    break;
                }
                case LBRACKET: 
                case LPAREN: {
                    BracketCompletion.completeOpeningBracket(baseDocument, n, caret, c);
                }
            }
        } else if (c == '\"' || c == '\'') {
            BracketCompletion.completeQuote(baseDocument, n, caret, c);
        } else if (c == ';') {
            BracketCompletion.moveSemicolon(baseDocument, n, caret);
        } else if (c == '<') {
            if (tokenItem.id() == CppTokenId.PREPROCESSOR_SYS_INCLUDE && tokenItem.partType() == PartType.START) {
                BracketCompletion.completeOpeningBracket(baseDocument, n, caret, c);
            }
        } else if (c == '>') {
            char[] cArray;
            if (tokenItem.id() == CppTokenId.PREPROCESSOR_SYS_INCLUDE && (cArray = baseDocument.getChars(n + 1, 1)) != null && cArray[0] == '>') {
                baseDocument.remove(n + 1, 1);
            }
        } else if (c == '.' && n > 0 && (tokenItem = CndTokenUtilities.getToken((Document)baseDocument, (int)(n - 1), (boolean)true)).id() == CppTokenId.THIS) {
            baseDocument.remove(n, 1);
            baseDocument.insertString(n, "->", null);
            caret.setDot(n + 2);
        }
    }

    private static void moveSemicolon(BaseDocument baseDocument, int n, Caret caret) throws BadLocationException {
        int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)baseDocument, (int)n, (boolean)true, (boolean)false);
        if (tokenSequence == null) {
            return;
        }
        int n3 = n;
        while (tokenSequence.moveNext() && tokenSequence.offset() < n2) {
            Token token = tokenSequence.token();
            if (token.id() == CppTokenId.RPAREN) {
                n3 = tokenSequence.offset();
                continue;
            }
            if ("whitespace".equals(((CppTokenId)token.id()).primaryCategory())) continue;
            return;
        }
        if (BracketCompletion.posWithinAnyQuote(baseDocument, n) || BracketCompletion.isForLoopSemicolon(baseDocument, n)) {
            return;
        }
        baseDocument.remove(n, 1);
        baseDocument.insertString(n3, ";", null);
        caret.setDot(n3 + 1);
    }

    private static boolean isForLoopSemicolon(BaseDocument baseDocument, int n) {
        TokenSequence tokenSequence = CndLexerUtilities.getCppTokenSequence((Document)baseDocument, (int)n, (boolean)true, (boolean)false);
        if (tokenSequence == null || tokenSequence.token().id() != CppTokenId.SEMICOLON) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        while (tokenSequence.movePrevious()) {
            Token token = tokenSequence.token();
            if (token.id() == CppTokenId.LPAREN) {
                if (n2 == 0) {
                    String string;
                    while (tokenSequence.movePrevious() && ("whitespace".equals(string = ((CppTokenId)(token = tokenSequence.token()).id()).primaryCategory()) || "comment".equals(string))) {
                    }
                    return token.id() == CppTokenId.FOR;
                }
                --n2;
                continue;
            }
            if (token.id() == CppTokenId.RPAREN) {
                ++n2;
                continue;
            }
            if (token.id() == CppTokenId.LBRACE) {
                if (n3 == 0) {
                    return false;
                }
                --n3;
                continue;
            }
            if (token.id() == CppTokenId.RBRACE) {
                ++n3;
                continue;
            }
            if (token.id() != CppTokenId.SEMICOLON) continue;
            if (bl) {
                return false;
            }
            bl = true;
        }
        return false;
    }

    static void charBackspaced(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (BracketCompletion.completionSettingEnabled((Document)baseDocument)) {
            char[] cArray;
            if (baseDocument.getLength() == 0) {
                return;
            }
            if (c == '(' || c == '[') {
                TokenItem tokenItem = CndTokenUtilities.getToken((Document)baseDocument, (int)n, (boolean)true);
                if (tokenItem == null) {
                    return;
                }
                if (tokenItem.id() == CppTokenId.RBRACKET && BracketCompletion.tokenBalance(baseDocument, CppTokenId.LBRACKET, CppTokenId.RBRACKET, n) != 0 || tokenItem.id() == CppTokenId.RPAREN && BracketCompletion.tokenBalance(baseDocument, CppTokenId.LPAREN, CppTokenId.RPAREN, n) != 0) {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '\"') {
                char[] cArray2 = baseDocument.getChars(n, 1);
                if (cArray2 != null && cArray2[0] == '\"') {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '\'') {
                char[] cArray3 = baseDocument.getChars(n, 1);
                if (cArray3 != null && cArray3[0] == '\'') {
                    baseDocument.remove(n, 1);
                }
            } else if (c == '<' && (cArray = baseDocument.getChars(n, 1)) != null && cArray[0] == '>' && n > 0) {
                TokenItem tokenItem = CndTokenUtilities.getFirstNonWhiteBwd((Document)baseDocument, (int)(n - 1));
                switch ((CppTokenId)tokenItem.id()) {
                    case PREPROCESSOR_INCLUDE: 
                    case PREPROCESSOR_INCLUDE_NEXT: {
                        baseDocument.remove(n, 1);
                    }
                }
            }
        }
    }

    private static TokenSequence<CppTokenId> cppTokenSequence(Document document, int n, boolean bl) {
        return CndLexerUtilities.getCppTokenSequence((Document)document, (int)n, (boolean)true, (boolean)bl);
    }

    static boolean isAddRightBrace(BaseDocument baseDocument, int n) throws BadLocationException {
        if (!BracketCompletion.completionSettingEnabled((Document)baseDocument)) {
            return false;
        }
        if (BracketCompletion.tokenBalance(baseDocument, CppTokenId.LBRACE, CppTokenId.RBRACE, n) <= 0) {
            return false;
        }
        int n2 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
        TokenSequence<CppTokenId> tokenSequence = BracketCompletion.cppTokenSequence((Document)baseDocument, n, true);
        if (tokenSequence == null) {
            return false;
        }
        boolean bl = true;
        do {
            if (tokenSequence.offset() < n2) {
                return false;
            }
            switch ((CppTokenId)tokenSequence.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: {
                    break;
                }
                case BLOCK_COMMENT: 
                case DOXYGEN_COMMENT: {
                    if (!bl || n <= tokenSequence.offset() || n >= tokenSequence.offset() + tokenSequence.token().length()) break;
                    return false;
                }
                case LBRACE: {
                    return true;
                }
            }
            bl = false;
        } while (tokenSequence.movePrevious());
        return false;
    }

    static int getRowOrBlockEnd(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 == -1 || n >= n2) {
            return n;
        }
        ++n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        TokenSequence<CppTokenId> tokenSequence = BracketCompletion.cppTokenSequence((Document)baseDocument, n, false);
        if (tokenSequence == null) {
            return n;
        }
        while (tokenSequence.moveNext() && tokenSequence.offset() < n2) {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case LPAREN: {
                    ++n3;
                    break;
                }
                case RPAREN: {
                    if (n3-- != 0) break;
                    return tokenSequence.offset();
                }
                case LBRACE: {
                    ++n4;
                    break;
                }
                case RBRACE: {
                    if (n4-- != 0) break;
                    return tokenSequence.offset();
                }
                case LBRACKET: {
                    ++n5;
                    break;
                }
                case RBRACKET: {
                    if (n5-- != 0) break;
                    return tokenSequence.offset();
                }
            }
        }
        return n2;
    }

    private static int tokenBalance(BaseDocument baseDocument, CppTokenId cppTokenId, CppTokenId cppTokenId2, int n) throws BadLocationException {
        BalanceTokenProcessor balanceTokenProcessor = new BalanceTokenProcessor(cppTokenId, cppTokenId2);
        CndTokenUtilities.processTokens((CndTokenProcessor)balanceTokenProcessor, (Document)baseDocument, (int)0, (int)baseDocument.getLength());
        return balanceTokenProcessor.getBalance();
    }

    private static void skipClosingBracket(BaseDocument baseDocument, Caret caret, char c) throws BadLocationException {
        CppTokenId cppTokenId = c == ')' ? CppTokenId.RPAREN : CppTokenId.RBRACKET;
        int n = caret.getDot();
        if (BracketCompletion.isSkipClosingBracket(baseDocument, n, cppTokenId)) {
            baseDocument.remove(n - 1, 1);
            caret.setDot(n);
        }
    }

    static boolean isSkipClosingBracket(BaseDocument baseDocument, int n, CppTokenId cppTokenId) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return false;
        }
        boolean bl = false;
        TokenSequence<CppTokenId> tokenSequence = BracketCompletion.cppTokenSequence((Document)baseDocument, n, false);
        if (tokenSequence == null) {
            return false;
        }
        if (tokenSequence.token().id() == cppTokenId) {
            CppTokenId cppTokenId2;
            CppTokenId cppTokenId3 = tokenSequence.token().id() == CppTokenId.RPAREN ? CppTokenId.LPAREN : CppTokenId.LBRACKET;
            int n2 = tokenSequence.index();
            while (tokenSequence.moveNext() && tokenSequence.token().id() == cppTokenId) {
                n2 = tokenSequence.index();
            }
            int n3 = 0;
            int n4 = -1;
            boolean bl2 = false;
            while (!bl2 && tokenSequence.movePrevious()) {
                cppTokenId2 = (CppTokenId)tokenSequence.token().id();
                switch (cppTokenId2) {
                    case LBRACKET: 
                    case LPAREN: {
                        if (cppTokenId2 != cppTokenId || ++n4 != 0) break;
                        if (n3 != 0) {
                            n4 = 1;
                        }
                        bl2 = true;
                        break;
                    }
                    case RBRACKET: 
                    case RPAREN: {
                        if (cppTokenId2 != cppTokenId) break;
                        --n4;
                        break;
                    }
                    case LBRACE: {
                        if (++n3 <= 0) break;
                        bl2 = true;
                        break;
                    }
                    case RBRACE: {
                        --n3;
                    }
                }
            }
            if (n4 != 0) {
                bl = true;
            } else {
                n3 = 0;
                n4 = 1;
                tokenSequence.moveIndex(n2);
                tokenSequence.moveNext();
                tokenSequence.moveNext();
                bl2 = false;
                while (!bl2 && tokenSequence.movePrevious()) {
                    cppTokenId2 = (CppTokenId)tokenSequence.token().id();
                    switch (cppTokenId2) {
                        case LBRACKET: 
                        case LPAREN: {
                            if (cppTokenId2 != cppTokenId3) break;
                            ++n4;
                            break;
                        }
                        case RBRACKET: 
                        case RPAREN: {
                            if (cppTokenId2 != cppTokenId || --n4 != 0) break;
                            if (n3 != 0) {
                                n4 = -1;
                            }
                            bl2 = true;
                            break;
                        }
                        case LBRACE: {
                            ++n3;
                            break;
                        }
                        case RBRACE: {
                            if (--n3 >= 0) break;
                            bl2 = true;
                        }
                    }
                }
                bl = n4 == 0;
            }
        }
        return bl;
    }

    private static void completeOpeningBracket(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        if (BracketCompletion.isCompletablePosition(baseDocument, n + 1)) {
            String string = "" + BracketCompletion.matching(c);
            baseDocument.insertString(n + 1, string, null);
            caret.setDot(n + 1);
        }
    }

    private static boolean isEscapeSequence(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n <= 0) {
            return false;
        }
        char c = baseDocument.getChars(n - 1, 1)[0];
        return c == '\\';
    }

    private static void completeQuote(BaseDocument baseDocument, int n, Caret caret, char c) throws BadLocationException {
        CppTokenId[] cppTokenIdArray;
        if (BracketCompletion.isEscapeSequence(baseDocument, n)) {
            return;
        }
        if (c == '\"') {
            CppTokenId[] cppTokenIdArray2 = new CppTokenId[2];
            cppTokenIdArray2[0] = CppTokenId.STRING_LITERAL;
            cppTokenIdArray = cppTokenIdArray2;
            cppTokenIdArray2[1] = CppTokenId.PREPROCESSOR_USER_INCLUDE;
        } else {
            CppTokenId[] cppTokenIdArray3 = new CppTokenId[1];
            cppTokenIdArray = cppTokenIdArray3;
            cppTokenIdArray3[0] = CppTokenId.CHAR_LITERAL;
        }
        CppTokenId[] cppTokenIdArray4 = cppTokenIdArray;
        if (BracketCompletion.posWithinQuotes(baseDocument, n + 1, c, cppTokenIdArray4) && BracketCompletion.isCompletablePosition(baseDocument, n + 1) && BracketCompletion.isUnclosedStringAtLineEnd(baseDocument, n + 1, cppTokenIdArray4) && (baseDocument.getLength() == n + 1 || baseDocument.getLength() != n + 1 && baseDocument.getChars(n + 1, 1)[0] != c)) {
            baseDocument.insertString(n + 1, "" + c, null);
            caret.setDot(n + 1);
        } else {
            char[] cArray = baseDocument.getChars(n + 1, 1);
            if (cArray != null && cArray[0] == c) {
                baseDocument.remove(n + 1, 1);
            }
        }
    }

    private static boolean isCompletablePosition(BaseDocument baseDocument, int n) throws BadLocationException {
        if (n == baseDocument.getLength()) {
            return true;
        }
        char c = baseDocument.getChars(n, 1)[0];
        return c == ')' || c == ',' || c == '\"' || c == '\'' || c == ' ' || c == '-' || c == '+' || c == '|' || c == '&' || c == ']' || c == '}' || c == '\n' || c == '\t' || c == ';';
    }

    private static boolean completionSettingEnabled(Document document) {
        Preferences preferences = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((Document)document)).lookup(Preferences.class);
        return preferences.getBoolean("pair-characters-completion", true);
    }

    private static char matching(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '<': {
                return '>';
            }
        }
        return ' ';
    }

    static boolean posWithinString(BaseDocument baseDocument, int n) {
        return BracketCompletion.posWithinQuotes(baseDocument, n, '\"', new CppTokenId[]{CppTokenId.STRING_LITERAL});
    }

    static boolean posWithinQuotes(BaseDocument baseDocument, int n, char c, CppTokenId[] cppTokenIdArray) {
        TokenSequence<CppTokenId> tokenSequence = BracketCompletion.cppTokenSequence((Document)baseDocument, n, true);
        if (tokenSequence != null && BracketCompletion.matchIDs((CppTokenId)tokenSequence.token().id(), cppTokenIdArray)) {
            return n - tokenSequence.offset() == 1 || DocumentUtilities.getText((Document)baseDocument).charAt(n - 1) != c;
        }
        return false;
    }

    static boolean posWithinAnyQuote(BaseDocument baseDocument, int n) {
        TokenSequence<CppTokenId> tokenSequence = BracketCompletion.cppTokenSequence((Document)baseDocument, n - 1, false);
        if (tokenSequence != null) {
            switch ((CppTokenId)tokenSequence.token().id()) {
                case STRING_LITERAL: 
                case CHAR_LITERAL: 
                case PREPROCESSOR_USER_INCLUDE: 
                case PREPROCESSOR_SYS_INCLUDE: {
                    char c = DocumentUtilities.getText((Document)baseDocument).charAt(n - 1);
                    return n - tokenSequence.offset() == 1 || c != '\"' && c != '\'';
                }
            }
        }
        return false;
    }

    static boolean isUnclosedStringAtLineEnd(BaseDocument baseDocument, int n, CppTokenId[] cppTokenIdArray) {
        int n2;
        try {
            n2 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        TokenSequence<CppTokenId> tokenSequence = BracketCompletion.cppTokenSequence((Document)baseDocument, n2, false);
        if (tokenSequence != null) {
            return BracketCompletion.matchIDs((CppTokenId)tokenSequence.token().id(), cppTokenIdArray);
        }
        return false;
    }

    static boolean matchIDs(TokenID tokenID, TokenID[] tokenIDArray) {
        for (int i = tokenIDArray.length - 1; i >= 0; --i) {
            if (tokenID != tokenIDArray[i]) continue;
            return true;
        }
        return false;
    }

    static boolean matchIDs(CppTokenId cppTokenId, CppTokenId[] cppTokenIdArray) {
        for (int i = cppTokenIdArray.length - 1; i >= 0; --i) {
            if (cppTokenId != cppTokenIdArray[i]) continue;
            return true;
        }
        return false;
    }

    static boolean matchIDs(Token<CppTokenId> token, Token<CppTokenId>[] tokenArray) {
        for (int i = tokenArray.length - 1; i >= 0; --i) {
            if (token != tokenArray[i]) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BalanceTokenProcessor
    extends CndAbstractTokenProcessor<Token<CppTokenId>> {
        private CppTokenId leftTokenID;
        private CppTokenId rightTokenID;
        private Stack<Integer> stack = new Stack();
        private int balance;
        private boolean isDefine;

        BalanceTokenProcessor(CppTokenId cppTokenId, CppTokenId cppTokenId2) {
            this.leftTokenID = cppTokenId;
            this.rightTokenID = cppTokenId2;
        }

        public boolean token(Token<CppTokenId> token, int n) {
            if (token.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                return true;
            }
            switch ((CppTokenId)token.id()) {
                case NEW_LINE: {
                    this.isDefine = false;
                    break;
                }
                case PREPROCESSOR_DEFINE: {
                    this.isDefine = true;
                    break;
                }
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    this.stack.push(this.balance);
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    if (this.stack.empty()) break;
                    this.balance = this.stack.peek();
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    if (this.stack.empty()) break;
                    this.stack.pop();
                    break;
                }
                default: {
                    if (this.isDefine) break;
                    if (token.id() == this.leftTokenID) {
                        ++this.balance;
                        break;
                    }
                    if (token.id() != this.rightTokenID) break;
                    --this.balance;
                }
            }
            return false;
        }

        private int getBalance() {
            return this.balance;
        }
    }

    static class MyTokenProcessor
    implements TokenProcessor {
        public TokenID tokenID = null;
        public int tokenStart = -1;
        private int bufferStartPos = 0;

        MyTokenProcessor() {
        }

        public boolean token(TokenID tokenID, TokenContextPath tokenContextPath, int n, int n2) {
            this.tokenStart = this.tokenBuffer2DocumentOffset(n);
            this.tokenID = tokenID;
            return false;
        }

        public int eot(int n) {
            return 0;
        }

        public void nextBuffer(char[] cArray, int n, int n2, int n3, int n4, boolean bl) {
            this.bufferStartPos = n3 - n;
        }

        private int tokenBuffer2DocumentOffset(int n) {
            return n + this.bufferStartPos;
        }
    }
}

