/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.BracePlacementProperty;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreprocessorIndentProperty
extends PropertySupport.ReadWrite<CodeStyle.PreprocessorIndent> {
    private final CodeStyle.Language language;
    private final String optionID;
    private PreviewPreferences preferences;
    private CodeStyle.PreprocessorIndent state;
    private PropertyEditor editor;

    public PreprocessorIndentProperty(CodeStyle.Language language, PreviewPreferences previewPreferences, String string) {
        super(string, CodeStyle.PreprocessorIndent.class, PreprocessorIndentProperty.getString("LBL_" + string), PreprocessorIndentProperty.getString("HINT_" + string));
        this.language = language;
        this.optionID = string;
        this.preferences = previewPreferences;
        this.init();
    }

    private static String getString(String string) {
        return NbBundle.getMessage(BracePlacementProperty.class, (String)string);
    }

    private void init() {
        this.state = CodeStyle.PreprocessorIndent.valueOf(this.getPreferences().get(this.optionID, this.getDefault().name()));
    }

    private CodeStyle.PreprocessorIndent getDefault() {
        return CodeStyle.PreprocessorIndent.valueOf((String)EditorOptions.getDefault(this.getPreferences().getLanguage(), this.getPreferences().getStyleId(), this.optionID));
    }

    private PreviewPreferences getPreferences() {
        return this.preferences;
    }

    public String getHtmlDisplayName() {
        if (!this.isDefaultValue()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public CodeStyle.PreprocessorIndent getValue() {
        return this.state;
    }

    public void setValue(CodeStyle.PreprocessorIndent preprocessorIndent) {
        this.state = preprocessorIndent;
        this.getPreferences().put(this.optionID, this.state.name());
    }

    public void restoreDefaultValue() {
        this.setValue(this.getDefault());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getDefault().equals((Object)this.getValue());
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new PreprocessorIndentEditor();
        }
        return this.editor;
    }

    private static class PreprocessorIndentEditor
    extends PropertyEditorSupport {
        private PreprocessorIndentEditor() {
        }

        public String[] getTags() {
            try {
                CodeStyle.PreprocessorIndent[] preprocessorIndentArray = CodeStyle.PreprocessorIndent.values();
                String[] stringArray = new String[preprocessorIndentArray.length];
                for (int i = 0; i < preprocessorIndentArray.length; ++i) {
                    stringArray[i] = preprocessorIndentArray[i].toString();
                }
                return stringArray;
            }
            catch (Exception exception) {
                throw new AssertionError((Object)exception);
            }
        }

        public String getAsText() {
            Object object = this.getValue();
            return object != null ? object.toString() : "";
        }

        public void setAsText(String string) {
            if (string.length() > 0) {
                CodeStyle.PreprocessorIndent[] preprocessorIndentArray = CodeStyle.PreprocessorIndent.values();
                for (int i = 0; i < preprocessorIndentArray.length; ++i) {
                    if (!preprocessorIndentArray[i].toString().equals(string)) continue;
                    this.setValue((Object)preprocessorIndentArray[i]);
                    return;
                }
            }
            this.setValue(null);
        }

        public String getJavaInitializationString() {
            CodeStyle.PreprocessorIndent preprocessorIndent = (CodeStyle.PreprocessorIndent)((Object)this.getValue());
            return preprocessorIndent != null ? CodeStyle.PreprocessorIndent.class.getName().replace('$', '.') + '.' + preprocessorIndent.name() : "null";
        }
    }
}

