/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.spi;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.BugtrackingConfig;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IssueStorage {
    private static IssueStorage instance;
    private File storage;
    private static final String STORAGE_FILE = "storage";
    private static final String STORAGE_VERSION = "1.0";
    private String QUERY_ARCHIVED_SUFIX = ".qa";
    private String QUERY_SUFIX = ".q";
    private String ISSUE_SUFIX = ".i";

    private IssueStorage() {
    }

    public static IssueStorage getInstance() {
        if (instance == null) {
            instance = new IssueStorage();
            instance.initStorage();
        }
        return instance;
    }

    private void initStorage() {
        this.storage = this.getStorageRootFile();
        if (!this.storage.exists()) {
            this.storage.mkdirs();
        }
        this.writeStorage();
        RequestProcessor.Task task = BugtrackingManager.getInstance().getRequestProcessor().create(new Runnable(){

            public void run() {
                IssueStorage.this.cleanup();
            }
        });
        task.schedule(0);
    }

    /*
     * Loose catch block
     */
    public void storeIssue(String string, IssueCache.IssueEntry issueEntry) throws IOException {
        block27: {
            DataOutputStream dataOutputStream;
            InputStream inputStream;
            block26: {
                block25: {
                    assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
                    BugtrackingManager.LOG.log(Level.FINE, "start storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                    inputStream = null;
                    dataOutputStream = null;
                    dataOutputStream = this.getIssueOutputStream(this.getNameSpaceFolder(string), issueEntry.getId());
                    if (dataOutputStream != null) break block25;
                    BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                dataOutputStream.writeBoolean(issueEntry.wasSeen());
                if (issueEntry.getSeenAttributes() == null) break block26;
                for (Map.Entry<String, String> entry : issueEntry.getSeenAttributes().entrySet()) {
                    this.writeString(dataOutputStream, entry.getKey());
                    this.writeString(dataOutputStream, entry.getValue());
                }
            }
            BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block27;
            }
            catch (Exception exception) {}
            break block27;
            catch (InterruptedException interruptedException) {
                try {
                    BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                    IOException iOException = new IOException(interruptedException.getMessage());
                    iOException.initCause(interruptedException);
                    throw iOException;
                }
                catch (Throwable throwable) {
                    BugtrackingManager.LOG.log(Level.FINE, "finished storing issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                    try {
                        if (dataOutputStream != null) {
                            dataOutputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    public void readIssue(String string, IssueCache.IssueEntry issueEntry) throws IOException {
        DataInputStream dataInputStream;
        block18: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
            dataInputStream = null;
            dataInputStream = this.getIssueInputStream(this.getNameSpaceFolder(string), issueEntry.getId());
            if (dataInputStream != null) break block18;
            BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            boolean bl = dataInputStream.readBoolean();
            try {
                while (true) {
                    String string2 = IssueStorage.readString(dataInputStream);
                    String string3 = IssueStorage.readString(dataInputStream);
                    hashMap.put(string2, string3);
                }
            }
            catch (EOFException eOFException) {
                issueEntry.setSeenAttributes(hashMap);
                issueEntry.setSeen(bl);
                BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished reading issue {0} - {1}", new Object[]{string, issueEntry.getId()});
                if (dataInputStream != null) {
                    try {
                        dataInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public List<String> readQuery(String string, String string2) throws IOException {
        List<String> list;
        File file;
        block6: {
            assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
            BugtrackingManager.LOG.log(Level.FINE, "start reading query {0} - {1}", new Object[]{string, string2});
            file = this.getNameSpaceFolder(string);
            if (file.exists()) break block6;
            List<String> list2 = Collections.emptyList();
            BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{string, string2});
            return list2;
        }
        try {
            DataInputStream dataInputStream = this.getQueryInputStream(file, string2, false);
            list = this.readQuery(dataInputStream);
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished reading query {0} - {1}", new Object[]{string, string2});
        return list;
    }

    private List<String> readQuery(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            String string = null;
            try {
                string = IssueStorage.readString(dataInputStream);
            }
            catch (EOFException eOFException) {
                break;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public Map<String, Long> readArchivedQueryIssues(String string, String string2) throws IOException {
        Object object;
        Object object2;
        long l;
        long l2;
        block9: {
            File file;
            block8: {
                assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
                BugtrackingManager.LOG.log(Level.FINE, "start reading archived query issues {0} - {1}", new Object[]{string, string2});
                l2 = System.currentTimeMillis();
                l = BugtrackingConfig.getInstance().getArchivedIssuesTTL() * 1000L * 60L * 60L * 24L;
                file = this.getNameSpaceFolder(string);
                if (file.exists()) break block8;
                Map<String, Long> map = Collections.emptyMap();
                BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
                return map;
            }
            object2 = this.getQueryInputStream(file, string2, true);
            if (object2 != null) break block9;
            Map<String, Long> map = Collections.emptyMap();
            BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
            return map;
        }
        try {
            Map<String, Long> map = this.readArchivedQueryIssues((DataInputStream)object2);
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                long l3 = map.get(object);
                if (l3 >= l2 - l) continue;
                iterator.remove();
            }
            object = map;
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                object2 = new IOException(interruptedException.getMessage());
                ((Throwable)object2).initCause(interruptedException);
                throw object2;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished reading archived query issues {0} - {1}", new Object[]{string, string2});
        return object;
    }

    private Map<String, Long> readArchivedQueryIssues(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> hashMap = new HashMap<String, Long>();
        while (true) {
            String string = null;
            long l = -1L;
            try {
                string = IssueStorage.readString(dataInputStream);
                l = dataInputStream.readLong();
                hashMap.put(string, l);
            }
            catch (EOFException eOFException) {
                return hashMap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQuery(String string, String string2) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start removing query {0} - {1}", new Object[]{string, string2});
        try {
            File file;
            File file2 = this.getNameSpaceFolder(string);
            File file3 = new File(file2, this.encode(string2) + this.QUERY_SUFIX);
            if (file3.exists()) {
                BugtrackingUtil.deleteRecursively(file3);
            }
            if ((file = new File(file2, this.encode(string2) + this.QUERY_ARCHIVED_SUFIX)).exists()) {
                BugtrackingUtil.deleteRecursively(file);
            }
        }
        catch (Throwable throwable) {
            BugtrackingManager.LOG.log(Level.FINE, "finished removing query {0} - {1}", new Object[]{string, string2});
            throw throwable;
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished removing query {0} - {1}", new Object[]{string, string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeQuery(String string, String string2, String[] stringArray) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start storing query issues {0} - {1}", new Object[]{string, string2});
        try {
            File file = this.getNameSpaceFolder(string);
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = this.getQueryOutputStream(file, string2, false);
                for (String string3 : stringArray) {
                    this.writeString(dataOutputStream, string3);
                }
                dataOutputStream.flush();
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished storing query issues {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing query issues {0} - {1}", new Object[]{string, string2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeArchivedQueryIssues(String string, String string2, String[] stringArray) throws IOException {
        assert (!SwingUtilities.isEventDispatchThread()) : "should not access the issue storage in awt";
        BugtrackingManager.LOG.log(Level.FINE, "start storing archevid query issues {0} - {1}", new Object[]{string, string2});
        long l = System.currentTimeMillis();
        Map<String, Long> map = this.readArchivedQueryIssues(string, string2);
        try {
            File file = this.getNameSpaceFolder(string);
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = this.getQueryOutputStream(file, string2, true);
                for (String string3 : stringArray) {
                    this.writeString(dataOutputStream, string3);
                    Long l2 = map.get(string3);
                    if (l2 != null && l2 != -1L) {
                        dataOutputStream.writeLong(l2);
                        continue;
                    }
                    dataOutputStream.writeLong(l);
                }
                dataOutputStream.flush();
            }
            finally {
                try {
                    if (dataOutputStream != null) {
                        dataOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (InterruptedException interruptedException) {
            try {
                BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
                IOException iOException = new IOException(interruptedException.getMessage());
                iOException.initCause(interruptedException);
                throw iOException;
            }
            catch (Throwable throwable) {
                BugtrackingManager.LOG.log(Level.FINE, "finished storing archived query issues {0} - {1}", new Object[]{string, string2});
                throw throwable;
            }
        }
        BugtrackingManager.LOG.log(Level.FINE, "finished storing archived query issues {0} - {1}", new Object[]{string, string2});
    }

    void cleanup() {
        File file = this.getStorageRootFile();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file2 : fileArray) {
            this.cleanup(file2);
        }
    }

    void cleanup(String string) {
        this.cleanup(this.getNameSpaceFolder(string));
    }

    private void cleanup(File file) {
        try {
            File file2;
            int n;
            int n2;
            File[] fileArray;
            HashSet<String> hashSet = new HashSet<String>();
            File[] fileArray2 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(IssueStorage.this.QUERY_SUFIX);
                }
            });
            if (fileArray2 != null && fileArray2.length > 0) {
                fileArray = fileArray2;
                n2 = fileArray.length;
                for (n = 0; n < n2; ++n) {
                    file2 = fileArray[n];
                    List<String> object2 = this.readQuery(this.getDataInputStream(file2));
                    if (object2 == null || object2.size() == 0) continue;
                    hashSet.addAll(object2);
                }
            }
            if ((fileArray2 = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(IssueStorage.this.QUERY_ARCHIVED_SUFIX);
                }
            })) != null) {
                fileArray = fileArray2;
                n2 = fileArray.length;
                for (n = 0; n < n2; ++n) {
                    file2 = fileArray[n];
                    Map<String, Long> map = this.readArchivedQueryIssues(this.getDataInputStream(file2));
                    if (map == null || map.size() == 0) continue;
                    hashSet.addAll(map.keySet());
                }
            }
            if ((fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(IssueStorage.this.ISSUE_SUFIX);
                }
            })) != null) {
                for (File file3 : fileArray) {
                    String string = file3.getName();
                    if (hashSet.contains(string = string.substring(0, string.length() - this.ISSUE_SUFIX.length()))) continue;
                    file3.delete();
                }
            }
        }
        catch (IOException iOException) {
            BugtrackingManager.LOG.log(Level.WARNING, null, iOException);
        }
        catch (InterruptedException interruptedException) {
            BugtrackingManager.LOG.log(Level.WARNING, null, interruptedException);
        }
    }

    private File getStorageRootFile() {
        String string = System.getProperty("netbeans.user");
        return new File(new File(string, "var"), "bugtracking");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStorage() {
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = this.getDataOutputStream(new File(this.storage, STORAGE_FILE), false);
            this.writeString((DataOutputStream)filterOutputStream, STORAGE_VERSION);
            ((DataOutputStream)filterOutputStream).flush();
        }
        catch (Exception exception) {
            BugtrackingManager.LOG.log(Level.INFO, null, exception);
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void writeString(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string != null) {
            dataOutputStream.writeInt(string.length());
            dataOutputStream.writeChars(string);
        } else {
            dataOutputStream.writeInt(0);
        }
    }

    private static String readString(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            char c = dataInputStream.readChar();
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private DataOutputStream getIssueOutputStream(File file, String string) throws IOException, InterruptedException {
        File file2 = new File(file, string + this.ISSUE_SUFIX);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(this.getFileOutputStream(file2, false)));
        ZipEntry zipEntry = new ZipEntry(file2.getName());
        zipOutputStream.putNextEntry(zipEntry);
        return new DataOutputStream(zipOutputStream);
    }

    private DataInputStream getIssueInputStream(File file, String string) throws IOException, InterruptedException {
        File file2 = new File(file, string + this.ISSUE_SUFIX);
        if (!file2.exists()) {
            return null;
        }
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(this.getFileInputStream(file2)));
        ZipEntry zipEntry = new ZipEntry(file2.getName());
        zipInputStream.getNextEntry();
        return new DataInputStream(zipInputStream);
    }

    private DataOutputStream getDataOutputStream(File file, boolean bl) throws IOException, InterruptedException {
        return new DataOutputStream(this.getFileOutputStream(file, bl));
    }

    private DataInputStream getDataInputStream(File file) throws IOException, InterruptedException {
        return new DataInputStream(this.getFileInputStream(file));
    }

    private FileOutputStream getFileOutputStream(File file, boolean bl) throws IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return new FileOutputStream(file, bl);
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }

    private FileInputStream getFileInputStream(File file) throws IOException, InterruptedException {
        int n = 0;
        while (true) {
            try {
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                if (++n > 7) {
                    throw iOException;
                }
                Thread.sleep(n * 30);
                continue;
            }
            break;
        }
    }

    private static void copyStreams(OutputStream outputStream, InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) >= 0) {
            outputStream.write(byArray, 0, n);
        }
    }

    private File getNameSpaceFolder(String string) {
        File file = new File(this.storage, this.encode(string));
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    private DataOutputStream getQueryOutputStream(File file, String string, boolean bl) throws IOException, InterruptedException {
        File file2 = new File(file, this.encode(string) + (bl ? this.QUERY_ARCHIVED_SUFIX : this.QUERY_SUFIX));
        return this.getDataOutputStream(file2, false);
    }

    private DataInputStream getQueryInputStream(File file, String string, boolean bl) throws IOException, InterruptedException {
        File file2 = new File(file, this.encode(string) + (bl ? this.QUERY_ARCHIVED_SUFIX : this.QUERY_SUFIX));
        if (!file2.exists()) {
            return null;
        }
        return this.getDataInputStream(file2);
    }

    private String encode(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!IssueStorage.isAlowedChar(c)) {
                stringBuffer.append('%');
                stringBuffer.append(Integer.toHexString(c).toUpperCase());
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    private static boolean isAlowedChar(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == '_';
    }
}

