/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.issue;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class IssueAction
extends SystemAction {
    public IssueAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(IssueAction.class, (String)"CTL_IssueAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(IssueAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        IssueAction.openIssue();
    }

    public static void openIssue() {
        IssueAction.openIssue(null);
    }

    public static void openIssue(Repository repository) {
        boolean bl;
        Repository repository2;
        if (repository != null) {
            repository2 = repository;
            bl = true;
        } else {
            repository2 = BugtrackingOwnerSupport.getInstance().getRepository(BugtrackingOwnerSupport.ContextType.SELECTED_FILE_AND_ALL_PROJECTS);
            bl = false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = new IssueTopComponent();
                issueTopComponent.initNewIssue(repository2, !bl);
                issueTopComponent.open();
                issueTopComponent.requestActive();
            }
        });
    }

    public static void openIssue(final Issue issue, final Repository repository, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = null;
                if (issue != null) {
                    issueTopComponent = IssueTopComponent.find(issue);
                }
                if (issueTopComponent == null) {
                    issueTopComponent = new IssueTopComponent();
                }
                issueTopComponent.initNewIssue(repository, bl);
                if (!issueTopComponent.isOpened()) {
                    issueTopComponent.open();
                }
                issueTopComponent.requestActive();
            }
        });
    }

    public static void closeIssue(final Issue issue) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                IssueTopComponent issueTopComponent = IssueTopComponent.find(issue);
                if (issueTopComponent != null) {
                    issueTopComponent.close();
                }
            }
        });
    }
}

