/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.nodes;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class BugtrackingRootNode
extends AbstractNode {
    private static final String ICON_BASE = "org/netbeans/modules/bugtracking/ui/resources/bugtracking.png";
    private static final Object LOCK_INIT = new Object();
    private static BugtrackingRootNode defaultInstance;

    private BugtrackingRootNode() {
        super((Children)new RootNodeChildren());
        this.setName("bugtracking");
        this.setDisplayName(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_BugtrackingNode"));
        this.setIconBaseWithExtension(ICON_BASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BugtrackingRootNode getDefault() {
        Object object = LOCK_INIT;
        synchronized (object) {
            if (defaultInstance == null) {
                defaultInstance = new BugtrackingRootNode();
            }
            return defaultInstance;
        }
    }

    public Action[] getActions(boolean bl) {
        return new Action[]{new AbstractAction(NbBundle.getMessage(BugtrackingRootNode.class, (String)"LBL_CreateRepository")){

            public void actionPerformed(ActionEvent actionEvent) {
                BugtrackingUtil.createRepository();
            }
        }};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RepositoryComparator
    implements Comparator<Repository> {
        private RepositoryComparator() {
        }

        @Override
        public int compare(Repository repository, Repository repository2) {
            if (repository == null && repository2 == null) {
                return 0;
            }
            if (repository == null) {
                return -1;
            }
            if (repository2 == null) {
                return 1;
            }
            return repository.getDisplayName().compareTo(repository2.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RootNodeChildren
    extends Children.Keys<Repository>
    implements PropertyChangeListener {
        public RootNodeChildren() {
            BugtrackingManager.getInstance().addPropertyChangeListener(this);
        }

        protected Node[] createNodes(Repository repository) {
            return new Node[]{repository.getNode()};
        }

        protected void addNotify() {
            super.addNotify();
            this.refreshKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            super.removeNotify();
        }

        private void refreshKeys() {
            ArrayList<Repository> arrayList = new ArrayList<Repository>();
            arrayList.addAll(Arrays.asList(BugtrackingManager.getInstance().getRepositories()));
            Collections.sort(arrayList, new RepositoryComparator());
            this.setKeys(arrayList);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("bugtracking.repositories.changed")) {
                this.refreshKeys();
            }
        }
    }
}

