/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class QueryAction
extends SystemAction {
    public QueryAction() {
        this.setIcon(null);
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return NbBundle.getMessage(QueryAction.class, (String)"CTL_QueryAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(QueryAction.class);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        QueryAction.openQuery(null);
    }

    public static void openQuery(Query query) {
        Repository repository = BugtrackingOwnerSupport.getInstance().getRepository(BugtrackingOwnerSupport.ContextType.SELECTED_FILE_AND_ALL_PROJECTS);
        QueryAction.openQuery(query, repository);
    }

    public static void openQuery(Query query, Repository repository) {
        QueryAction.openQueryIntern(query, repository, false);
    }

    public static void openKenaiQuery(Query query, Repository repository) {
        QueryAction.openQueryIntern(query, repository, true);
    }

    private static void openQueryIntern(final Query query, final Repository repository, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                QueryTopComponent queryTopComponent = null;
                if (query != null) {
                    queryTopComponent = QueryTopComponent.find(query);
                }
                if (queryTopComponent == null) {
                    queryTopComponent = bl ? QueryTopComponent.forKenai(query, repository) : new QueryTopComponent(query, repository);
                }
                if (!queryTopComponent.isOpened()) {
                    queryTopComponent.open();
                }
                queryTopComponent.requestActive();
            }
        });
    }

    public static void closeQuery(final Query query) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TopComponent topComponent = null;
                if (query != null) {
                    topComponent = WindowManager.getDefault().findTopComponent(query.getDisplayName());
                }
                if (topComponent != null) {
                    topComponent.close();
                }
            }
        });
    }
}

