/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.search;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.Timer;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.netbeans.modules.bugtracking.ui.search.PopupItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResultsModel
extends AbstractListModel
implements ActionListener {
    private static ResultsModel instance;
    private List<PopupItem> results;
    private Timer fireTimer;
    static final int COALESCE_TIME = 200;
    private Map<Repository, Set<Issue>> issuesCached = new HashMap<Repository, Set<Issue>>();

    private ResultsModel() {
    }

    public static ResultsModel getInstance() {
        if (instance == null) {
            instance = new ResultsModel();
        }
        return instance;
    }

    void setContent(List<PopupItem> list) {
        this.results = list;
        this.maybeFireChanges();
    }

    synchronized void cacheIssues(Repository repository, Issue[] issueArray) {
        HashSet<Issue> hashSet = new HashSet<Issue>();
        for (Issue issue : issueArray) {
            assert (issue != null);
            hashSet.add(issue);
        }
        this.issuesCached.put(repository, hashSet);
    }

    synchronized Issue[] getCachedIssues(Repository repository) {
        Set<Issue> set;
        if (this.issuesCached != null && (set = this.issuesCached.get(repository)) != null) {
            return set.toArray(new Issue[set.size()]);
        }
        return new Issue[0];
    }

    @Override
    public int getSize() {
        if (this.results == null) {
            return 0;
        }
        return this.results.size();
    }

    @Override
    public Object getElementAt(int n) {
        if (this.results == null) {
            return null;
        }
        return this.results.get(n);
    }

    private void maybeFireChanges() {
        if (this.fireTimer == null) {
            this.fireTimer = new Timer(200, this);
        }
        if (!this.fireTimer.isRunning()) {
            this.fireTimer.start();
        } else {
            this.fireTimer.restart();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fireTimer.stop();
        this.fireContentsChanged(this, 0, this.getSize());
    }
}

