/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.selectors;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.Repository;
import org.openide.util.ImageUtilities;

public class RepositoryFormPanel
extends JPanel {
    private Collection<String> cardNames = new ArrayList<String>(6);
    private Repository selectedRepository = null;
    private BugtrackingController selectedFormController = null;
    private boolean isValidData = false;
    private JComponent cardsPanel;
    private JLabel errorLabel;
    private final FormDataListener formDataListener = new FormDataListener();
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>(4);
    private final ChangeEvent changeEvent = new ChangeEvent(this);

    public RepositoryFormPanel() {
        this.initComponents();
    }

    public RepositoryFormPanel(Repository repository, String string) {
        this();
        this.displayForm(repository);
        this.displayErrorMessage(string);
    }

    private void initComponents() {
        this.cardsPanel = new JPanel(new CardLayout());
        this.errorLabel = new JLabel();
        this.errorLabel.setForeground(new Color(153, 0, 0));
        this.errorLabel.setIcon(new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/error.gif")));
        this.updateErrorMessage(" ");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup().add((Component)this.cardsPanel).add((Component)this.errorLabel));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.cardsPanel).add(6, 14, 14).add((Component)this.errorLabel));
        groupLayout.setHonorsVisibility(false);
    }

    public boolean displayForm(Repository repository) {
        if (repository == this.selectedRepository) {
            return false;
        }
        boolean bl = this.isValidData;
        boolean bl2 = this.displayFormPanel(repository);
        if (this.isValidData != bl) {
            this.fireValidityChanged();
        }
        return bl2;
    }

    void displayErrorMessage(String string) {
        this.updateErrorMessage(string);
    }

    public Repository getSelectedRepository() {
        return this.selectedRepository;
    }

    private void checkDataValidity() {
        assert (this.selectedFormController != null);
        boolean bl = this.isValidData;
        this.isValidData = this.selectedFormController.isValid();
        this.updateErrorMessage(this.selectedFormController.getErrorMessage());
        if (this.isValidData != bl) {
            this.fireValidityChanged();
        }
    }

    private void updateErrorMessage(String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string != null && string.length() != 0) {
            this.errorLabel.setText(string);
            this.errorLabel.setVisible(true);
        } else {
            this.errorLabel.setVisible(false);
            this.errorLabel.setText(" ");
        }
    }

    private boolean displayFormPanel(Repository repository) {
        if (repository == this.selectedRepository) {
            return false;
        }
        this.stopListeningOnController();
        String string = RepositoryFormPanel.getCardName(repository);
        BugtrackingController bugtrackingController = repository.getController();
        boolean bl = this.registerCard(string);
        if (bl) {
            this.cardsPanel.add((Component)bugtrackingController.getComponent(), string);
        }
        ((CardLayout)this.cardsPanel.getLayout()).show(this.cardsPanel, string);
        this.selectedFormController = bugtrackingController;
        this.selectedRepository = repository;
        this.startListeningOnController();
        this.checkDataValidity();
        return bl;
    }

    private void startListeningOnController() {
        this.selectedFormController.addPropertyChangeListener(this.formDataListener);
    }

    private void stopListeningOnController() {
        if (this.selectedFormController != null) {
            assert (this.formDataListener != null);
            this.selectedFormController.removePropertyChangeListener(this.formDataListener);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.stopListeningOnController();
    }

    private static String getCardName(Repository repository) {
        return Integer.toString(System.identityHashCode(repository), 36);
    }

    private boolean registerCard(String string) {
        if (!this.cardNames.contains(string)) {
            this.cardNames.add(string);
            return true;
        }
        return false;
    }

    public boolean isValidData() {
        return this.isValidData;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    private void fireValidityChanged() {
        if (!this.listeners.isEmpty()) {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(this.changeEvent);
            }
        }
    }

    class FormDataListener
    implements PropertyChangeListener {
        FormDataListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (BugtrackingController.EVENT_COMPONENT_DATA_CHANGED.equals(propertyChangeEvent.getPropertyName())) {
                RepositoryFormPanel.this.checkDataValidity();
            }
        }
    }
}

