/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.fake.modules;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindComponentModules {
    private Collection<String> codeNames;
    public final String DO_CHECK = "do-check";
    private final String ENABLE_LATER = "enable-later";
    private Collection<UpdateElement> forInstall = null;
    private Collection<UpdateElement> forEnable = null;
    private RequestProcessor.Task componentModulesFindingTask = null;
    private RequestProcessor.Task enableLaterTask = null;
    private Runnable doFind = new Runnable(){

        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(FindComponentModules.this.doFind);
                return;
            }
            FindComponentModules.this.findComponentModules();
        }
    };

    public FindComponentModules(String ... stringArray) {
        this.codeNames = stringArray == null ? Collections.emptySet() : Arrays.asList(stringArray);
    }

    public RequestProcessor.Task getFindingTask() {
        return this.componentModulesFindingTask;
    }

    public RequestProcessor.Task createFindingTask() {
        assert (this.componentModulesFindingTask == null || this.componentModulesFindingTask.isFinished()) : "The Finding Task cannot be started nor scheduled.";
        this.componentModulesFindingTask = RequestProcessor.getDefault().create(this.doFind);
        return this.componentModulesFindingTask;
    }

    public Collection<UpdateElement> getModulesForInstall() {
        assert (this.forInstall != null) : "candidates cannot be null if getModulesForInstall() is called.";
        return this.forInstall;
    }

    public void clearModulesForInstall() {
        this.forInstall = null;
        this.componentModulesFindingTask = null;
        this.enableLaterTask = null;
    }

    public void writeEnableLater(Collection<UpdateElement> collection) {
        Preferences preferences = FindComponentModules.getPreferences();
        if (collection == null) {
            preferences.remove("enable-later");
            return;
        }
        String string = "";
        for (UpdateElement updateElement : collection) {
            string = string + (string.length() == 0 ? updateElement.getCodeName() : ", " + updateElement.getCodeName());
        }
        if (string.trim().length() == 0) {
            preferences.remove("enable-later");
        } else {
            preferences.put("enable-later", string);
        }
    }

    public Collection<UpdateElement> getModulesForEnable() {
        assert (this.forEnable != null) : "candidates cannot be null if getModulesForInstall() is called.";
        return this.forEnable;
    }

    private Collection<UpdateElement> readEnableLater() {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        Preferences preferences = FindComponentModules.getPreferences();
        String string = preferences.get("enable-later", null);
        if (string != null && string.trim().length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string2 = ((String)stringTokenizer.nextElement()).trim();
                UpdateElement updateElement = FindComponentModules.findUpdateElement(string2, true);
                if (updateElement == null) continue;
                hashSet.add(updateElement);
            }
        }
        return hashSet;
    }

    public static Collection<UpdateElement> getVisibleUpdateElements(Collection<UpdateElement> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateElement updateElement : new LinkedList<UpdateElement>(collection)) {
            if (!UpdateManager.TYPE.KIT_MODULE.equals((Object)updateElement.getUpdateUnit().getType())) continue;
            hashSet.add(updateElement);
        }
        return hashSet;
    }

    public static Preferences getPreferences() {
        return NbPreferences.forModule(FindComponentModules.class);
    }

    private void findComponentModules() {
        List list = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
        Collection<UpdateElement> collection = this.getMissingModules(list);
        this.forInstall = this.getAllForInstall(collection);
        Collection<UpdateElement> collection2 = this.getDisabledModules(list);
        this.forEnable = this.getAllForEnable(collection2);
    }

    private Collection<UpdateElement> getMissingModules(Collection<UpdateUnit> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateUnit updateUnit : collection) {
            if (updateUnit.getInstalled() != null || !this.codeNames.contains(updateUnit.getCodeName())) continue;
            hashSet.add((UpdateElement)updateUnit.getAvailableUpdates().get(0));
        }
        return hashSet;
    }

    private Collection<UpdateElement> getAllForInstall(Collection<UpdateElement> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateElement updateElement : collection) {
            OperationContainer.OperationInfo operationInfo;
            OperationContainer operationContainer = OperationContainer.createForInstall();
            if (!operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement) || (operationInfo = operationContainer.add(updateElement)) == null) continue;
            Set set = operationInfo.getRequiredElements();
            operationContainer.add((Collection)set);
            Set set2 = operationInfo.getBrokenDependencies();
            if (!set2.isEmpty()) continue;
            hashSet.add(updateElement);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private Collection<UpdateElement> getDisabledModules(Collection<UpdateUnit> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateUnit updateUnit : collection) {
            if (updateUnit.getInstalled() == null || !this.codeNames.contains(updateUnit.getCodeName()) || updateUnit.getInstalled().isEnabled()) continue;
            hashSet.add(updateUnit.getInstalled());
        }
        return hashSet;
    }

    private Collection<UpdateElement> getAllForEnable(Collection<UpdateElement> collection) {
        HashSet<UpdateElement> hashSet = new HashSet<UpdateElement>();
        for (UpdateElement updateElement : collection) {
            OperationContainer.OperationInfo operationInfo;
            OperationContainer operationContainer = OperationContainer.createForEnable();
            if (!operationContainer.canBeAdded(updateElement.getUpdateUnit(), updateElement) || (operationInfo = operationContainer.add(updateElement)) == null) continue;
            Set set = operationInfo.getRequiredElements();
            operationContainer.add((Collection)set);
            Set set2 = operationInfo.getBrokenDependencies();
            if (!set2.isEmpty()) continue;
            hashSet.add(updateElement);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    private static UpdateElement findUpdateElement(String string, boolean bl) {
        UpdateElement updateElement = null;
        for (UpdateUnit updateUnit : UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE})) {
            if (!string.equals(updateUnit.getCodeName())) continue;
            if (bl && updateUnit.getInstalled() != null) {
                updateElement = updateUnit.getInstalled();
                break;
            }
            if (bl || updateUnit.getAvailableUpdates().isEmpty()) break;
            updateElement = (UpdateElement)updateUnit.getAvailableUpdates().get(0);
            break;
        }
        return updateElement;
    }
}

