/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;

public class ToggleCommentAction
extends ExtKit.ToggleCommentAction {
    public ToggleCommentAction() {
        super("");
    }

    public void actionPerformed(ActionEvent actionEvent, final JTextComponent jTextComponent) {
        if (jTextComponent != null) {
            if (!jTextComponent.isEditable() || !jTextComponent.isEnabled()) {
                jTextComponent.getToolkit().beep();
                return;
            }
            final BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
            final Caret caret = jTextComponent.getCaret();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)baseDocument);
            if (tokenHierarchy == null) {
                return;
            }
            final TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
            baseDocument.runAtomicAsUser(new Runnable(){

                public void run() {
                    try {
                        if (caret.isSelectionVisible()) {
                            int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                            int n2 = jTextComponent.getSelectionEnd();
                            if (n2 > 0 && Utilities.getRowStart((BaseDocument)baseDocument, (int)n2) == n2) {
                                --n2;
                            }
                            int n3 = Utilities.getRowCount((BaseDocument)baseDocument, (int)n, (int)n2);
                            ArrayList<String> arrayList = new ArrayList<String>(n3);
                            int n4 = n;
                            boolean bl = true;
                            for (int i = n3; i > 0; --i) {
                                String string = ToggleCommentAction.this.getRealMimeType(tokenSequence, n4);
                                arrayList.add(string);
                                bl = bl && ToggleCommentAction.this.isCommentedLine(baseDocument, string, n4);
                                n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n4, (int)1);
                            }
                            n4 = n;
                            Iterator iterator = arrayList.iterator();
                            while (iterator.hasNext()) {
                                if (bl) {
                                    ToggleCommentAction.this.uncommentLine(baseDocument, (String)iterator.next(), n4);
                                } else {
                                    ToggleCommentAction.this.commentLine(baseDocument, (String)iterator.next(), n4);
                                }
                                n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n4, (int)1);
                            }
                        } else {
                            int n = Utilities.getRowStart((BaseDocument)baseDocument, (int)jTextComponent.getSelectionStart());
                            String string = ToggleCommentAction.this.getRealMimeType(tokenSequence, n);
                            if (ToggleCommentAction.this.isCommentedLine(baseDocument, string, n)) {
                                ToggleCommentAction.this.uncommentLine(baseDocument, string, n);
                            } else {
                                ToggleCommentAction.this.commentLine(baseDocument, string, n);
                            }
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        jTextComponent.getToolkit().beep();
                    }
                }
            });
        }
    }

    private String getRealMimeType(TokenSequence tokenSequence, int n) {
        while (true) {
            tokenSequence.move(n);
            if (!tokenSequence.moveNext()) break;
            n = tokenSequence.offset();
            TokenSequence tokenSequence2 = tokenSequence.embedded();
            if (tokenSequence2 == null) break;
            tokenSequence = tokenSequence2;
        }
        return tokenSequence.language().mimeType();
    }

    private void commentLine(BaseDocument baseDocument, String string, int n) throws BadLocationException {
        Object object;
        Feature feature = null;
        try {
            object = LanguagesManager.getDefault().getLanguage(string);
            feature = ((Language)object).getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        if (feature != null) {
            object = (String)feature.getValue("prefix");
            if (object == null) {
                return;
            }
            String string2 = (String)feature.getValue("suffix");
            if (string2 != null) {
                int n2 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                baseDocument.insertString(n2, string2, null);
            }
            baseDocument.insertString(n, (String)object, null);
        }
    }

    private void uncommentLine(BaseDocument baseDocument, String string, int n) throws BadLocationException {
        Object object;
        Feature feature = null;
        try {
            object = LanguagesManager.getDefault().getLanguage(string);
            feature = ((Language)object).getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        if (feature != null) {
            CharSequence charSequence;
            int n2;
            int n3;
            object = (String)feature.getValue("prefix");
            if (object == null) {
                return;
            }
            String string2 = (String)feature.getValue("suffix");
            if (string2 != null && (n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) != -1) {
                n2 = string2.length();
                if (n3 - Utilities.getRowStart((BaseDocument)baseDocument, (int)n) >= n2 && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)(n3 - n2 + 1), (int)n2)), (CharSequence)string2)) {
                    baseDocument.remove(n3 - n2 + 1, n2);
                }
            }
            if ((n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n)) != -1) {
                n2 = ((String)object).length();
                if (Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3) - n3 >= ((String)object).length() && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n3, (int)n2)), (CharSequence)object)) {
                    baseDocument.remove(n3, n2);
                }
            }
        }
    }

    private boolean isCommentedLine(BaseDocument baseDocument, String string, int n) throws BadLocationException {
        Object object;
        Feature feature = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = LanguagesManager.getDefault().getLanguage(string);
            feature = ((Language)object).getFeatureList().getFeature("COMMENT_LINE");
        }
        catch (LanguageDefinitionNotFoundException languageDefinitionNotFoundException) {
            // empty catch block
        }
        if (feature != null) {
            CharSequence charSequence;
            int n2;
            int n3;
            object = (String)feature.getValue("prefix");
            if (object == null) {
                return true;
            }
            String string2 = (String)feature.getValue("suffix");
            if (string2 != null) {
                n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n);
                if (n3 != -1) {
                    n2 = string2.length();
                    if (n3 - Utilities.getRowStart((BaseDocument)baseDocument, (int)n) >= n2 && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)(n3 - n2 + 1), (int)n2)), (CharSequence)string2)) {
                        bl = true;
                    }
                }
            } else {
                bl = true;
            }
            n3 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
            if (n3 != -1) {
                n2 = ((String)object).length();
                if (Utilities.getRowEnd((BaseDocument)baseDocument, (int)n3) - n3 >= ((String)object).length() && CharSequenceUtilities.textEquals((CharSequence)(charSequence = DocumentUtilities.getText((Document)baseDocument, (int)n3, (int)n2)), (CharSequence)object)) {
                    bl2 = true;
                }
            }
            return bl2 && bl;
        }
        return true;
    }
}

