/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.constantine.platform;

import com.kenai.constantine.Constant;
import com.kenai.constantine.ConstantSet;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantResolver<E extends Enum<E>> {
    public static final String __UNKNOWN_CONSTANT__ = "__UNKNOWN_CONSTANT__";
    private final Object modLock = new Object();
    private final Class<E> enumType;
    private final Map<Integer, E> reverseLookupMap = new ConcurrentHashMap<Integer, E>();
    private final AtomicInteger nextUnknown;
    private final int lastUnknown;
    private Constant[] cache = null;
    private volatile E[] valueCache = null;
    private volatile int cacheGuard = 0;
    private volatile ConstantSet constants;

    private ConstantResolver(Class<E> enumType) {
        this(enumType, Integer.MIN_VALUE, -2147482648);
    }

    private ConstantResolver(Class<E> enumType, int firstUnknown, int lastUnknown) {
        this.enumType = enumType;
        this.nextUnknown = new AtomicInteger(firstUnknown);
        this.lastUnknown = lastUnknown;
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType) {
        return new ConstantResolver<T>(enumType);
    }

    static final <T extends Enum<T>> ConstantResolver<T> getResolver(Class<T> enumType, int first2, int last2) {
        return new ConstantResolver<T>(enumType, first2, last2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Constant getConstant(E e) {
        Constant c;
        if (this.cacheGuard != 0 && (c = this.cache[((Enum)e).ordinal()]) != null) {
            return c;
        }
        Object object = this.modLock;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new Constant[EnumSet.allOf(this.enumType).size()];
            }
            if ((c = this.getConstants().getConstant(((Enum)e).name())) == null) {
                c = new UnknownConstant(this.nextUnknown.getAndAdd(1), ((Enum)e).name());
                this.reverseLookupMap.put(c.value(), e);
            }
            this.cache[((Enum)e).ordinal()] = c;
            ++this.cacheGuard;
        }
        return c;
    }

    final int intValue(E e) {
        return this.getConstant(e).value();
    }

    final String description(E e) {
        return this.getConstant(e).toString();
    }

    final E valueOf(int value2) {
        Enum e;
        if (value2 >= 0 && value2 < 256 && this.valueCache != null && (e = this.valueCache[value2]) != null) {
            return (E)e;
        }
        e = (Enum)this.reverseLookupMap.get(value2);
        if (e != null) {
            return (E)e;
        }
        Constant c = this.getConstants().getConstant(value2);
        if (c != null) {
            try {
                e = Enum.valueOf(this.enumType, c.name());
                this.reverseLookupMap.put(value2, e);
                if (c.value() >= 0 && c.value() < 256) {
                    Object[] values = this.valueCache;
                    if (values == null) {
                        values = (Enum[])Array.newInstance(this.enumType, 256);
                    }
                    values[c.value()] = e;
                    this.valueCache = values;
                }
                return (E)e;
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
        return Enum.valueOf(this.enumType, __UNKNOWN_CONSTANT__);
    }

    private final ConstantSet getConstants() {
        if (this.constants == null) {
            this.constants = ConstantSet.getConstantSet(this.enumType.getSimpleName());
            if (this.constants == null) {
                throw new RuntimeException("Could not load platform constants for " + this.enumType.getSimpleName());
            }
        }
        return this.constants;
    }

    private static final class UnknownConstant
    implements Constant {
        private final int value;
        private final String name;

        UnknownConstant(int value2, String name2) {
            this.value = value2;
            this.name = name2;
        }

        public int value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

