/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    private static final String stubLibraryName = "jffi";
    private final OS os;
    private final CPU cpu;
    private final int addressSize;
    private final long addressMask;
    private final int javaVersionMajor;

    private static final OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (osName.startsWith("mac") || osName.startsWith("darwin")) {
            return OS.DARWIN;
        }
        if (osName.startsWith("linux")) {
            return OS.LINUX;
        }
        if (osName.startsWith("sunos") || osName.startsWith("solaris")) {
            return OS.SOLARIS;
        }
        if (osName.startsWith("openbsd")) {
            return OS.OPENBSD;
        }
        if (osName.startsWith("freebsd")) {
            return OS.FREEBSD;
        }
        if (osName.startsWith("windows")) {
            return OS.WINDOWS;
        }
        throw new ExceptionInInitializerError("Unsupported operating system");
    }

    private static final Platform determinePlatform(OS os) {
        switch (os) {
            case DARWIN: {
                return new Darwin();
            }
            case LINUX: {
                return new Linux();
            }
            case WINDOWS: {
                return new Windows();
            }
            case UNKNOWN: {
                throw new ExceptionInInitializerError("Unsupported operating system");
            }
        }
        return new Default(os);
    }

    private static final CPU determineCPU() {
        String archString = System.getProperty("os.arch").toLowerCase();
        if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
            return CPU.I386;
        }
        if ("x86_64".equals(archString) || "amd64".equals(archString)) {
            return CPU.X86_64;
        }
        if ("ppc".equals(archString) || "powerpc".equals(archString)) {
            return CPU.POWERPC;
        }
        if ("ppc64".equals(archString)) {
            return CPU.POWERPC64;
        }
        throw new ExceptionInInitializerError("Unsupported CPU architecture: " + archString);
    }

    private Platform(OS os) {
        this.os = os;
        this.cpu = Platform.determineCPU();
        int dataModel = Integer.getInteger("sun.arch.data.model");
        if (dataModel != 32 && dataModel != 64) {
            switch (this.cpu) {
                case I386: 
                case POWERPC: 
                case SPARC: {
                    dataModel = 32;
                    break;
                }
                case X86_64: 
                case POWERPC64: 
                case SPARCV9: {
                    dataModel = 64;
                    break;
                }
                default: {
                    throw new ExceptionInInitializerError("Cannot determine cpu address size");
                }
            }
        }
        this.addressSize = dataModel;
        this.addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
        int version2 = 5;
        try {
            String versionString = System.getProperty("java.version");
            if (versionString != null) {
                String[] v = versionString.split("\\.");
                version2 = Integer.valueOf(v[1]);
            }
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Could not determine java version");
        }
        this.javaVersionMajor = version2;
    }

    public static final Platform getPlatform() {
        return SingletonHolder.PLATFORM;
    }

    public final OS getOS() {
        return this.os;
    }

    public final CPU getCPU() {
        return this.cpu;
    }

    public final int getJavaMajorVersion() {
        return this.javaVersionMajor;
    }

    public final int longSize() {
        return this.addressSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public String getName() {
        String osName = System.getProperty("os.name").split(" ")[0];
        return System.getProperty("os.arch") + "-" + osName;
    }

    public String mapLibraryName(String libName) {
        if (libName.matches(this.getLibraryNamePattern())) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    public String getLibraryNamePattern() {
        return "lib.*\\.so.*$";
    }

    public File locateLibrary(String libName, List<String> libraryPath) {
        String mappedName = this.mapLibraryName(libName);
        for (String path2 : libraryPath) {
            File libFile = new File(path2, mappedName);
            if (!libFile.exists()) continue;
            return libFile;
        }
        return new File(mappedName);
    }

    public String getStubLibraryName() {
        return stubLibraryName;
    }

    public String getStubLibraryPath() {
        return "/jni/" + this.getName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    public InputStream getStubLibraryStream() {
        return Platform.class.getResourceAsStream(this.getStubLibraryPath());
    }

    public boolean isSupported() {
        try {
            Foreign.getInstance().isRawParameterPackingEnabled();
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static /* synthetic */ OS access$000() {
        return Platform.determineOS();
    }

    static /* synthetic */ Platform access$100(OS x0) {
        return Platform.determinePlatform(x0);
    }

    private static class Windows
    extends Platform {
        public Windows() {
            super(OS.WINDOWS);
        }

        public String getLibraryNamePattern() {
            return ".*\\.dll$";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Linux
    extends Platform {
        public Linux() {
            super(OS.LINUX);
        }

        @Override
        public File locateLibrary(final String libName, List<String> libraryPath) {
            FilenameFilter filter = new FilenameFilter(){
                Pattern p;
                String exact;
                {
                    this.p = Pattern.compile("lib" + libName + "\\.so\\.[0-9]+$");
                    this.exact = "lib" + libName + ".so";
                }

                public boolean accept(File dir, String name2) {
                    return this.p.matcher(name2).matches() || this.exact.equals(name2);
                }
            };
            LinkedList<File> matches = new LinkedList<File>();
            for (String path2 : libraryPath) {
                File[] files = new File(path2).listFiles(filter);
                if (files == null || files.length <= 0) continue;
                matches.addAll(Arrays.asList(files));
            }
            int version2 = 0;
            String bestMatch = null;
            for (File file2 : matches) {
                String path3 = file2.getAbsolutePath();
                if (bestMatch == null && path3.endsWith(".so")) {
                    bestMatch = path3;
                    version2 = 0;
                    continue;
                }
                String num = path3.substring(path3.lastIndexOf(".so.") + 4);
                try {
                    if (Integer.parseInt(num) < version2) continue;
                    bestMatch = path3;
                }
                catch (NumberFormatException e) {}
            }
            return bestMatch != null ? new File(bestMatch) : new File(this.mapLibraryName(libName));
        }
    }

    private static final class Darwin
    extends Platform {
        public Darwin() {
            super(OS.DARWIN);
        }

        public String mapLibraryName(String libName) {
            if (libName.matches(this.getLibraryNamePattern())) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }

        public String getLibraryNamePattern() {
            return "lib.*\\.(dylib|jnilib)$";
        }

        public InputStream getStubLibraryStream() {
            InputStream is = super.getStubLibraryStream();
            if (is != null) {
                return is;
            }
            return Platform.class.getResourceAsStream(this.getStubLibraryPath().replaceAll("dylib", "jnilib"));
        }

        public String getName() {
            return "Darwin";
        }
    }

    private static final class Default
    extends Platform {
        public Default(OS os) {
            super(os);
        }
    }

    private static final class SingletonHolder {
        static final Platform PLATFORM = Platform.access$100(Platform.access$000());

        private SingletonHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        I386,
        X86_64,
        POWERPC,
        POWERPC64,
        SPARC,
        SPARCV9,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        UNKNOWN;

    }
}

