/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class Native {
    private static Map typeMappers = new WeakHashMap();
    private static Map alignments = new WeakHashMap();
    private static Map options = new WeakHashMap();
    private static Map libraries = new WeakHashMap();
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    private static final ThreadLocal lastError;

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static synchronized native void setPreserveLastError(boolean var0);

    public static synchronized native boolean getPreserveLastError();

    public static long getWindowID(Window w) throws HeadlessException {
        return Native.getComponentID(w);
    }

    public static long getComponentID(Component c) throws HeadlessException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException("No native windows when headless");
        }
        if (c.isLightweight()) {
            throw new IllegalArgumentException("Component must be heavyweight");
        }
        if (!c.isDisplayable()) {
            throw new IllegalStateException("Component must be displayable");
        }
        if (Platform.isX11() && System.getProperty("java.version").startsWith("1.4") && !c.isVisible()) {
            throw new IllegalStateException("Component must be visible");
        }
        return Native.getWindowHandle0(c);
    }

    public static Pointer getWindowPointer(Window w) throws HeadlessException {
        return Native.getComponentPointer(w);
    }

    public static Pointer getComponentPointer(Component c) throws HeadlessException {
        return new Pointer(Native.getComponentID(c));
    }

    private static native long getWindowHandle0(Component var0);

    public static Pointer getByteBufferPointer(ByteBuffer b) {
        return Native.getDirectBufferPointer(b);
    }

    public static native Pointer getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] buf) {
        int term;
        String encoding2 = System.getProperty("jna.encoding");
        String s = null;
        if (encoding2 != null) {
            try {
                s = new String(buf, encoding2);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new String(buf);
        }
        if ((term = s.indexOf(0)) != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static String toString(char[] buf) {
        String s = new String(buf);
        int term = s.indexOf(0);
        if (term != -1) {
            s = s.substring(0, term);
        }
        return s;
    }

    public static Object loadLibrary(String name2, Class interfaceClass) {
        return Native.loadLibrary(name2, interfaceClass, Collections.EMPTY_MAP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object loadLibrary(String name2, Class interfaceClass, Map libOptions) {
        Library.Handler handler = new Library.Handler(name2, interfaceClass, libOptions);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy2 = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler);
        Map map = libraries;
        synchronized (map) {
            if (!libOptions.isEmpty()) {
                options.put(interfaceClass, libOptions);
            }
            if (libOptions.containsKey("type-mapper")) {
                typeMappers.put(interfaceClass, libOptions.get("type-mapper"));
            }
            if (libOptions.containsKey("structure-alignment")) {
                alignments.put(interfaceClass, libOptions.get("structure-alignment"));
            }
            libraries.put(interfaceClass, new WeakReference<Library>(proxy2));
        }
        return proxy2;
    }

    private static void loadLibraryInstance(Class cls) {
        if (cls != null && !libraries.containsKey(cls)) {
            try {
                Field[] fields2 = cls.getFields();
                for (int i = 0; i < fields2.length; ++i) {
                    Field field2 = fields2[i];
                    if (field2.getType() != cls || !Modifier.isStatic(field2.getModifiers())) continue;
                    libraries.put(cls, new WeakReference<Object>(field2.get(null)));
                    break;
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e + ")");
            }
        }
    }

    static Class findCallbackClass(Class type2) {
        if (!Callback.class.isAssignableFrom(type2)) {
            throw new IllegalArgumentException(type2.getName() + " is not derived from com.sun.jna.Callback");
        }
        if (type2.isInterface()) {
            return type2;
        }
        Class<?>[] ifaces = type2.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (!(class$com$sun$jna$Callback == null ? Native.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(ifaces[i])) continue;
            if (ifaces[i].getMethods().length != 1) break;
            return ifaces[i];
        }
        if (Callback.class.isAssignableFrom(type2.getSuperclass())) {
            return Native.findCallbackClass(type2.getSuperclass());
        }
        return type2;
    }

    static Class findEnclosingLibraryClass(Class cls) {
        Class fromDeclaring;
        if (cls == null) {
            return null;
        }
        if (Library.class.isAssignableFrom(cls)) {
            return cls;
        }
        if (Callback.class.isAssignableFrom(cls)) {
            cls = Native.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type2) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findEnclosingLibraryClass(type2);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = type2;
            }
            if (!options.containsKey(interfaceClass)) {
                try {
                    Field field2 = interfaceClass.getField("OPTIONS");
                    field2.setAccessible(true);
                    options.put(interfaceClass, field2.get(null));
                }
                catch (NoSuchFieldException e) {
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("OPTIONS must be a public field of type java.util.Map (" + e + "): " + interfaceClass);
                }
            }
            return (Map)options.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeMapper getTypeMapper(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!typeMappers.containsKey(interfaceClass)) {
                try {
                    Field field2 = interfaceClass.getField("TYPE_MAPPER");
                    field2.setAccessible(true);
                    typeMappers.put(interfaceClass, field2.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options2 = Native.getLibraryOptions(cls);
                    if (options2 != null && options2.containsKey("type-mapper")) {
                        typeMappers.put(interfaceClass, options2.get("type-mapper"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("TYPE_MAPPER must be a public field of type " + TypeMapper.class.getName() + " (" + e + "): " + interfaceClass);
                }
            }
            return (TypeMapper)typeMappers.get(interfaceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getStructureAlignment(Class cls) {
        Map map = libraries;
        synchronized (map) {
            Integer value2;
            Class interfaceClass = Native.findEnclosingLibraryClass(cls);
            if (interfaceClass != null) {
                Native.loadLibraryInstance(interfaceClass);
            } else {
                interfaceClass = cls;
            }
            if (!alignments.containsKey(interfaceClass)) {
                try {
                    Field field2 = interfaceClass.getField("STRUCTURE_ALIGNMENT");
                    field2.setAccessible(true);
                    alignments.put(interfaceClass, field2.get(null));
                }
                catch (NoSuchFieldException e) {
                    Map options2 = Native.getLibraryOptions(interfaceClass);
                    if (options2 != null && options2.containsKey("structure-alignment")) {
                        alignments.put(interfaceClass, options2.get("structure-alignment"));
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("STRUCTURE_ALIGNMENT must be a public field of type int (" + e + "): " + interfaceClass);
                }
            }
            int n = (value2 = (Integer)alignments.get(interfaceClass)) != null ? value2 : 0;
            return n;
        }
    }

    static byte[] getBytes(String s) {
        String encoding2 = System.getProperty("jna.encoding");
        if (encoding2 != null) {
            try {
                return s.getBytes(encoding2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return s.getBytes();
    }

    public static byte[] toByteArray(String s) {
        byte[] bytes2 = Native.getBytes(s);
        byte[] buf = new byte[bytes2.length + 1];
        System.arraycopy(bytes2, 0, buf, 0, bytes2.length);
        return buf;
    }

    public static char[] toCharArray(String s) {
        char[] chars2 = s.toCharArray();
        char[] buf = new char[chars2.length + 1];
        System.arraycopy(chars2, 0, buf, 0, chars2.length);
        return buf;
    }

    private static String getNativeLibraryResourcePath() {
        String osPrefix;
        String arch = System.getProperty("os.arch").toLowerCase();
        if (Platform.isWindows()) {
            osPrefix = "win32-" + arch;
        } else if (Platform.isMac()) {
            osPrefix = "darwin";
        } else if (Platform.isLinux()) {
            if ("x86".equals(arch)) {
                arch = "i386";
            } else if ("x86_64".equals(arch)) {
                arch = "amd64";
            }
            osPrefix = "linux-" + arch;
        } else if (Platform.isSolaris()) {
            osPrefix = "sunos-" + arch;
        } else {
            osPrefix = System.getProperty("os.name").toLowerCase();
            int space = osPrefix.indexOf(" ");
            if (space != -1) {
                osPrefix = osPrefix.substring(0, space);
            }
            osPrefix = osPrefix + "-" + arch;
        }
        return "/com/sun/jna/" + osPrefix;
    }

    private static void loadNativeLibrary() {
        String libName = "jnidispatch";
        String bootPath = System.getProperty("jna.boot.library.path");
        if (bootPath != null) {
            String[] dirs = bootPath.split(File.pathSeparator);
            for (int i = 0; i < dirs.length; ++i) {
                String path2 = new File(new File(dirs[i]), System.mapLibraryName(libName)).getAbsolutePath();
                try {
                    System.load(path2);
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    String ext2;
                    String orig;
                    if (!Platform.isMac()) continue;
                    if (path2.endsWith("dylib")) {
                        orig = "dylib";
                        ext2 = "jnilib";
                    } else {
                        orig = "jnilib";
                        ext2 = "dylib";
                    }
                    try {
                        System.load(path2.substring(0, path2.lastIndexOf(orig)) + ext2);
                        return;
                    }
                    catch (UnsatisfiedLinkError ex2) {
                        // empty catch block
                    }
                    continue;
                }
            }
        }
        try {
            System.loadLibrary(libName);
        }
        catch (UnsatisfiedLinkError e) {
            Native.loadNativeLibraryFromJar();
        }
    }

    private static void loadNativeLibraryFromJar() {
        String resourceName;
        String libname = System.mapLibraryName("jnidispatch");
        URL url = Native.class.getResource(resourceName = Native.getNativeLibraryResourcePath() + "/" + libname);
        if (url == null && Platform.isMac() && resourceName.endsWith(".dylib")) {
            resourceName = resourceName.substring(0, resourceName.lastIndexOf(".dylib")) + ".jnilib";
            url = Native.class.getResource(resourceName);
        }
        if (url == null) {
            throw new UnsatisfiedLinkError("jnidispatch (" + resourceName + ") not found in resource path");
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            lib = new File(URLDecoder.decode(url.getPath()));
        } else {
            InputStream is = Native.class.getResourceAsStream(resourceName);
            if (is == null) {
                throw new Error("Can't obtain jnidispatch InputStream");
            }
            FileOutputStream fos = null;
            try {
                int count2;
                lib = File.createTempFile("jna", null);
                lib.deleteOnExit();
                if (Platform.deleteNativeLibraryAfterVMExit()) {
                    Runtime.getRuntime().addShutdownHook(new DeleteNativeLibrary(lib));
                }
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count2 = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count2);
                }
            }
            catch (IOException e) {
                throw new Error("Failed to create temporary file for jnidispatch library: " + e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        System.load(lib.getAbsolutePath());
    }

    private static native int pointerSize();

    private static native int longSize();

    private static native int wideCharSize();

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static int getLastError() {
        return (Integer)lastError.get();
    }

    public static native void setLastError(int var0);

    static void updateLastError(int e) {
        lastError.set(new Integer(e));
    }

    public static Library synchronizedLibrary(final Library library) {
        Class<?> cls = library.getClass();
        if (!Proxy.isProxyClass(cls)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler ih = Proxy.getInvocationHandler(library);
        if (!(ih instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + ih);
        }
        final Library.Handler handler = (Library.Handler)ih;
        InvocationHandler newHandler = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object invoke(Object proxy2, Method method2, Object[] args2) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke(library, method2, args2);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(cls.getClassLoader(), cls.getInterfaces(), newHandler);
    }

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = Native.class.getClassLoader();
            Method m = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
            m.setAccessible(true);
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            String msg = "Library '" + libName + "' was not found by class loader " + cl;
            throw new IllegalArgumentException(msg);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getNativeSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            if (Structure.ByValue.class.isAssignableFrom(cls)) {
                return Structure.newInstance(cls).size();
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Buffer.class.isAssignableFrom(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException("Native size for type \"" + cls.getName() + "\" is unknown");
    }

    public static boolean isSupportedNativeType(Class cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static void main(String[] args2) {
        String version2;
        String DEFAULT_TITLE = "Java Native Access (JNA)";
        String UNKNOWN_VERSION = "unknown - package information missing";
        Package pkg = Native.class.getPackage();
        String title = pkg.getSpecificationTitle();
        if (title == null) {
            title = "Java Native Access (JNA)";
        }
        if ((version2 = pkg.getSpecificationVersion()) == null) {
            version2 = "unknown - package information missing";
        }
        title = title + " API Version " + version2;
        System.out.println(title);
        version2 = pkg.getImplementationVersion();
        if (version2 == null) {
            version2 = "unknown - package information missing";
        }
        System.out.println("Version: " + version2);
        System.out.println(" Native: " + Native.getNativeVersion() + " (" + Native.getAPIChecksum() + ")");
        System.exit(0);
    }

    static {
        Native.loadNativeLibrary();
        POINTER_SIZE = Native.pointerSize();
        LONG_SIZE = Native.longSize();
        WCHAR_SIZE = Native.wideCharSize();
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        lastError = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(0);
            }
        };
    }

    public static class DeleteNativeLibrary
    extends Thread {
        private File file;

        public DeleteNativeLibrary(File file2) {
            this.file = file2;
        }

        private boolean unload(String path2) {
            try {
                ClassLoader cl = this.getClass().getClassLoader();
                Field f = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = Native.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredField("nativeLibraries");
                f.setAccessible(true);
                List libs = (List)f.get(cl);
                Iterator i = libs.iterator();
                while (i.hasNext()) {
                    Object lib = i.next();
                    f = lib.getClass().getDeclaredField("name");
                    f.setAccessible(true);
                    String name2 = (String)f.get(lib);
                    if (!name2.equals(path2)) continue;
                    Method m = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                    m.setAccessible(true);
                    m.invoke(lib, new Object[0]);
                    return true;
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }

        public void run() {
            if (!this.unload(this.file.getAbsolutePath()) || !this.file.delete()) {
                try {
                    Runtime.getRuntime().exec(new String[]{System.getProperty("java.home") + "/bin/java", "-cp", System.getProperty("java.class.path"), this.getClass().getName(), this.file.getAbsolutePath()});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public static void main(String[] args2) {
            File file2;
            if (args2.length == 1 && (file2 = new File(args2[0])).exists()) {
                long start2 = System.currentTimeMillis();
                while (!file2.delete() && file2.exists()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if (System.currentTimeMillis() - start2 <= 5000L) continue;
                    System.err.println("Could not remove temp file: " + file2.getAbsolutePath());
                    break;
                }
            }
            System.exit(0);
        }
    }
}

