/*
 * Decompiled with CFR 0.152.
 */
package org.dynalang.mop.beans;

import java.lang.reflect.Member;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dynalang.mop.BaseMetaobjectProtocol;
import org.dynalang.mop.CallProtocol;
import org.dynalang.mop.beans.DynamicMethod;
import org.dynalang.mop.beans.Invocation;
import org.dynalang.mop.beans.OverloadedDynamicMethod;
import org.dynalang.mop.beans.OverloadedMethodUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OverloadedFixArgMethod<T extends Member> {
    private Class[][] marshalTypes;
    private final Map<ClassString, Object> selectorCache = new ConcurrentHashMap<ClassString, Object>();
    private final List<T> members = new LinkedList<T>();

    OverloadedFixArgMethod() {
    }

    void addMember(T member) {
        this.members.add(member);
        Class[] argTypes = OverloadedMethodUtilities.getParameterTypes(member);
        int l = argTypes.length;
        if (this.marshalTypes == null) {
            this.marshalTypes = new Class[l + 1][];
            this.marshalTypes[l] = argTypes;
        } else if (this.marshalTypes.length <= l) {
            Class[][] newMarshalTypes = new Class[l + 1][];
            System.arraycopy(this.marshalTypes, 0, newMarshalTypes, 0, this.marshalTypes.length);
            this.marshalTypes = newMarshalTypes;
            this.marshalTypes[l] = argTypes;
        } else {
            Class[] oldTypes = this.marshalTypes[l];
            if (oldTypes == null) {
                this.marshalTypes[l] = argTypes;
            } else {
                assert (oldTypes.length == l);
                for (int i = 0; i < l; ++i) {
                    oldTypes[i] = OverloadedMethodUtilities.getMostSpecificCommonType(oldTypes[i], argTypes[i]);
                }
            }
        }
    }

    Object createInvocation(Object target, Object[] args2, CallProtocol callProtocol) {
        int l;
        if (args2 == null) {
            args2 = DynamicMethod.NULL_ARGS;
        }
        if (this.marshalTypes.length <= (l = args2.length)) {
            return OverloadedDynamicMethod.NO_SUCH_METHOD;
        }
        Class[] types = this.marshalTypes[l];
        if (types == null) {
            return OverloadedDynamicMethod.NO_SUCH_METHOD;
        }
        assert (types.length == l);
        boolean argsCloned = false;
        for (int i = 0; i < l; ++i) {
            Object src = args2[i];
            Object dst = callProtocol.representAs(src, types[i]);
            if (dst == BaseMetaobjectProtocol.Results.noAuthority || dst == BaseMetaobjectProtocol.Results.noRepresentation) {
                return OverloadedDynamicMethod.NO_SUCH_METHOD;
            }
            if (dst == src) continue;
            if (!argsCloned) {
                args2 = (Object[])args2.clone();
            }
            args2[i] = dst;
        }
        ClassString<T> argTypes = new ClassString<T>(args2);
        Object objMember = this.selectorCache.get(argTypes);
        if (objMember == null) {
            objMember = argTypes.getMostSpecific(this.members);
            this.selectorCache.put(argTypes, objMember);
        }
        if (objMember instanceof Member) {
            return new Invocation<Member>(target, (Member)objMember, args2);
        }
        return objMember;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ClassString<T extends Member> {
        private final Class[] classes;
        private static final int MORE_SPECIFIC = 0;
        private static final int LESS_SPECIFIC = 1;
        private static final int INDETERMINATE = 2;

        ClassString(Object[] objects) {
            int l = objects.length;
            this.classes = new Class[l];
            for (int i = 0; i < l; ++i) {
                Object obj = objects[i];
                this.classes[i] = obj == null ? OverloadedMethodUtilities.OBJECT_CLASS : obj.getClass();
            }
        }

        Class[] getClasses() {
            return this.classes;
        }

        public int hashCode() {
            int hash2 = 0;
            for (int i = 0; i < this.classes.length; ++i) {
                hash2 ^= this.classes[i].hashCode();
            }
            return hash2;
        }

        public boolean equals(Object o) {
            if (o instanceof ClassString) {
                ClassString cs = (ClassString)o;
                if (cs.classes.length != this.classes.length) {
                    return false;
                }
                for (int i = 0; i < this.classes.length; ++i) {
                    if (cs.classes[i] == this.classes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        Object getMostSpecific(List<T> methods2) {
            LinkedList<T> applicables = this.getApplicables(methods2);
            if (applicables.isEmpty()) {
                return OverloadedDynamicMethod.NO_SUCH_METHOD;
            }
            if (applicables.size() == 1) {
                return applicables.getFirst();
            }
            LinkedList<Member> maximals = new LinkedList<Member>();
            for (Member applicable : applicables) {
                Class[] appArgs = OverloadedMethodUtilities.getParameterTypes(applicable);
                boolean lessSpecific = false;
                Iterator maximal = maximals.iterator();
                while (maximal.hasNext()) {
                    Member max2 = (Member)maximal.next();
                    Class[] maxArgs = OverloadedMethodUtilities.getParameterTypes(max2);
                    switch (ClassString.moreSpecific(appArgs, maxArgs)) {
                        case 0: {
                            maximal.remove();
                            break;
                        }
                        case 1: {
                            lessSpecific = true;
                        }
                    }
                }
                if (lessSpecific) continue;
                maximals.addLast(applicable);
            }
            if (maximals.size() > 1) {
                return OverloadedDynamicMethod.AMBIGUOUS_METHOD;
            }
            return maximals.getFirst();
        }

        private static int moreSpecific(Class[] c1, Class[] c2) {
            boolean c1MoreSpecific = false;
            boolean c2MoreSpecific = false;
            int cl1 = c1.length;
            int cl2 = c2.length;
            assert (cl1 == cl2);
            for (int i = 0; i < cl1; ++i) {
                if (c1[i] == c2[i]) continue;
                c1MoreSpecific = c1MoreSpecific || OverloadedMethodUtilities.isMoreSpecific(c1[i], c2[i]);
                c2MoreSpecific = c2MoreSpecific || OverloadedMethodUtilities.isMoreSpecific(c2[i], c1[i]);
            }
            if (c1MoreSpecific) {
                if (c2MoreSpecific) {
                    return 2;
                }
                return 0;
            }
            if (c2MoreSpecific) {
                return 1;
            }
            return 2;
        }

        LinkedList<T> getApplicables(List<T> methods2) {
            LinkedList<Member> list2 = new LinkedList<Member>();
            for (Member member : methods2) {
                if (!this.isApplicable(member)) continue;
                list2.add(member);
            }
            return list2;
        }

        private boolean isApplicable(T member) {
            int cl;
            Class[] formalTypes = OverloadedMethodUtilities.getParameterTypes(member);
            int fl = formalTypes.length;
            if (fl != (cl = this.classes.length)) {
                return false;
            }
            for (int i = 0; i < cl; ++i) {
                if (ClassString.isMethodInvocationConvertible(formalTypes[i], this.classes[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean isMethodInvocationConvertible(Class<?> formal, Class<?> actual) {
            if (formal.isAssignableFrom(actual)) {
                return true;
            }
            if (formal.isPrimitive()) {
                if (formal == Boolean.TYPE) {
                    return actual == Boolean.class;
                }
                if (formal == Character.TYPE) {
                    return actual == Character.class;
                }
                if (formal == Byte.TYPE && actual == Byte.class) {
                    return true;
                }
                if (formal == Short.TYPE && (actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Integer.TYPE && (actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Long.TYPE && (actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Float.TYPE && (actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
                if (formal == Double.TYPE && (actual == Double.class || actual == Float.class || actual == Long.class || actual == Integer.class || actual == Short.class || actual == Byte.class)) {
                    return true;
                }
            }
            return false;
        }
    }
}

