/*
 * Decompiled with CFR 0.152.
 */
package org.jcodings.util;

import org.jcodings.ascii.AsciiTables;
import org.jcodings.util.Hash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CaseInsensitiveBytesHash<V>
extends Hash<V> {
    public CaseInsensitiveBytesHash() {
    }

    public CaseInsensitiveBytesHash(int size2) {
        super(size2);
    }

    @Override
    protected void init() {
        this.head = new CaseInsensitiveBytesHashEntry();
    }

    public static int hashCode(byte[] bytes2, int p2, int end2) {
        int key2 = 0;
        while (p2 < end2) {
            key2 = (key2 << 16) + (key2 << 6) - key2 + AsciiTables.ToLowerCaseTable[bytes2[p2++] & 0xFF];
        }
        key2 += key2 >> 5;
        return key2;
    }

    public V put(byte[] bytes2, V value2) {
        return this.put(bytes2, 0, bytes2.length, value2);
    }

    public V put(byte[] bytes2, int p2, int end2, V value2) {
        this.checkResize();
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes2, p2, end2));
        int i = CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length);
        CaseInsensitiveBytesHashEntry entry = (CaseInsensitiveBytesHashEntry)this.table[i];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(bytes2, p2, end2)) {
                entry.value = value2;
                return value2;
            }
            entry = (CaseInsensitiveBytesHashEntry)entry.next;
        }
        this.table[i] = new CaseInsensitiveBytesHashEntry<V>(hash2, this.table[i], value2, bytes2, p2, end2, this.head);
        ++this.size;
        return null;
    }

    public void putDirect(byte[] bytes2, V value2) {
        this.putDirect(bytes2, 0, bytes2.length, value2);
    }

    public void putDirect(byte[] bytes2, int p2, int end2, V value2) {
        this.checkResize();
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes2, p2, end2));
        int i = CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length);
        this.table[i] = new CaseInsensitiveBytesHashEntry<V>(hash2, this.table[i], value2, bytes2, p2, end2, this.head);
        ++this.size;
    }

    public V get(byte[] bytes2) {
        return this.get(bytes2, 0, bytes2.length);
    }

    public V get(byte[] bytes2, int p2, int end2) {
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes2, p2, end2));
        CaseInsensitiveBytesHashEntry entry = (CaseInsensitiveBytesHashEntry)this.table[CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length)];
        while (entry != null) {
            if (entry.hash == hash2 && entry.equals(bytes2, p2, end2)) {
                return (V)entry.value;
            }
            entry = (CaseInsensitiveBytesHashEntry)entry.next;
        }
        return null;
    }

    public V delete(byte[] bytes2) {
        return this.delete(bytes2, 0, bytes2.length);
    }

    public V delete(byte[] bytes2, int p2, int end2) {
        int hash2 = CaseInsensitiveBytesHash.hashValue(CaseInsensitiveBytesHash.hashCode(bytes2, p2, end2));
        int i = CaseInsensitiveBytesHash.bucketIndex(hash2, this.table.length);
        CaseInsensitiveBytesHashEntry entry = (CaseInsensitiveBytesHashEntry)this.table[i];
        if (entry == null) {
            return null;
        }
        if (entry.hash == hash2 && entry.equals(bytes2, p2, end2)) {
            this.table[i] = entry.next;
            --this.size;
            entry.remove();
            return (V)entry.value;
        }
        while (entry.next != null) {
            Hash.HashEntry tmp = entry.next;
            if (tmp.hash == hash2 && entry.equals(bytes2, p2, end2)) {
                entry.next = entry.next.next;
                --this.size;
                tmp.remove();
                return tmp.value;
            }
            entry = (CaseInsensitiveBytesHashEntry)entry.next;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CaseInsensitiveBytesHashEntry<V>
    extends Hash.HashEntry<V> {
        public final byte[] bytes;
        public final int p;
        public final int end;

        public CaseInsensitiveBytesHashEntry(int hash2, Hash.HashEntry<V> next2, V value2, byte[] bytes2, int p2, int end2, Hash.HashEntry<V> head) {
            super(hash2, next2, value2, head);
            this.bytes = bytes2;
            this.p = p2;
            this.end = end2;
        }

        public CaseInsensitiveBytesHashEntry() {
            this.bytes = null;
            this.end = 0;
            this.p = 0;
        }

        public boolean equals(byte[] bytes2, int p2, int end2) {
            if (this.end - this.p != end2 - p2) {
                return false;
            }
            if (this.bytes == bytes2) {
                return true;
            }
            int q = this.p;
            while (q < this.end) {
                if (AsciiTables.ToLowerCaseTable[this.bytes[q++] & 0xFF] == AsciiTables.ToLowerCaseTable[bytes2[p2++] & 0xFF]) continue;
                return false;
            }
            return true;
        }
    }
}

